/*
 * Decompiled with CFR 0.152.
 */
package me.fzzyhmstrs.fzzy_config.networking;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.realmsclient.RealmsMainScreen;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.fzzyhmstrs.fzzy_config.FC;
import me.fzzyhmstrs.fzzy_config.FCC;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import me.fzzyhmstrs.fzzy_config.impl.ConfigApiImplClient;
import me.fzzyhmstrs.fzzy_config.impl.ValidScopesArgumentType;
import me.fzzyhmstrs.fzzy_config.impl.ValidSubScopesArgumentType;
import me.fzzyhmstrs.fzzy_config.networking.ConfigPermissionsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigReloadSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigSyncS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateC2SCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.ConfigUpdateS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.DynamicIdsS2CCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.SettingForwardCustomPayload;
import me.fzzyhmstrs.fzzy_config.networking.api.ClientPlayNetworkContext;
import me.fzzyhmstrs.fzzy_config.networking.impl.NetworkApiImpl;
import me.fzzyhmstrs.fzzy_config.registry.ClientConfigRegistry;
import me.fzzyhmstrs.fzzy_config.screen.PopupController;
import me.fzzyhmstrs.fzzy_config.screen.context.ContextType;
import me.fzzyhmstrs.fzzy_config.util.FcText;
import me.fzzyhmstrs.fzzy_config.util.PortingUtils;
import me.fzzyhmstrs.fzzy_config.validation.minecraft.ValidatedIdentifier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.gui.screens.multiplayer.JoinMultiplayerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.simple.SimpleChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00aa\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J7\u0010\u0018\u001a\u00020\u000f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\u00122\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010!\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b!\u0010\"J\u001d\u0010$\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020#2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b$\u0010%J\u001d\u0010'\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b'\u0010(J#\u0010+\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0004\b+\u0010,J#\u0010.\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020-2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0004\b.\u0010/J\u001d\u00100\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b0\u0010\"J#\u00101\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020 2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0004\b1\u00102J#\u00103\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020#2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0004\b3\u00104J#\u00105\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020&2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020*0)\u00a2\u0006\u0004\b5\u00106J\u001d\u00108\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u0002072\u0006\u0010\u001d\u001a\u00020\u001c\u00a2\u0006\u0004\b8\u00109J\u0017\u0010<\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020:H\u0002\u00a2\u0006\u0004\b<\u0010=J\u0017\u0010?\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020>H\u0002\u00a2\u0006\u0004\b?\u0010@J\r\u0010A\u001a\u00020\u000f\u00a2\u0006\u0004\bA\u0010\u0003J\u0017\u0010C\u001a\u00020\u000f2\u0006\u0010;\u001a\u00020BH\u0002\u00a2\u0006\u0004\bC\u0010DJ\u001d\u0010H\u001a\u00020\u000f2\f\u0010G\u001a\b\u0012\u0004\u0012\u00020F0EH\u0002\u00a2\u0006\u0004\bH\u0010IR\u0016\u0010J\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bJ\u0010K\u00a8\u0006L"}, d2={"Lme/fzzyhmstrs/fzzy_config/networking/NetworkEventsClient;", "", "<init>", "()V", "Lnet/minecraft/resources/ResourceLocation;", "id", "", "canSend", "(Lnet/minecraft/resources/ResourceLocation;)Z", "", "update", "Ljava/util/UUID;", "player", "scope", "summary", "", "forwardSetting", "(Ljava/lang/String;Ljava/util/UUID;Ljava/lang/String;Ljava/lang/String;)V", "", "serializedConfigs", "", "changeHistory", "", "playerPerm", "updateServer", "(Ljava/util/Map;Ljava/util/List;I)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;", "payload", "Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;", "context", "receiveSync", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;", "receivePerms", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;", "receiveUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;", "receiveForward", "(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Ljava/util/function/Supplier;", "Lnet/minecraftforge/network/NetworkEvent$Context;", "handleConfigurationConfigSync", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigSyncS2CCustomPayload;Ljava/util/function/Supplier;)V", "Lme/fzzyhmstrs/fzzy_config/networking/ConfigReloadSyncS2CCustomPayload;", "handleReloadConfigSync", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigReloadSyncS2CCustomPayload;Ljava/util/function/Supplier;)V", "handleFcPermsUpdate", "handlePermsUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigPermissionsS2CCustomPayload;Ljava/util/function/Supplier;)V", "handleUpdate", "(Lme/fzzyhmstrs/fzzy_config/networking/ConfigUpdateS2CCustomPayload;Ljava/util/function/Supplier;)V", "handleSettingForward", "(Lme/fzzyhmstrs/fzzy_config/networking/SettingForwardCustomPayload;Ljava/util/function/Supplier;)V", "Lme/fzzyhmstrs/fzzy_config/networking/DynamicIdsS2CCustomPayload;", "receiveDynamicIds", "(Lme/fzzyhmstrs/fzzy_config/networking/DynamicIdsS2CCustomPayload;Lme/fzzyhmstrs/fzzy_config/networking/api/ClientPlayNetworkContext;)V", "Lnet/minecraftforge/event/TickEvent$ClientTickEvent;", "event", "handleTick", "(Lnet/minecraftforge/event/TickEvent$ClientTickEvent;)V", "Lnet/minecraftforge/client/event/ScreenEvent$Init$Pre;", "registerConfigs", "(Lnet/minecraftforge/client/event/ScreenEvent$Init$Pre;)V", "registerClient", "Lnet/minecraftforge/client/event/RegisterClientCommandsEvent;", "registerCommands", "(Lnet/minecraftforge/client/event/RegisterClientCommandsEvent;)V", "Lcom/mojang/brigadier/CommandDispatcher;", "Lnet/minecraft/commands/CommandSourceStack;", "dispatcher", "registerClientCommands", "(Lcom/mojang/brigadier/CommandDispatcher;)V", "initialized", "Z", "fzzy_config"})
@SourceDebugExtension(value={"SMAP\nNetworkEventsClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetworkEventsClient.kt\nme/fzzyhmstrs/fzzy_config/networking/NetworkEventsClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class NetworkEventsClient {
    @NotNull
    public static final NetworkEventsClient INSTANCE = new NetworkEventsClient();
    private static boolean initialized;

    private NetworkEventsClient() {
    }

    public final boolean canSend(@NotNull ResourceLocation id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ClientPacketListener clientPacketListener = Minecraft.m_91087_().m_91403_();
        if (clientPacketListener == null) {
            return false;
        }
        ClientPacketListener handler = clientPacketListener;
        SimpleChannel simpleChannel = NetworkApiImpl.INSTANCE.getChannelMap$fzzy_config().get(id);
        return simpleChannel != null ? simpleChannel.isRemotePresent(handler.m_104910_()) : handler.m_6198_();
    }

    public final void forwardSetting(@NotNull String update, @NotNull UUID player, @NotNull String scope, @NotNull String summary) {
        Intrinsics.checkNotNullParameter((Object)update, (String)"update");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
        if (!this.canSend(SettingForwardCustomPayload.Companion.getId())) {
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer != null) {
                PortingUtils.INSTANCE.sendChat((Player)localPlayer, (Component)FcText.INSTANCE.translate("fc.config.forwarded_error.c2s", new Object[0]));
            }
            FC.INSTANCE.getLOGGER$fzzy_config().error("Can't forward setting; not connected to a server or server isn't accepting this type of data");
            FC.INSTANCE.getLOGGER$fzzy_config().error("Setting not sent:");
            FC.INSTANCE.getLOGGER$fzzy_config().warn(scope);
            FC.INSTANCE.getLOGGER$fzzy_config().warn(summary);
            return;
        }
        SettingForwardCustomPayload payload = new SettingForwardCustomPayload(update, player, scope, summary);
        ConfigApi.INSTANCE.network().send(payload, null);
    }

    public final void updateServer(@NotNull Map<String, String> serializedConfigs, @NotNull List<String> changeHistory, int playerPerm) {
        Intrinsics.checkNotNullParameter(serializedConfigs, (String)"serializedConfigs");
        Intrinsics.checkNotNullParameter(changeHistory, (String)"changeHistory");
        if (!this.canSend(ConfigUpdateC2SCustomPayload.Companion.getId())) {
            FC.INSTANCE.getLOGGER$fzzy_config().error("Can't send Config Update; not connected to a server or server isn't accepting this type of data");
            FC.INSTANCE.getLOGGER$fzzy_config().error("changes not sent:");
            for (String change : changeHistory) {
                FC.INSTANCE.getLOGGER$fzzy_config().warn(change);
            }
            return;
        }
        ConfigUpdateC2SCustomPayload payload = new ConfigUpdateC2SCustomPayload(serializedConfigs, changeHistory, playerPerm);
        ConfigApi.INSTANCE.network().send(payload, null);
    }

    public final void receiveSync(@NotNull ConfigSyncS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receiveSync$fzzy_config(payload.getId(), payload.getSerializedConfig(), arg_0 -> NetworkEventsClient.receiveSync$lambda$0(context, arg_0));
    }

    public final void receivePerms(@NotNull ConfigPermissionsS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receivePerms$fzzy_config(payload.getId(), payload.getPermissions());
    }

    public final void receiveUpdate(@NotNull ConfigUpdateS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receiveUpdate$fzzy_config(payload.getUpdates(), (Player)context.player());
    }

    public final void receiveForward(@NotNull SettingForwardCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.handleForwardedUpdate$fzzy_config(payload.getUpdate(), payload.getPlayer(), payload.getScope(), payload.getSummary());
    }

    public final void handleConfigurationConfigSync(@NotNull ConfigSyncS2CCustomPayload payload, @NotNull Supplier<NetworkEvent.Context> context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        ClientConfigRegistry.INSTANCE.receiveSync$fzzy_config(payload.getId(), payload.getSerializedConfig(), arg_0 -> NetworkEventsClient.handleConfigurationConfigSync$lambda$1(context, arg_0));
        context.get().setPacketHandled(true);
    }

    public final void handleReloadConfigSync(@NotNull ConfigReloadSyncS2CCustomPayload payload, @NotNull Supplier<NetworkEvent.Context> context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            context.get().setPacketHandled(true);
            return;
        }
        ClientConfigRegistry.INSTANCE.receiveReloadSync$fzzy_config(payload.getId(), payload.getSerializedConfig(), (Player)player);
        context.get().setPacketHandled(true);
    }

    public final void handleFcPermsUpdate(@NotNull ConfigPermissionsS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ClientConfigRegistry.INSTANCE.receivePerms$fzzy_config(payload.getId(), payload.getPermissions());
    }

    public final void handlePermsUpdate(@NotNull ConfigPermissionsS2CCustomPayload payload, @NotNull Supplier<NetworkEvent.Context> context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        ClientConfigRegistry.INSTANCE.receivePerms$fzzy_config(payload.getId(), payload.getPermissions());
        context.get().setPacketHandled(true);
    }

    public final void handleUpdate(@NotNull ConfigUpdateS2CCustomPayload payload, @NotNull Supplier<NetworkEvent.Context> context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            context.get().setPacketHandled(true);
            return;
        }
        ClientConfigRegistry.INSTANCE.receiveUpdate$fzzy_config(payload.getUpdates(), (Player)player);
        context.get().setPacketHandled(true);
    }

    public final void handleSettingForward(@NotNull SettingForwardCustomPayload payload, @NotNull Supplier<NetworkEvent.Context> context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter(context, (String)"context");
        ClientConfigRegistry.INSTANCE.handleForwardedUpdate$fzzy_config(payload.getUpdate(), payload.getPlayer(), payload.getScope(), payload.getSummary());
    }

    public final void receiveDynamicIds(@NotNull DynamicIdsS2CCustomPayload payload, @NotNull ClientPlayNetworkContext context) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ValidatedIdentifier.Companion.receiveSync$fzzy_config(payload);
    }

    private final void handleTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        FCC.INSTANCE.withScope(NetworkEventsClient::handleTick$lambda$2);
        FCC.INSTANCE.withRestart(NetworkEventsClient::handleTick$lambda$3);
        PopupController.Companion.popAll$fzzy_config();
    }

    private final void registerConfigs(ScreenEvent.Init.Pre event) {
        if (!(event.getScreen() instanceof TitleScreen) || initialized) {
            return;
        }
        ModList.get().forEachModInOrder(NetworkEventsClient::registerConfigs$lambda$6);
        initialized = true;
    }

    public final void registerClient() {
        ContextType.Companion.init$fzzy_config();
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        MinecraftForge.EVENT_BUS.addListener(this::handleTick);
        MinecraftForge.EVENT_BUS.addListener(this::registerConfigs);
    }

    private final void registerCommands(RegisterClientCommandsEvent event) {
        CommandDispatcher commandDispatcher = event.getDispatcher();
        Intrinsics.checkNotNullExpressionValue((Object)commandDispatcher, (String)"getDispatcher(...)");
        this.registerClientCommands((CommandDispatcher<CommandSourceStack>)commandDispatcher);
    }

    private final void registerClientCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"configure").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"base_scope", (ArgumentType)new ValidScopesArgumentType()).executes(NetworkEventsClient::registerClientCommands$lambda$7)).then(Commands.m_82129_((String)"sub_scope", (ArgumentType)new ValidSubScopesArgumentType()).executes(NetworkEventsClient::registerClientCommands$lambda$9))));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"fzzy_config_restart").executes(NetworkEventsClient::registerClientCommands$lambda$10));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"fzzy_config_leave_game").executes(NetworkEventsClient::registerClientCommands$lambda$11));
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"fzzy_config_reload_resources").executes(NetworkEventsClient::registerClientCommands$lambda$12));
    }

    private static final void receiveSync$lambda$0(ClientPlayNetworkContext $context, Component text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        $context.disconnect(text);
    }

    private static final void handleConfigurationConfigSync$lambda$1(Supplier $context, Component text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ((NetworkEvent.Context)$context.get()).getNetworkManager().m_129507_(text);
    }

    private static final void handleTick$lambda$2(String scopeToOpen) {
        Intrinsics.checkNotNullParameter((Object)scopeToOpen, (String)"scopeToOpen");
        if (!Intrinsics.areEqual((Object)scopeToOpen, (Object)"")) {
            ClientConfigRegistry.INSTANCE.openScreen$fzzy_config(scopeToOpen);
        }
    }

    private static final Boolean handleTick$lambda$3(Boolean openRestartScreen) {
        Intrinsics.checkNotNullParameter((Object)openRestartScreen, (String)"openRestartScreen");
        return openRestartScreen != false ? Boolean.valueOf(ConfigApiImplClient.INSTANCE.openRestartScreen$fzzy_config()) : Boolean.valueOf(false);
    }

    private static final Screen registerConfigs$lambda$6$lambda$5$lambda$4(String $id, Minecraft minecraft, Screen screen) {
        Intrinsics.checkNotNull((Object)$id);
        Screen screen2 = ClientConfigRegistry.INSTANCE.provideScreen$fzzy_config($id);
        if (screen2 == null) {
            screen2 = screen;
        }
        return screen2;
    }

    private static final ConfigScreenHandler.ConfigScreenFactory registerConfigs$lambda$6$lambda$5(String $id) {
        return new ConfigScreenHandler.ConfigScreenFactory((arg_0, arg_1) -> NetworkEventsClient.registerConfigs$lambda$6$lambda$5$lambda$4($id, arg_0, arg_1));
    }

    private static final void registerConfigs$lambda$6(ModContainer modContainer) {
        String id = modContainer.getModId();
        if (ClientConfigRegistry.INSTANCE.getScreenScopes$fzzy_config().contains(id) && modContainer.getCustomExtension(ConfigScreenHandler.ConfigScreenFactory.class).isEmpty()) {
            modContainer.registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> NetworkEventsClient.registerConfigs$lambda$6$lambda$5(id));
        }
    }

    private static final int registerClientCommands$lambda$7(CommandContext context) {
        Intrinsics.checkNotNull((Object)context);
        String scope = ValidScopesArgumentType.Companion.getValidScope(context, "base_scope");
        String string = scope;
        if (string == null) {
            string = "";
        }
        FCC.INSTANCE.openScopedScreen(string);
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private static final int registerClientCommands$lambda$9(CommandContext context) {
        Object object;
        FCC fCC;
        block7: {
            block4: {
                String string;
                Object object2;
                block6: {
                    block5: {
                        void it;
                        Intrinsics.checkNotNull((Object)context);
                        String scope = ValidScopesArgumentType.Companion.getValidScope(context, "base_scope");
                        String subScope = ValidSubScopesArgumentType.Companion.getValidSubScope(context, "sub_scope");
                        fCC = FCC.INSTANCE;
                        object = scope;
                        if (object == null) break block4;
                        object2 = subScope;
                        if (object2 == null) break block5;
                        String string2 = object2;
                        String string3 = object;
                        FCC fCC2 = fCC;
                        boolean bl = false;
                        String string4 = "." + (String)it;
                        fCC = fCC2;
                        string = string3;
                        String string5 = string4;
                        object2 = string5;
                        if (string5 != null) break block6;
                    }
                    object2 = "";
                }
                if ((object = string + (String)object2) != null) break block7;
            }
            object = "";
        }
        fCC.openScopedScreen((String)object);
        return 1;
    }

    private static final int registerClientCommands$lambda$10(CommandContext context) {
        Minecraft.m_91087_().m_91395_();
        return 1;
    }

    private static final int registerClientCommands$lambda$11(CommandContext context) {
        Minecraft c = Minecraft.m_91087_();
        boolean sp = c.m_91090_();
        boolean realm = c.m_91294_();
        ClientLevel clientLevel = c.f_91073_;
        if (clientLevel != null) {
            clientLevel.m_7462_();
        }
        c.m_91399_();
        TitleScreen titleScreen = new TitleScreen();
        if (sp) {
            c.m_91152_((Screen)titleScreen);
        } else if (realm) {
            c.m_91152_((Screen)new RealmsMainScreen((Screen)titleScreen));
        } else {
            c.m_91152_((Screen)new JoinMultiplayerScreen((Screen)titleScreen));
        }
        return 1;
    }

    private static final int registerClientCommands$lambda$12(CommandContext context) {
        Minecraft.m_91087_().m_91391_();
        return 1;
    }
}

