/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.TrustingRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class TrustingSerializer
implements RecipeSerializer<TrustingRecipe> {
    @NotNull
    public TrustingRecipe fromJson(@NotNull ResourceLocation jsonPath, @NotNull JsonObject json) {
        TrustingRecipe r = (TrustingRecipe)Utils.readJsonContents(jsonPath, json, "trusting");
        if (r == null) {
            return null;
        }
        if (r.entityType == null || r.inputStack == null || r.spawnEgg == null) {
            throw new JsonParseException("TrustingRecipe invalid/null fields: " + jsonPath);
        }
        return new TrustingRecipe(r.entityType, r.inputStack, r.spawnEgg, CommonUtils.safe(r.extraInputStack), r.jsonModID, r.jsonAnimalID, r.modFolder, r.fileName);
    }

    @NotNull
    public TrustingRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        ResourceLocation entityRL = buf.m_130281_();
        EntityType<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(entityRL);
        if (entityType == null) {
            throw new IllegalStateException("Unknown EntityType in TrustingRecipe#fromNetwork: " + entityRL);
        }
        Ingredient inputStack = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient spawnEgg = Ingredient.m_43940_((FriendlyByteBuf)buf);
        boolean hasExtra = buf.readBoolean();
        Ingredient extraInputStack = hasExtra ? Ingredient.m_43940_((FriendlyByteBuf)buf) : Ingredient.f_43901_;
        String jsonModID = buf.m_130277_();
        String jsonAnimalID = buf.m_130277_();
        String modFolder = buf.m_130277_();
        String fileName = buf.m_130277_();
        return new TrustingRecipe(entityType, inputStack, spawnEgg, extraInputStack, jsonModID, jsonAnimalID, modFolder, fileName);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull TrustingRecipe recipe) {
        ResourceLocation entityKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.entityType);
        if (entityKey == null) {
            throw new IllegalStateException("Unknown EntityType in TrustingRecipe: " + recipe.entityType);
        }
        buf.m_130085_(entityKey);
        CommonUtils.safe(recipe.inputStack).m_43923_(buf);
        CommonUtils.safe(recipe.spawnEgg).m_43923_(buf);
        boolean hasExtra = recipe.extraInputStack != null && !recipe.extraInputStack.m_43947_();
        buf.writeBoolean(hasExtra);
        if (hasExtra) {
            recipe.extraInputStack.m_43923_(buf);
        }
        buf.m_130070_(recipe.jsonModID);
        buf.m_130070_(recipe.jsonAnimalID);
        buf.m_130070_(recipe.modFolder);
        buf.m_130070_(recipe.fileName);
    }
}

