/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.serializer;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.AllayDuplicationRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import com.christofmeg.justenoughbreeding.utils.Utils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.NotNull;

public class AllayDuplicationSerializer
implements RecipeSerializer<AllayDuplicationRecipe> {
    @NotNull
    public AllayDuplicationRecipe fromJson(@NotNull ResourceLocation jsonPath, @NotNull JsonObject json) {
        AllayDuplicationRecipe r = (AllayDuplicationRecipe)Utils.readJsonContents(jsonPath, json, "allay_duplication");
        if (r == null) {
            return null;
        }
        if (r.entityType == null || r.inputStack == null || r.spawnEgg == null) {
            throw new JsonParseException("AllayDuplicationRecipe invalid/null fields: " + jsonPath);
        }
        return r;
    }

    @NotNull
    public AllayDuplicationRecipe fromNetwork(@NotNull ResourceLocation resourceLocation, @NotNull FriendlyByteBuf buf) {
        ResourceLocation entityId = buf.m_130281_();
        EntityType<?> entityType = JustEnoughBreeding.getEntityFromLoaderRegistries(entityId);
        if (entityType == null) {
            throw new IllegalStateException("Unknown EntityType in AllayDuplicationRecipe#fromNetwork: " + entityId);
        }
        Ingredient inputStack = Ingredient.m_43940_((FriendlyByteBuf)buf);
        Ingredient spawnEgg = Ingredient.m_43940_((FriendlyByteBuf)buf);
        String jsonModID = buf.m_130277_();
        String jsonAnimalID = buf.m_130277_();
        String modFolder = buf.m_130277_();
        String fileName = buf.m_130277_();
        return new AllayDuplicationRecipe(entityType, inputStack, spawnEgg, jsonModID, jsonAnimalID, modFolder, fileName);
    }

    public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull AllayDuplicationRecipe recipe) {
        ResourceLocation entityKey = JustEnoughBreeding.getKeyLoaderRegistries(recipe.entityType);
        if (entityKey == null) {
            throw new IllegalStateException("Unknown EntityType in AllayDuplicationRecipe: " + recipe.entityType);
        }
        buf.m_130085_(entityKey);
        CommonUtils.safe(recipe.inputStack).m_43923_(buf);
        CommonUtils.safe(recipe.spawnEgg).m_43923_(buf);
        buf.m_130070_(recipe.jsonModID);
        buf.m_130070_(recipe.jsonAnimalID);
        buf.m_130070_(recipe.modFolder);
        buf.m_130070_(recipe.fileName);
    }
}

