/*
 * Decompiled with CFR 0.152.
 */
package com.christofmeg.justenoughbreeding.recipe;

import com.christofmeg.justenoughbreeding.JustEnoughBreeding;
import com.christofmeg.justenoughbreeding.recipe.BaseRecipe;
import com.christofmeg.justenoughbreeding.utils.CommonUtils;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.NotNull;

public class AllayDuplicationRecipe
extends BaseRecipe {
    public final EntityType<?> entityType;
    @NotNull
    public Ingredient inputStack;
    @NotNull
    public Ingredient spawnEgg;
    public final String jsonModID;
    public final String jsonAnimalID;
    public final String modFolder;
    public final String fileName;

    public AllayDuplicationRecipe(EntityType<?> entityType, Ingredient inputStack, Ingredient spawnEgg, String jsonModID, String jsonAnimalID, String modFolder, String fileName) {
        this.entityType = Objects.requireNonNull(entityType, "entityType");
        this.inputStack = CommonUtils.safe(inputStack);
        this.spawnEgg = CommonUtils.safe(spawnEgg);
        this.jsonModID = Objects.requireNonNull(jsonModID, "jsonModID");
        this.jsonAnimalID = Objects.requireNonNull(jsonAnimalID, "jsonAnimalID");
        this.modFolder = Objects.requireNonNull(modFolder, "modFolder");
        this.fileName = Objects.requireNonNull(fileName, "fileName");
        this.validateRequired();
    }

    private void validateRequired() {
        if (this.inputStack.m_43947_()) {
            throw new IllegalStateException("AllayDuplicationRecipe " + this.m_6423_() + " has empty input ingredient.");
        }
        if (this.spawnEgg.m_43947_()) {
            throw new IllegalStateException("AllayDuplicationRecipe " + this.m_6423_() + " has empty spawnEgg ingredient.");
        }
    }

    @Override
    @NotNull
    public ResourceLocation m_6423_() {
        return new ResourceLocation("justenoughbreeding", "allay_duplication/" + this.modFolder + "/" + this.fileName + "/" + this.jsonModID + "/" + this.jsonAnimalID);
    }

    @Override
    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)JustEnoughBreeding.ALLAY_DUPLICATION_PROVIDER_SERIALIZER.get();
    }

    @Override
    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)JustEnoughBreeding.ALLAY_DUPLICATION_PROVIDER_TYPE.get();
    }

    public void setInputIngredient(Ingredient ingredient) {
        this.inputStack = CommonUtils.safe(ingredient);
    }

    public void setSpawnEggs(Ingredient ingredient) {
        this.spawnEgg = CommonUtils.safe(ingredient);
    }
}

