/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.incubation.core.registry;

import com.teamabnormals.incubation.common.levelgen.feature.BirdNestFeature;
import com.teamabnormals.incubation.common.levelgen.feature.configurations.NestConfiguration;
import com.teamabnormals.incubation.core.other.IncubationConstants;
import com.teamabnormals.incubation.core.registry.IncubationBlocks;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="incubation", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IncubationFeatures {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"incubation");
    public static final RegistryObject<Feature<NestConfiguration>> BIRD_NEST = FEATURES.register("bird_nest", () -> new BirdNestFeature(NestConfiguration.CODEC));

    public static final class IncubationPlacedFeatures {
        public static final ResourceKey<PlacedFeature> NEST_CHICKEN = IncubationPlacedFeatures.createKey("nest_chicken");
        public static final ResourceKey<PlacedFeature> NEST_DUCK = IncubationPlacedFeatures.createKey("nest_duck");
        public static final ResourceKey<PlacedFeature> NEST_TURKEY = IncubationPlacedFeatures.createKey("nest_turkey");

        public static void bootstrap(BootstapContext<PlacedFeature> context) {
            IncubationPlacedFeatures.register(context, NEST_CHICKEN, IncubationConfiguredFeatures.NEST_CHICKEN, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
            IncubationPlacedFeatures.register(context, NEST_DUCK, IncubationConfiguredFeatures.NEST_DUCK, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
            IncubationPlacedFeatures.register(context, NEST_TURKEY, IncubationConfiguredFeatures.NEST_TURKEY, new PlacementModifier[]{RarityFilter.m_191900_((int)32), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        }

        public static ResourceKey<PlacedFeature> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)new ResourceLocation("incubation", name));
        }

        public static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> configuredFeatureHolder, PlacementModifier ... modifiers) {
            context.m_255272_(key, (Object)new PlacedFeature((Holder)context.m_255420_(Registries.f_256911_).m_255043_(configuredFeatureHolder), List.of(modifiers)));
        }
    }

    public static final class IncubationConfiguredFeatures {
        public static final ResourceKey<ConfiguredFeature<?, ?>> NEST_CHICKEN = IncubationConfiguredFeatures.createKey("nest_chicken");
        public static final ResourceKey<ConfiguredFeature<?, ?>> NEST_DUCK = IncubationConfiguredFeatures.createKey("nest_duck");
        public static final ResourceKey<ConfiguredFeature<?, ?>> NEST_TURKEY = IncubationConfiguredFeatures.createKey("nest_turkey");

        public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
            IncubationConfiguredFeatures.register(context, NEST_CHICKEN, () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_CHICKEN_NEST.get()).m_49966_(), IncubationConstants.CHICKEN)));
            IncubationConfiguredFeatures.register(context, NEST_DUCK, () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_DUCK_NEST.get()).m_49966_(), IncubationConstants.DUCK)));
            IncubationConfiguredFeatures.register(context, NEST_TURKEY, () -> new ConfiguredFeature((Feature)BIRD_NEST.get(), (FeatureConfiguration)new NestConfiguration(((Block)IncubationBlocks.TWIG_TURKEY_NEST.get()).m_49966_(), IncubationConstants.TURKEY)));
        }

        public static ResourceKey<ConfiguredFeature<?, ?>> createKey(String name) {
            return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("incubation", name));
        }

        public static void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, Supplier<? extends ConfiguredFeature<?, ?>> configuredFeature) {
            context.m_255272_(key, configuredFeature.get());
        }
    }
}

