/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.tectonic.lithostitched;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.TrueModifierPredicate;
import dev.worldgen.tectonic.Tectonic;
import dev.worldgen.tectonic.config.ConfigHandler;
import dev.worldgen.tectonic.config.state.object.HeightLimits;
import dev.worldgen.tectonic.mixin.DimensionTypeAccessor;
import dev.worldgen.tectonic.mixin.NoiseSettingsAccessor;
import net.minecraft.core.Holder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;

public record SetHeightLimitsModifier(Holder<DimensionType> dimensionType, Holder<NoiseGeneratorSettings> noiseSettings) implements Modifier
{
    public static final Codec<SetHeightLimitsModifier> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DimensionType.f_63853_.fieldOf("dimension_type").forGetter(SetHeightLimitsModifier::dimensionType), (App)NoiseGeneratorSettings.f_64431_.fieldOf("noise_settings").forGetter(SetHeightLimitsModifier::noiseSettings)).apply((Applicative)instance, SetHeightLimitsModifier::new));

    public ModifierPredicate getPredicate() {
        return TrueModifierPredicate.INSTANCE;
    }

    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.AFTER_ALL;
    }

    public void applyModifier() {
        if (!Tectonic.isEnabled()) {
            return;
        }
        HeightLimits limits = ConfigHandler.getState().globalTerrain.heightLimits;
        DimensionTypeAccessor typeAccessor = (DimensionTypeAccessor)this.dimensionType.m_203334_();
        typeAccessor.setMinY(limits.minY);
        typeAccessor.setHeight(limits.getHeight());
        typeAccessor.setLogicalHeight(limits.getHeight());
        NoiseSettingsAccessor settingsAccessor = (NoiseSettingsAccessor)((NoiseGeneratorSettings)this.noiseSettings.m_203334_()).f_64439_();
        settingsAccessor.setMinY(limits.minY);
        settingsAccessor.setHeight(limits.getHeight());
    }

    public Codec<? extends Modifier> codec() {
        return CODEC;
    }
}

