/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.item.block_placer;

import com.google.common.base.Predicates;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.equipment.zapper.PlacementPatterns;
import com.simibubi.create.content.equipment.zapper.ShootableGadgetItemMethods;
import com.simibubi.create.content.equipment.zapper.ZapperBeamPacket;
import com.simibubi.create.content.equipment.zapper.ZapperItem;
import com.simibubi.create.content.equipment.zapper.terrainzapper.PlacementOptions;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import com.simibubi.create.foundation.utility.BlockHelper;
import com.simibubi.create.foundation.utility.CreateLang;
import dev.hail.create_fantasizing.item.block_placer.BPBrush;
import dev.hail.create_fantasizing.item.block_placer.BPCuboidBrush;
import dev.hail.create_fantasizing.item.block_placer.BPCylinderBrush;
import dev.hail.create_fantasizing.item.block_placer.BPDynamicBrush;
import dev.hail.create_fantasizing.item.block_placer.BPSphereBrush;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerBrushes;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerItemRenderer;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerScreen;
import dev.hail.create_fantasizing.item.block_placer.BlockPlacerTools;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.gui.ScreenOpener;
import net.createmod.catnip.nbt.NBTHelper;
import net.createmod.catnip.platform.CatnipServices;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BlockPlacerItem
extends ZapperItem {
    static final String SHAPER_BRUSH_PARAMS = "BrushParams";
    static final String SHAPER_BRUSH = "Brush";
    static final String SHAPER_TOOL = "Tool";
    static final String SHAPER_PLACEMENT = "Placement";

    public BlockPlacerItem(Item.Properties properties) {
        super(properties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new BlockPlacerItemRenderer()));
    }

    public boolean m_8120_(@NotNull ItemStack itemstack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == Enchantments.f_44985_ || enchantment == Enchantments.f_44987_ || enchantment == Enchantments.f_44952_) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public int m_6473_() {
        return 1;
    }

    public Component validateUsage(ItemStack item) {
        if (!item.m_41784_().m_128441_(SHAPER_BRUSH_PARAMS)) {
            return CreateLang.translateDirect((String)"terrainzapper.shiftRightClickToSet", (Object[])new Object[0]);
        }
        return super.validateUsage(item);
    }

    protected boolean canActivateWithoutSelectedBlock(ItemStack stack) {
        BlockPlacerTools tool = (BlockPlacerTools)NBTHelper.readEnum((CompoundTag)stack.m_41784_(), (String)SHAPER_TOOL, BlockPlacerTools.class);
        return !tool.requiresSelectedBlock();
    }

    protected boolean activate(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace, CompoundTag data) {
        return false;
    }

    public float activate(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace, CompoundTag data, InteractionHand hand) {
        BlockPos targetPos = raytrace.m_82425_();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        CompoundTag tag = stack.m_41784_();
        BPBrush brush = ((BlockPlacerBrushes)NBTHelper.readEnum((CompoundTag)tag, (String)SHAPER_BRUSH, BlockPlacerBrushes.class)).get();
        BlockPos params = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(SHAPER_BRUSH_PARAMS));
        float multiplier = this.sizeMultiplier(params, brush);
        PlacementOptions option = (PlacementOptions)NBTHelper.readEnum((CompoundTag)tag, (String)SHAPER_PLACEMENT, PlacementOptions.class);
        BlockPlacerTools tool = (BlockPlacerTools)NBTHelper.readEnum((CompoundTag)tag, (String)SHAPER_TOOL, BlockPlacerTools.class);
        brush.set(params.m_123341_(), params.m_123342_(), params.m_123343_());
        targetPos = targetPos.m_121955_((Vec3i)brush.getOffset(player.m_20154_(), raytrace.m_82434_(), option));
        brush.addToGlobalPositions((LevelAccessor)world, targetPos, raytrace.m_82434_(), affectedPositions, tool);
        brush.redirectTool(tool).run(world, affectedPositions, stateToUse, data, player, stack, hand, BlockPlacerItem.applyPattern(affectedPositions, stack));
        return multiplier;
    }

    public int activateCalculation(Level world, Player player, ItemStack stack, BlockState stateToUse, BlockHitResult raytrace) {
        BlockPos targetPos = raytrace.m_82425_();
        ArrayList<BlockPos> affectedPositions = new ArrayList<BlockPos>();
        CompoundTag tag = stack.m_41784_();
        BPBrush brush = ((BlockPlacerBrushes)NBTHelper.readEnum((CompoundTag)tag, (String)SHAPER_BRUSH, BlockPlacerBrushes.class)).get();
        BlockPos params = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(SHAPER_BRUSH_PARAMS));
        PlacementOptions option = (PlacementOptions)NBTHelper.readEnum((CompoundTag)tag, (String)SHAPER_PLACEMENT, PlacementOptions.class);
        BlockPlacerTools tool = (BlockPlacerTools)NBTHelper.readEnum((CompoundTag)tag, (String)SHAPER_TOOL, BlockPlacerTools.class);
        if (params != null) {
            brush.set(params.m_123341_(), params.m_123342_(), params.m_123343_());
        }
        targetPos = targetPos.m_121955_((Vec3i)brush.getOffset(player.m_20154_(), raytrace.m_82434_(), option));
        brush.addToGlobalPositions((LevelAccessor)world, targetPos, raytrace.m_82434_(), affectedPositions, tool);
        return brush.redirectTool(tool).runCalculate(world, affectedPositions, stateToUse);
    }

    public static PlacementPatterns applyPattern(List<BlockPos> blocksIn, ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        PlacementPatterns pattern = !tag.m_128441_("Pattern") ? PlacementPatterns.Solid : PlacementPatterns.valueOf((String)tag.m_128461_("Pattern"));
        Object filter = Predicates.alwaysFalse();
        switch (pattern) {
            case Checkered: {
                filter = pos -> (pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 2 == 0;
                break;
            }
            case InverseCheckered: {
                filter = pos -> (pos.m_123341_() + pos.m_123342_() + pos.m_123343_()) % 2 != 0;
                break;
            }
        }
        blocksIn.removeIf((Predicate<BlockPos>)filter);
        return pattern;
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
        CompoundTag nbt = pStack.m_41784_();
        if (pEntity instanceof Player) {
            Player player = (Player)pEntity;
            BlockState stateToUse = Blocks.f_50016_.m_49966_();
            if (nbt.m_128441_("BlockUsed")) {
                stateToUse = NbtUtils.m_247651_((HolderGetter)pLevel.m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("BlockUsed"));
            }
            stateToUse = BlockHelper.setZeroAge((BlockState)stateToUse);
            Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
            Vec3 range = player.m_20154_().m_82490_((double)this.getZappingRange(pStack));
            BlockHitResult raytrace = pLevel.m_45547_(new ClipContext(start, start.m_82549_(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            if (stateToUse != null) {
                int invAmount = BlockPlacerTools.calculateItemsInInventory(stateToUse.m_60734_(), true, player, pStack.getEnchantmentLevel(Enchantments.f_44952_) >= 1);
                int selSize = this.activateCalculation(pLevel, player, pStack, stateToUse, raytrace);
                if (!nbt.m_128441_("Amount") || nbt.m_128451_("Amount") != invAmount) {
                    nbt.m_128405_("Amount", invAmount);
                }
                if (!nbt.m_128441_("Size") || nbt.m_128451_("Size") != selSize) {
                    nbt.m_128405_("Size", selSize);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        boolean lookingAtBlock;
        int size;
        boolean mainHand;
        ItemStack item = player.m_21120_(hand);
        boolean bl = mainHand = hand == InteractionHand.MAIN_HAND;
        if (player.m_6144_()) {
            if (level.f_46443_) {
                CatnipServices.PLATFORM.executeOnClientOnly(() -> () -> this.openHandgunGUI(item, hand));
                player.m_36335_().m_41524_(item.m_41720_(), 10);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        CompoundTag nbt = item.m_41784_();
        BlockState stateToUse = Blocks.f_50016_.m_49966_();
        if (nbt.m_128441_("BlockUsed")) {
            stateToUse = NbtUtils.m_247651_((HolderGetter)level.m_246945_(Registries.f_256747_), (CompoundTag)nbt.m_128469_("BlockUsed"));
        }
        stateToUse = BlockHelper.setZeroAge((BlockState)stateToUse);
        CompoundTag data = null;
        if (nbt.m_128425_("BlockData", 10)) {
            data = nbt.m_128469_("BlockData");
        }
        Vec3 start = player.m_20182_().m_82520_(0.0, (double)player.m_20192_(), 0.0);
        Vec3 range = player.m_20154_().m_82490_((double)this.getZappingRange(item));
        BlockHitResult raytrace = level.m_45547_(new ClipContext(start, start.m_82549_(range), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        Vec3 barrelPos = ShootableGadgetItemMethods.getGunBarrelVec((Player)player, (boolean)mainHand, (Vec3)new Vec3((double)0.35f, (double)-0.1f, 1.0));
        BlockPos lookingPos = raytrace.m_82425_();
        int amount = nbt.m_128451_("Amount");
        boolean items = (amount >= (size = nbt.m_128451_("Size")) || player.m_7500_()) && size != 0 || size == 999999;
        boolean bl2 = lookingAtBlock = level.m_6857_().m_61937_(lookingPos) && raytrace.m_6662_() != HitResult.Type.MISS;
        if (level.f_46443_) {
            if (!(player.m_6144_() || items && lookingAtBlock)) {
                if (size != 0 && size != 999999 && lookingAtBlock) {
                    player.m_5661_((Component)Component.m_237115_((String)"item.create_fantasizing.block_placer.not_enough_blocks").m_130946_(" " + amount + "/" + size).m_130940_(ChatFormatting.RED), true);
                }
                AllSoundEvents.DENY.play(level, player, (Vec3i)player.m_20183_());
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
            }
            CreateClient.ZAPPER_RENDER_HANDLER.dontAnimateItem(hand);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        if (!(player.m_6144_() || items && lookingAtBlock)) {
            player.m_36335_().m_41524_(item.m_41720_(), 10);
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)item);
        }
        if (!player.m_6144_() && items && lookingAtBlock) {
            float multiplier = this.activate(level, player, item, stateToUse, raytrace, data, hand);
            int cooldown = (int)(multiplier * (float)this.getCooldownDelay(item));
            ShootableGadgetItemMethods.applyCooldown((Player)player, (ItemStack)item, (InteractionHand)hand, arg_0 -> ((BlockPlacerItem)this).isZapper(arg_0), (int)Math.max(cooldown, 5));
            ShootableGadgetItemMethods.sendPackets((Player)player, b -> new ZapperBeamPacket(barrelPos, raytrace.m_82450_(), hand, b.booleanValue()));
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)item);
        }
        return super.m_7203_(level, player, hand);
    }

    public float sizeMultiplier(BlockPos params, BPBrush brush) {
        float size = 16.0f;
        float radius = 6.0f;
        float radiusSize = (int)((double)radius * 1.25);
        float max = 1.0f;
        if (brush instanceof BPCuboidBrush) {
            max = size;
        }
        if (brush instanceof BPSphereBrush) {
            max = radiusSize;
        }
        if (brush instanceof BPCylinderBrush) {
            max = radius;
        }
        if (brush instanceof BPDynamicBrush) {
            max = radiusSize;
        }
        float x = params.m_123341_();
        float y = params.m_123342_();
        float z = params.m_123343_();
        return x * y * z / (max * max * max);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected void openHandgunGUI(ItemStack item, InteractionHand hand) {
        ScreenOpener.open((Screen)new BlockPlacerScreen(item, hand));
    }

    protected int getCooldownDelay(ItemStack item) {
        return 2;
    }

    protected int getZappingRange(ItemStack stack) {
        return 128;
    }

    public static void configureSettings(ItemStack stack, PlacementPatterns pattern, BlockPlacerBrushes brush, int brushParamX, int brushParamY, int brushParamZ, BlockPlacerTools tool, PlacementOptions placement) {
        ZapperItem.configureSettings((ItemStack)stack, (PlacementPatterns)pattern);
        CompoundTag nbt = stack.m_41784_();
        NBTHelper.writeEnum((CompoundTag)nbt, (String)SHAPER_BRUSH, (Enum)brush);
        nbt.m_128365_(SHAPER_BRUSH_PARAMS, (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(brushParamX, brushParamY, brushParamZ)));
        NBTHelper.writeEnum((CompoundTag)nbt, (String)SHAPER_TOOL, (Enum)tool);
        NBTHelper.writeEnum((CompoundTag)nbt, (String)SHAPER_PLACEMENT, (Enum)placement);
    }
}

