/*
 * Decompiled with CFR 0.152.
 */
package dev.hail.create_fantasizing.block.transporter;

import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.logistics.box.PackageEntity;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.block.ProperWaterloggedBlock;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.inventory.InvManipulationBehaviour;
import com.simibubi.create.foundation.item.ItemHelper;
import dev.hail.create_fantasizing.block.CFABlocks;
import dev.hail.create_fantasizing.block.transporter.TransporterEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class TransporterBlock
extends Block
implements IBE<TransporterEntity>,
IWrenchable,
ProperWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;

    public TransporterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        super.m_6861_(state, level, pos, block, fromPos, isMoving);
        if (level.f_46443_) {
            return;
        }
        if (!level.m_183326_().m_183588_(pos, (Object)this)) {
            level.m_186460_(pos, (Block)this, 1);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        IBE.onRemove((BlockState)state, (Level)world, (BlockPos)pos, (BlockState)newState);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource r) {
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_276867_(pos)) {
            worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)POWERED), 2);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        boolean waterFlag = context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_;
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate = (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_122424_());
            if (!blockstate.m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)blockstate.m_61124_((Property)POWERED, (Comparable)((Boolean)state.m_61143_((Property)POWERED)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterFlag));
        }
        return (BlockState)state.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterFlag));
    }

    @NotNull
    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        this.updateWater(pLevel, pState, pCurrentPos);
        return pState;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((Direction)state.m_61143_((Property)FACING)) {
            case NORTH: 
            case SOUTH: {
                return Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)16.0);
            }
            case WEST: 
            case EAST: {
                return Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0);
            }
        }
        return Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    }

    public Class<TransporterEntity> getBlockEntityClass() {
        return TransporterEntity.class;
    }

    public BlockEntityType<? extends TransporterEntity> getBlockEntityType() {
        return (BlockEntityType)CFABlocks.TRANSPORTER_ENTITY.get();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{POWERED, FACING, WATERLOGGED}));
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        float yOffset;
        if (worldIn.f_46443_) {
            return;
        }
        ItemStack stack = ItemHelper.fromItemEntity((Entity)entityIn);
        if (stack.m_41619_()) {
            return;
        }
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        Vec3 openPos = VecHelper.getCenterOf((Vec3i)pos).m_82549_(Vec3.m_82528_((Vec3i)direction.m_122436_()).m_82490_(entityIn instanceof ItemEntity ? -0.25 : -0.125));
        Vec3 diff = entityIn.m_20182_().m_82546_(openPos);
        double projectedDiff = direction.m_122434_().m_6150_(diff.f_82479_, diff.f_82480_, diff.f_82481_);
        if (projectedDiff < 0.0 == (direction.m_122421_() == Direction.AxisDirection.POSITIVE)) {
            return;
        }
        float f = direction == Direction.UP ? 0.25f : (yOffset = direction == Direction.DOWN ? -0.5f : -0.5f);
        if (!PackageEntity.centerPackage((Entity)entityIn, (Vec3)openPos.m_82520_(0.0, (double)yOffset, 0.0))) {
            return;
        }
        ItemStack remainder = TransporterBlock.tryInsert(worldIn, pos, stack, false);
        if (remainder.m_41619_()) {
            entityIn.m_146870_();
        }
        if (remainder.m_41613_() < stack.m_41613_() && entityIn instanceof ItemEntity) {
            ((ItemEntity)entityIn).m_32045_(remainder);
        }
    }

    public static ItemStack tryInsert(Level worldIn, BlockPos pos, ItemStack toInsert, boolean simulate) {
        BlockEntity blockEntity;
        FilteringBehaviour filter = (FilteringBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, (BehaviourType)FilteringBehaviour.TYPE);
        InvManipulationBehaviour inserter = (InvManipulationBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, (BehaviourType)InvManipulationBehaviour.TYPE);
        if (inserter == null) {
            return toInsert;
        }
        if (filter != null && !filter.test(toInsert)) {
            return toInsert;
        }
        if (simulate) {
            inserter.simulate();
        }
        ItemStack insert = inserter.insert(toInsert);
        if (!simulate && insert.m_41613_() != toInsert.m_41613_() && (blockEntity = worldIn.m_7702_(pos)) instanceof FunnelBlockEntity) {
            FunnelBlockEntity funnelBlockEntity = (FunnelBlockEntity)blockEntity;
            funnelBlockEntity.onTransfer(toInsert);
            if (funnelBlockEntity.hasFlap()) {
                funnelBlockEntity.flap(true);
            }
        }
        return insert;
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return this.getBlockEntityType().m_155264_(blockPos, blockState);
    }
}

