/*
 * Decompiled with CFR 0.152.
 */
package link.e4mc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;

public class Mirror {
    private static final String[] LITERAL_CLASS_NAMES = new String[]{"net.minecraft.text.LiteralText", "net.minecraft.network.chat.TextComponent", "net.minecraft.class_2585", "net.minecraft.src.C_5025_"};
    private static final String[] LITERAL_METHOD_NAMES = new String[]{"literal", "method_43470", "m_237113_"};
    private static final String[] TRANSLATABLE_CLASS_NAMES = new String[]{"net.minecraft.text.TranslatableText", "net.minecraft.network.chat.TranslatableComponent", "net.minecraft.class_2588", "net.minecraft.src.C_5026_"};
    private static final String[] TRANSLATABLE_METHOD_NAMES = new String[]{"translatable", "method_43469", "m_237110_"};
    private static final String[] SUCCESS_METHOD_NAMES = new String[]{"sendFeedback", "sendSuccess", "method_9226", "m_288197_"};
    private static final String[] FAILURE_METHOD_NAMES = new String[]{"sendError", "sendFailure", "method_9213", "m_81352_"};
    private static final String[] WITH_STYLE_METHOD_NAMES = new String[]{"styled", "withStyle", "method_27694", "m_130938_"};
    private static final String[] APPEND_METHOD_NAMES = new String[]{"append", "method_10852", "m_7220_"};
    private static final String[] RUNCOMMAND_CLASS_NAMES = new String[]{"net.minecraft.text.ClickEvent$RunCommand", "net.minecraft.network.chat.ClickEvent$RunCommand", "net.minecraft.class_2558$class_10609"};
    private static final String[] COPYTOCLIPBOARD_CLASS_NAMES = new String[]{"net.minecraft.text.ClickEvent$CopyToClipboard", "net.minecraft.network.chat.ClickEvent$CopyToClipboard", "net.minecraft.class_2558$class_10606"};
    private static final String[] SHOWTEXT_CLASS_NAMES = new String[]{"net.minecraft.text.HoverEvent$ShowText", "net.minecraft.network.chat.HoverEvent$ShowText", "net.minecraft.class_2568$class_10613"};

    public static ClickEvent runCommand(String command) {
        if (ClickEvent.class.isInterface()) {
            for (String className : RUNCOMMAND_CLASS_NAMES) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    return (ClickEvent)constructor.newInstance(command);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                }
            }
        } else {
            return new ClickEvent(ClickEvent.Action.RUN_COMMAND, command);
        }
        throw new RuntimeException("Could not locate any way to make a ClickEvent!");
    }

    public static ClickEvent copyToClipboard(String text) {
        if (ClickEvent.class.isInterface()) {
            for (String className : COPYTOCLIPBOARD_CLASS_NAMES) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    return (ClickEvent)constructor.newInstance(text);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                }
            }
        } else {
            return new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, text);
        }
        throw new RuntimeException("Could not locate any way to make a ClickEvent!");
    }

    public static HoverEvent showText(Component text) {
        if (HoverEvent.class.isInterface()) {
            for (String className : SHOWTEXT_CLASS_NAMES) {
                try {
                    Class<?> clazz = Class.forName(className);
                    Constructor<?> constructor = clazz.getConstructor(Component.class);
                    return (HoverEvent)constructor.newInstance(text);
                }
                catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException exception) {
                }
            }
        } else {
            return new HoverEvent(HoverEvent.Action.f_130831_, (Object)text);
        }
        throw new RuntimeException("Could not locate any way to make a ClickEvent!");
    }

    public static Component withStyle(Component component, UnaryOperator<Style> operator) {
        Class clazz = component.getClass();
        for (String methodName : WITH_STYLE_METHOD_NAMES) {
            try {
                Method method = clazz.getMethod(methodName, UnaryOperator.class);
                return (Component)method.invoke((Object)component, operator);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            }
        }
        throw new RuntimeException("Could not locate any way to style this Component!");
    }

    public static Component append(Component component, Component other) {
        Class clazz = component.getClass();
        for (String methodName : APPEND_METHOD_NAMES) {
            try {
                Method method = clazz.getMethod(methodName, Component.class);
                return (Component)method.invoke((Object)component, other);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            }
        }
        throw new RuntimeException("Could not locate any way to append a Component to this Component!");
    }

    public static Component literal(String text) {
        for (String className : LITERAL_CLASS_NAMES) {
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                return (Component)constructor.newInstance(text);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException clazz) {
            }
        }
        Class<Component> clazz = Component.class;
        for (String methodName : LITERAL_METHOD_NAMES) {
            try {
                Method method = clazz.getMethod(methodName, String.class);
                return (Component)method.invoke(null, text);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            }
        }
        throw new RuntimeException("Could not locate any way to make a literal Component!");
    }

    public static Component translatable(String text, Object ... args) {
        for (String className : TRANSLATABLE_CLASS_NAMES) {
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getConstructor(String.class, Object[].class);
                return (Component)constructor.newInstance(text, args);
            }
            catch (ClassCastException | ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException clazz) {
            }
        }
        Class<Component> clazz = Component.class;
        for (String methodName : TRANSLATABLE_METHOD_NAMES) {
            try {
                Method method = clazz.getMethod(methodName, String.class, Object[].class);
                return (Component)method.invoke(null, text, args);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException exception) {
            }
        }
        throw new RuntimeException("Could not locate any way to make a literal Component!");
    }

    public static void sendSuccessToSource(CommandSourceStack source, Component message) {
        Mirror.sendGenericMessageToSource(source, message, SUCCESS_METHOD_NAMES);
    }

    public static void sendFailureToSource(CommandSourceStack source, Component message) {
        Mirror.sendGenericMessageToSource(source, message, FAILURE_METHOD_NAMES);
    }

    private static void sendGenericMessageToSource(CommandSourceStack source, Component message, String[] methodNames) {
        Class<CommandSourceStack> clazz = CommandSourceStack.class;
        for (String methodName : methodNames) {
            Method method2;
            try {
                method2 = clazz.getMethod(methodName, Component.class, Boolean.TYPE);
                method2.invoke((Object)source, message, true);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException method2) {
                // empty catch block
            }
            try {
                method2 = clazz.getMethod(methodName, Supplier.class, Boolean.TYPE);
                method2.invoke((Object)source, () -> message, true);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }
}

