/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.PendingWriteQueue;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownException;
import io.netty.incubator.codec.quic.DefaultQuicStreamFrame;
import io.netty.incubator.codec.quic.DirectIoByteBufAllocator;
import io.netty.incubator.codec.quic.QuicStreamAddress;
import io.netty.incubator.codec.quic.QuicStreamChannel;
import io.netty.incubator.codec.quic.QuicStreamChannelConfig;
import io.netty.incubator.codec.quic.QuicStreamFrame;
import io.netty.incubator.codec.quic.QuicStreamPriority;
import io.netty.incubator.codec.quic.QuicStreamType;
import io.netty.incubator.codec.quic.Quiche;
import io.netty.incubator.codec.quic.QuicheQuicChannel;
import io.netty.incubator.codec.quic.QuicheQuicStreamChannelConfig;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.RejectedExecutionException;
import org.jetbrains.annotations.Nullable;

final class QuicheQuicStreamChannel
extends DefaultAttributeMap
implements QuicStreamChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(QuicheQuicStreamChannel.class);
    private final QuicheQuicChannel parent;
    private final ChannelId id;
    private final ChannelPipeline pipeline;
    private final QuicStreamChannelUnsafe unsafe;
    private final ChannelPromise closePromise;
    private final PendingWriteQueue queue;
    private final QuicStreamChannelConfig config;
    private final QuicStreamAddress address;
    private boolean readable;
    private boolean readPending;
    private boolean inRecv;
    private boolean inWriteQueued;
    private boolean finReceived;
    private boolean finSent;
    private volatile boolean registered;
    private volatile boolean writable = true;
    private volatile boolean active = true;
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private volatile QuicStreamPriority priority;
    private volatile int capacity;

    QuicheQuicStreamChannel(QuicheQuicChannel parent, long streamId) {
        this.parent = parent;
        this.id = DefaultChannelId.newInstance();
        this.unsafe = new QuicStreamChannelUnsafe();
        this.pipeline = new DefaultChannelPipeline((Channel)this){};
        this.config = new QuicheQuicStreamChannelConfig(this);
        this.address = new QuicStreamAddress(streamId);
        this.closePromise = this.newPromise();
        this.queue = new PendingWriteQueue((Channel)this);
        if (parent.streamType(streamId) == QuicStreamType.UNIDIRECTIONAL && parent.isStreamLocalCreated(streamId)) {
            this.inputShutdown = true;
        }
    }

    @Override
    public QuicStreamAddress localAddress() {
        return this.address;
    }

    @Override
    public QuicStreamAddress remoteAddress() {
        return this.address;
    }

    @Override
    public boolean isLocalCreated() {
        return this.parent().isStreamLocalCreated(this.streamId());
    }

    @Override
    public QuicStreamType type() {
        return this.parent().streamType(this.streamId());
    }

    @Override
    public long streamId() {
        return this.address.streamId();
    }

    @Override
    public QuicStreamPriority priority() {
        return this.priority;
    }

    @Override
    public ChannelFuture updatePriority(QuicStreamPriority priority, ChannelPromise promise) {
        if (this.eventLoop().inEventLoop()) {
            this.updatePriority0(priority, promise);
        } else {
            this.eventLoop().execute(() -> this.updatePriority0(priority, promise));
        }
        return promise;
    }

    private void updatePriority0(QuicStreamPriority priority, ChannelPromise promise) {
        assert (this.eventLoop().inEventLoop());
        try {
            this.parent().streamPriority(this.streamId(), (byte)priority.urgency(), priority.isIncremental());
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
            return;
        }
        this.priority = priority;
        promise.setSuccess();
    }

    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    public ChannelFuture shutdownOutput(ChannelPromise promise) {
        if (this.eventLoop().inEventLoop()) {
            this.shutdownOutput0(promise);
        } else {
            this.eventLoop().execute(() -> this.shutdownOutput0(promise));
        }
        return promise;
    }

    private void shutdownOutput0(ChannelPromise promise) {
        assert (this.eventLoop().inEventLoop());
        this.outputShutdown = true;
        this.unsafe.writeWithoutCheckChannelState(QuicStreamFrame.EMPTY_FIN, promise);
        this.unsafe.flush();
    }

    @Override
    public ChannelFuture shutdownInput(int error, ChannelPromise promise) {
        if (this.eventLoop().inEventLoop()) {
            this.shutdownInput0(error, promise);
        } else {
            this.eventLoop().execute(() -> this.shutdownInput0(error, promise));
        }
        return promise;
    }

    @Override
    public ChannelFuture shutdownOutput(int error, ChannelPromise promise) {
        if (this.eventLoop().inEventLoop()) {
            this.shutdownOutput0(error, promise);
        } else {
            this.eventLoop().execute(() -> this.shutdownOutput0(error, promise));
        }
        return promise;
    }

    @Override
    public QuicheQuicChannel parent() {
        return this.parent;
    }

    private void shutdownInput0(int err, ChannelPromise channelPromise) {
        assert (this.eventLoop().inEventLoop());
        this.inputShutdown = true;
        this.parent().streamShutdown(this.streamId(), true, false, err, channelPromise);
        this.closeIfDone();
    }

    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    private void shutdownOutput0(int error, ChannelPromise channelPromise) {
        assert (this.eventLoop().inEventLoop());
        this.parent().streamShutdown(this.streamId(), false, true, error, channelPromise);
        this.outputShutdown = true;
        this.closeIfDone();
    }

    public boolean isShutdown() {
        return this.outputShutdown && this.inputShutdown;
    }

    public ChannelFuture shutdown(ChannelPromise channelPromise) {
        if (this.eventLoop().inEventLoop()) {
            this.shutdown0(channelPromise);
        } else {
            this.eventLoop().execute(() -> this.shutdown0(channelPromise));
        }
        return channelPromise;
    }

    private void shutdown0(ChannelPromise promise) {
        assert (this.eventLoop().inEventLoop());
        this.inputShutdown = true;
        this.outputShutdown = true;
        this.unsafe.writeWithoutCheckChannelState(QuicStreamFrame.EMPTY_FIN, this.unsafe.voidPromise());
        this.unsafe.flush();
        this.parent().streamShutdown(this.streamId(), true, false, 0, promise);
        this.closeIfDone();
    }

    @Override
    public ChannelFuture shutdown(int error, ChannelPromise promise) {
        if (this.eventLoop().inEventLoop()) {
            this.shutdown0(error, promise);
        } else {
            this.eventLoop().execute(() -> this.shutdown0(error, promise));
        }
        return promise;
    }

    private void shutdown0(int error, ChannelPromise channelPromise) {
        assert (this.eventLoop().inEventLoop());
        this.inputShutdown = true;
        this.outputShutdown = true;
        this.parent().streamShutdown(this.streamId(), true, true, error, channelPromise);
        this.closeIfDone();
    }

    private void sendFinIfNeeded() throws Exception {
        if (!this.finSent) {
            this.finSent = true;
            this.parent().streamSendFin(this.streamId());
        }
    }

    private void closeIfDone() {
        if (this.finSent && (this.finReceived || this.type() == QuicStreamType.UNIDIRECTIONAL && this.isLocalCreated())) {
            this.unsafe().close(this.unsafe().voidPromise());
        }
    }

    private void removeStreamFromParent() {
        if (!this.active && this.finReceived) {
            this.parent().streamClosed(this.streamId());
            this.inputShutdown = true;
            this.outputShutdown = true;
        }
    }

    @Override
    public QuicStreamChannel flush() {
        this.pipeline.flush();
        return this;
    }

    @Override
    public QuicStreamChannel read() {
        this.pipeline.read();
        return this;
    }

    @Override
    public QuicStreamChannelConfig config() {
        return this.config;
    }

    public boolean isOpen() {
        return this.active;
    }

    public boolean isActive() {
        return this.isOpen();
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    public ChannelId id() {
        return this.id;
    }

    public EventLoop eventLoop() {
        return this.parent.eventLoop();
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public ChannelFuture closeFuture() {
        return this.closePromise;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public long bytesBeforeUnwritable() {
        return Math.max(this.capacity, 0);
    }

    public long bytesBeforeWritable() {
        if (this.writable) {
            return 0L;
        }
        return 8L;
    }

    public QuicStreamChannelUnsafe unsafe() {
        return this.unsafe;
    }

    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    public ByteBufAllocator alloc() {
        return this.config.getAllocator();
    }

    public int compareTo(Channel o) {
        return this.id.compareTo((Object)o.id());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public String toString() {
        return "[id: 0x" + this.id.asShortText() + ", " + this.address + "]";
    }

    boolean writable(int capacity) {
        assert (this.eventLoop().inEventLoop());
        this.capacity = capacity;
        boolean mayNeedWrite = this.unsafe().writeQueued();
        this.updateWritabilityIfNeeded(this.capacity > 0);
        return mayNeedWrite;
    }

    private void updateWritabilityIfNeeded(boolean newWritable) {
        if (this.writable != newWritable) {
            this.writable = newWritable;
            this.pipeline.fireChannelWritabilityChanged();
        }
    }

    void forceClose(int error) {
        if (!this.queue.isEmpty() && error != Quiche.QUICHE_ERR_DONE) {
            if (error == Quiche.QUICHE_ERR_STREAM_STOPPED) {
                this.queue.removeAndFailAll((Throwable)new ChannelOutputShutdownException("STOP_SENDING frame received"));
            } else {
                this.queue.removeAndFailAll((Throwable)Quiche.convertToException(error));
            }
        }
        this.forceClose();
    }

    void readable() {
        assert (this.eventLoop().inEventLoop());
        this.readable = true;
        if (this.readPending) {
            this.unsafe().recv();
        }
    }

    void forceClose() {
        assert (this.eventLoop().inEventLoop());
        this.finSent = true;
        this.unsafe().close(this.unsafe().voidPromise());
    }

    final class QuicStreamChannelUnsafe
    implements Channel.Unsafe {
        private RecvByteBufAllocator.Handle recvHandle;
        private final ChannelPromise voidPromise;

        QuicStreamChannelUnsafe() {
            this.voidPromise = new VoidChannelPromise((Channel)QuicheQuicStreamChannel.this, false);
        }

        public void connect(SocketAddress remote, SocketAddress local, ChannelPromise promise) {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            promise.setFailure((Throwable)new UnsupportedOperationException());
        }

        public RecvByteBufAllocator.Handle recvBufAllocHandle() {
            if (this.recvHandle == null) {
                this.recvHandle = QuicheQuicStreamChannel.this.config.getRecvByteBufAllocator().newHandle();
            }
            return this.recvHandle;
        }

        public SocketAddress localAddress() {
            return QuicheQuicStreamChannel.this.address;
        }

        public SocketAddress remoteAddress() {
            return QuicheQuicStreamChannel.this.address;
        }

        public void register(EventLoop eventLoop, ChannelPromise promise) {
            assert (eventLoop.inEventLoop());
            if (QuicheQuicStreamChannel.this.registered) {
                promise.setFailure((Throwable)new IllegalStateException());
                return;
            }
            if (eventLoop != QuicheQuicStreamChannel.this.parent.eventLoop()) {
                promise.setFailure((Throwable)new IllegalArgumentException());
                return;
            }
            QuicheQuicStreamChannel.this.registered = true;
            promise.setSuccess();
            QuicheQuicStreamChannel.this.pipeline.fireChannelRegistered();
            QuicheQuicStreamChannel.this.pipeline.fireChannelActive();
        }

        public void bind(SocketAddress localAddress, ChannelPromise promise) {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            promise.setFailure((Throwable)new UnsupportedOperationException());
        }

        public void disconnect(ChannelPromise promise) {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            this.close(promise);
        }

        public void close(ChannelPromise promise) {
            this.close(null, promise);
        }

        void close(@Nullable ClosedChannelException writeFailCause, ChannelPromise promise) {
            block22: {
                assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
                if (!QuicheQuicStreamChannel.this.active || QuicheQuicStreamChannel.this.closePromise.isDone()) {
                    if (promise.isVoid()) {
                        return;
                    }
                    QuicheQuicStreamChannel.this.closePromise.addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{promise}));
                    return;
                }
                QuicheQuicStreamChannel.this.active = false;
                try {
                    try {
                        QuicheQuicStreamChannel.this.sendFinIfNeeded();
                    }
                    catch (Exception exception) {
                        if (!QuicheQuicStreamChannel.this.queue.isEmpty()) {
                            if (writeFailCause == null) {
                                writeFailCause = new ClosedChannelException();
                            }
                            QuicheQuicStreamChannel.this.queue.removeAndFailAll((Throwable)writeFailCause);
                        }
                        promise.trySuccess();
                        QuicheQuicStreamChannel.this.closePromise.trySuccess();
                        if (QuicheQuicStreamChannel.this.type() == QuicStreamType.UNIDIRECTIONAL && QuicheQuicStreamChannel.this.isLocalCreated()) {
                            QuicheQuicStreamChannel.this.inputShutdown = true;
                            QuicheQuicStreamChannel.this.outputShutdown = true;
                            QuicheQuicStreamChannel.this.parent().streamClosed(QuicheQuicStreamChannel.this.streamId());
                        } else {
                            QuicheQuicStreamChannel.this.removeStreamFromParent();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (!QuicheQuicStreamChannel.this.queue.isEmpty()) {
                        if (writeFailCause == null) {
                            writeFailCause = new ClosedChannelException();
                        }
                        QuicheQuicStreamChannel.this.queue.removeAndFailAll((Throwable)writeFailCause);
                    }
                    promise.trySuccess();
                    QuicheQuicStreamChannel.this.closePromise.trySuccess();
                    if (QuicheQuicStreamChannel.this.type() == QuicStreamType.UNIDIRECTIONAL && QuicheQuicStreamChannel.this.isLocalCreated()) {
                        QuicheQuicStreamChannel.this.inputShutdown = true;
                        QuicheQuicStreamChannel.this.outputShutdown = true;
                        QuicheQuicStreamChannel.this.parent().streamClosed(QuicheQuicStreamChannel.this.streamId());
                    } else {
                        QuicheQuicStreamChannel.this.removeStreamFromParent();
                    }
                    throw throwable;
                }
                if (!QuicheQuicStreamChannel.this.queue.isEmpty()) {
                    if (writeFailCause == null) {
                        writeFailCause = new ClosedChannelException();
                    }
                    QuicheQuicStreamChannel.this.queue.removeAndFailAll((Throwable)writeFailCause);
                }
                promise.trySuccess();
                QuicheQuicStreamChannel.this.closePromise.trySuccess();
                if (QuicheQuicStreamChannel.this.type() == QuicStreamType.UNIDIRECTIONAL && QuicheQuicStreamChannel.this.isLocalCreated()) {
                    QuicheQuicStreamChannel.this.inputShutdown = true;
                    QuicheQuicStreamChannel.this.outputShutdown = true;
                    QuicheQuicStreamChannel.this.parent().streamClosed(QuicheQuicStreamChannel.this.streamId());
                } else {
                    QuicheQuicStreamChannel.this.removeStreamFromParent();
                }
            }
            if (QuicheQuicStreamChannel.this.inWriteQueued) {
                this.invokeLater(() -> this.deregister(this.voidPromise(), true));
            } else {
                this.deregister(this.voidPromise(), true);
            }
        }

        private void deregister(ChannelPromise promise, boolean fireChannelInactive) {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            if (!promise.setUncancellable()) {
                return;
            }
            if (!QuicheQuicStreamChannel.this.registered) {
                promise.trySuccess();
                return;
            }
            this.invokeLater(() -> {
                if (fireChannelInactive) {
                    QuicheQuicStreamChannel.this.pipeline.fireChannelInactive();
                }
                if (QuicheQuicStreamChannel.this.registered) {
                    QuicheQuicStreamChannel.this.registered = false;
                    QuicheQuicStreamChannel.this.pipeline.fireChannelUnregistered();
                }
                promise.setSuccess();
            });
        }

        private void invokeLater(Runnable task) {
            try {
                QuicheQuicStreamChannel.this.eventLoop().execute(task);
            }
            catch (RejectedExecutionException e) {
                LOGGER.warn("Can't invoke task later as EventLoop rejected it", (Throwable)e);
            }
        }

        public void closeForcibly() {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            this.close(QuicheQuicStreamChannel.this.unsafe().voidPromise());
        }

        public void deregister(ChannelPromise promise) {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            this.deregister(promise, false);
        }

        public void beginRead() {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            QuicheQuicStreamChannel.this.readPending = true;
            if (QuicheQuicStreamChannel.this.readable) {
                QuicheQuicStreamChannel.this.unsafe().recv();
                QuicheQuicStreamChannel.this.parent().connectionSendAndFlush();
            }
        }

        private void closeIfNeeded(boolean wasFinSent) {
            if (!wasFinSent && QuicheQuicStreamChannel.this.finSent && (QuicheQuicStreamChannel.this.type() == QuicStreamType.UNIDIRECTIONAL || QuicheQuicStreamChannel.this.finReceived)) {
                this.close(this.voidPromise());
            }
        }

        boolean writeQueued() {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            boolean wasFinSent = QuicheQuicStreamChannel.this.finSent;
            QuicheQuicStreamChannel.this.inWriteQueued = true;
            try {
                Object msg;
                if (QuicheQuicStreamChannel.this.queue.isEmpty()) {
                    return false;
                }
                boolean written = false;
                while ((msg = QuicheQuicStreamChannel.this.queue.current()) != null) {
                    try {
                        int res = this.write0(msg);
                        if (res == 1) {
                            QuicheQuicStreamChannel.this.queue.remove().setSuccess();
                            written = true;
                            continue;
                        }
                        if (res == 0 || res == Quiche.QUICHE_ERR_DONE) break;
                        if (res == Quiche.QUICHE_ERR_STREAM_STOPPED) {
                            QuicheQuicStreamChannel.this.queue.removeAndFailAll((Throwable)new ChannelOutputShutdownException("STOP_SENDING frame received"));
                            QuicheQuicStreamChannel.this.forceClose();
                            break;
                        }
                        QuicheQuicStreamChannel.this.queue.remove().setFailure((Throwable)Quiche.convertToException(res));
                    }
                    catch (Exception e) {
                        QuicheQuicStreamChannel.this.queue.remove().setFailure((Throwable)e);
                    }
                }
                if (written) {
                    QuicheQuicStreamChannel.this.updateWritabilityIfNeeded(true);
                }
                boolean bl = written;
                return bl;
            }
            finally {
                this.closeIfNeeded(wasFinSent);
                QuicheQuicStreamChannel.this.inWriteQueued = false;
            }
        }

        public void write(Object msg, ChannelPromise promise) {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            if (!QuicheQuicStreamChannel.this.isOpen()) {
                this.queueAndFailAll(msg, promise, new ClosedChannelException());
            } else if (QuicheQuicStreamChannel.this.finSent) {
                this.queueAndFailAll(msg, promise, (Throwable)new ChannelOutputShutdownException("Fin was sent already"));
            } else if (!QuicheQuicStreamChannel.this.queue.isEmpty()) {
                try {
                    msg = this.filterMsg(msg);
                }
                catch (UnsupportedOperationException e) {
                    ReferenceCountUtil.release((Object)msg);
                    promise.setFailure((Throwable)e);
                    return;
                }
                ReferenceCountUtil.touch((Object)msg);
                QuicheQuicStreamChannel.this.queue.add(msg, promise);
                this.writeQueued();
            } else {
                assert (QuicheQuicStreamChannel.this.queue.isEmpty());
                this.writeWithoutCheckChannelState(msg, promise);
            }
        }

        private void queueAndFailAll(Object msg, ChannelPromise promise, Throwable cause) {
            ReferenceCountUtil.touch((Object)msg);
            QuicheQuicStreamChannel.this.queue.add(msg, promise);
            QuicheQuicStreamChannel.this.queue.removeAndFailAll(cause);
        }

        private Object filterMsg(Object msg) {
            if (msg instanceof ByteBuf) {
                ByteBuf buffer = (ByteBuf)msg;
                if (!buffer.isDirect()) {
                    ByteBuf tmpBuffer = QuicheQuicStreamChannel.this.alloc().directBuffer(buffer.readableBytes());
                    tmpBuffer.writeBytes(buffer, buffer.readerIndex(), buffer.readableBytes());
                    buffer.release();
                    return tmpBuffer;
                }
            } else if (msg instanceof QuicStreamFrame) {
                QuicStreamFrame frame = (QuicStreamFrame)msg;
                ByteBuf buffer = frame.content();
                if (!buffer.isDirect()) {
                    ByteBuf tmpBuffer = QuicheQuicStreamChannel.this.alloc().directBuffer(buffer.readableBytes());
                    tmpBuffer.writeBytes(buffer, buffer.readerIndex(), buffer.readableBytes());
                    QuicStreamFrame tmpFrame = frame.replace(tmpBuffer);
                    frame.release();
                    return tmpFrame;
                }
            } else {
                throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)msg));
            }
            return msg;
        }

        void writeWithoutCheckChannelState(Object msg, ChannelPromise promise) {
            block12: {
                try {
                    msg = this.filterMsg(msg);
                }
                catch (UnsupportedOperationException e) {
                    ReferenceCountUtil.release((Object)msg);
                    promise.setFailure((Throwable)e);
                }
                boolean wasFinSent = QuicheQuicStreamChannel.this.finSent;
                boolean mayNeedWritabilityUpdate = false;
                try {
                    try {
                        int res = this.write0(msg);
                        if (res > 0) {
                            ReferenceCountUtil.release((Object)msg);
                            promise.setSuccess();
                            mayNeedWritabilityUpdate = QuicheQuicStreamChannel.this.capacity == 0;
                            break block12;
                        }
                        if (res == 0 || res == Quiche.QUICHE_ERR_DONE) {
                            ReferenceCountUtil.touch((Object)msg);
                            QuicheQuicStreamChannel.this.queue.add(msg, promise);
                            mayNeedWritabilityUpdate = true;
                            break block12;
                        }
                        if (res == Quiche.QUICHE_ERR_STREAM_STOPPED) {
                            throw new ChannelOutputShutdownException("STOP_SENDING frame received");
                        }
                        throw Quiche.convertToException(res);
                    }
                    catch (Exception e) {
                        ReferenceCountUtil.release((Object)msg);
                        promise.setFailure((Throwable)e);
                        boolean bl = mayNeedWritabilityUpdate = QuicheQuicStreamChannel.this.capacity == 0;
                        if (mayNeedWritabilityUpdate) {
                            QuicheQuicStreamChannel.this.updateWritabilityIfNeeded(false);
                        }
                        this.closeIfNeeded(wasFinSent);
                    }
                }
                finally {
                    if (mayNeedWritabilityUpdate) {
                        QuicheQuicStreamChannel.this.updateWritabilityIfNeeded(false);
                    }
                    this.closeIfNeeded(wasFinSent);
                }
            }
        }

        private int write0(Object msg) throws Exception {
            ByteBuf buffer;
            boolean fin;
            if (QuicheQuicStreamChannel.this.type() == QuicStreamType.UNIDIRECTIONAL && !QuicheQuicStreamChannel.this.isLocalCreated()) {
                throw new UnsupportedOperationException("Writes on non-local created streams that are unidirectional are not supported");
            }
            if (QuicheQuicStreamChannel.this.finSent) {
                throw new ChannelOutputShutdownException("Fin was sent already");
            }
            if (msg instanceof ByteBuf) {
                fin = false;
                buffer = (ByteBuf)msg;
            } else {
                QuicStreamFrame frame = (QuicStreamFrame)msg;
                fin = frame.hasFin();
                buffer = frame.content();
            }
            boolean readable = buffer.isReadable();
            if (!fin && !readable) {
                return 1;
            }
            boolean sendSomething = false;
            try {
                do {
                    int res = QuicheQuicStreamChannel.this.parent().streamSend(QuicheQuicStreamChannel.this.streamId(), buffer, fin);
                    int cap = QuicheQuicStreamChannel.this.parent.streamCapacity(QuicheQuicStreamChannel.this.streamId());
                    if (cap >= 0) {
                        QuicheQuicStreamChannel.this.capacity = cap;
                    }
                    if (res < 0) {
                        int n = res;
                        return n;
                    }
                    if (readable && res == 0) {
                        return 0;
                    }
                    sendSomething = true;
                    buffer.skipBytes(res);
                } while (buffer.isReadable());
                if (fin) {
                    QuicheQuicStreamChannel.this.finSent = true;
                    QuicheQuicStreamChannel.this.outputShutdown = true;
                }
                return 1;
            }
            finally {
                if (sendSomething) {
                    QuicheQuicStreamChannel.this.parent.connectionSendAndFlush();
                }
            }
        }

        public void flush() {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
        }

        public ChannelPromise voidPromise() {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            return this.voidPromise;
        }

        @Nullable
        public ChannelOutboundBuffer outboundBuffer() {
            return null;
        }

        private void closeOnRead(ChannelPipeline pipeline, boolean readFrames) {
            if (readFrames && QuicheQuicStreamChannel.this.finReceived && QuicheQuicStreamChannel.this.finSent) {
                this.close(this.voidPromise());
            } else if (QuicheQuicStreamChannel.this.config.isAllowHalfClosure()) {
                if (QuicheQuicStreamChannel.this.finReceived) {
                    pipeline.fireUserEventTriggered((Object)ChannelInputShutdownEvent.INSTANCE);
                    pipeline.fireUserEventTriggered((Object)ChannelInputShutdownReadComplete.INSTANCE);
                    if (QuicheQuicStreamChannel.this.finSent) {
                        this.close(this.voidPromise());
                    }
                }
            } else {
                this.close(this.voidPromise());
            }
        }

        private void handleReadException(ChannelPipeline pipeline, @Nullable ByteBuf byteBuf, Throwable cause, RecvByteBufAllocator.Handle allocHandle, boolean readFrames) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    pipeline.fireChannelRead((Object)byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            this.readComplete(allocHandle, pipeline);
            pipeline.fireExceptionCaught(cause);
            if (QuicheQuicStreamChannel.this.finReceived) {
                this.closeOnRead(pipeline, readFrames);
            }
        }

        /*
         * Handled impossible loop by duplicating code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void recv() {
            assert (QuicheQuicStreamChannel.this.eventLoop().inEventLoop());
            if (QuicheQuicStreamChannel.this.inRecv) {
                return;
            }
            QuicheQuicStreamChannel.this.inRecv = true;
            try {
                block23: {
                    boolean readFrames;
                    RecvByteBufAllocator.Handle allocHandle;
                    DirectIoByteBufAllocator allocator;
                    QuicheQuicStreamChannelConfig config;
                    ChannelPipeline pipeline;
                    block22: {
                        pipeline = QuicheQuicStreamChannel.this.pipeline();
                        config = (QuicheQuicStreamChannelConfig)QuicheQuicStreamChannel.this.config();
                        allocator = config.allocator;
                        allocHandle = this.recvBufAllocHandle();
                        readFrames = config.isReadFrames();
                        if (!true) break block22;
                        if (!QuicheQuicStreamChannel.this.active) return;
                        if (!QuicheQuicStreamChannel.this.readPending) return;
                        if (!QuicheQuicStreamChannel.this.readable) break block23;
                    }
                    do {
                        allocHandle.reset((ChannelConfig)config);
                        ByteBuf byteBuf = null;
                        QuicheQuicChannel parent = QuicheQuicStreamChannel.this.parent();
                        boolean readCompleteNeeded = false;
                        boolean continueReading = true;
                        try {
                            while (!QuicheQuicStreamChannel.this.finReceived && continueReading) {
                                byteBuf = allocHandle.allocate((ByteBufAllocator)allocator);
                                allocHandle.attemptedBytesRead(byteBuf.writableBytes());
                                switch (parent.streamRecv(QuicheQuicStreamChannel.this.streamId(), byteBuf)) {
                                    case DONE: {
                                        QuicheQuicStreamChannel.this.readable = false;
                                        break;
                                    }
                                    case FIN: {
                                        QuicheQuicStreamChannel.this.readable = false;
                                        QuicheQuicStreamChannel.this.finReceived = true;
                                        QuicheQuicStreamChannel.this.inputShutdown = true;
                                        break;
                                    }
                                    case OK: {
                                        break;
                                    }
                                    default: {
                                        throw new Error();
                                    }
                                }
                                allocHandle.lastBytesRead(byteBuf.readableBytes());
                                if (allocHandle.lastBytesRead() <= 0) {
                                    byteBuf.release();
                                    if (QuicheQuicStreamChannel.this.finReceived && readFrames) {
                                        byteBuf = Unpooled.EMPTY_BUFFER;
                                    } else {
                                        byteBuf = null;
                                        break;
                                    }
                                }
                                allocHandle.incMessagesRead(1);
                                readCompleteNeeded = true;
                                QuicheQuicStreamChannel.this.readPending = false;
                                if (readFrames) {
                                    pipeline.fireChannelRead((Object)new DefaultQuicStreamFrame(byteBuf, QuicheQuicStreamChannel.this.finReceived));
                                } else {
                                    pipeline.fireChannelRead((Object)byteBuf);
                                }
                                byteBuf = null;
                                continueReading = allocHandle.continueReading();
                            }
                            if (readCompleteNeeded) {
                                this.readComplete(allocHandle, pipeline);
                            }
                            if (QuicheQuicStreamChannel.this.finReceived) {
                                QuicheQuicStreamChannel.this.readable = false;
                                this.closeOnRead(pipeline, readFrames);
                            }
                        }
                        catch (Throwable cause) {
                            QuicheQuicStreamChannel.this.readable = false;
                            this.handleReadException(pipeline, byteBuf, cause, allocHandle, readFrames);
                        }
                        if (!QuicheQuicStreamChannel.this.active) return;
                        if (!QuicheQuicStreamChannel.this.readPending) return;
                    } while (QuicheQuicStreamChannel.this.readable);
                }
                return;
            }
            finally {
                QuicheQuicStreamChannel.this.inRecv = false;
                QuicheQuicStreamChannel.this.removeStreamFromParent();
            }
        }

        private void readComplete(RecvByteBufAllocator.Handle allocHandle, ChannelPipeline pipeline) {
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
        }
    }
}

