/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.integration.create;

import com.simibubi.create.Create;
import com.simibubi.create.content.redstone.displayLink.DisplayLinkContext;
import com.simibubi.create.content.redstone.displayLink.source.SingleLineDisplaySource;
import com.simibubi.create.content.redstone.displayLink.target.DisplayTargetStats;
import com.simibubi.create.content.trains.display.FlapDisplaySection;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.CreateLang;
import net.mehvahdjukaar.supplementaries.common.block.tiles.ClockBlockTile;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ClockDisplaySource
extends SingleLineDisplaySource {
    public static final MutableComponent EMPTY_TIME = Component.m_237113_((String)"--:--");

    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        Level level = context.level();
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            BlockEntity blockEntity = context.getSourceBlockEntity();
            if (blockEntity instanceof ClockBlockTile) {
                ClockBlockTile tile = (ClockBlockTile)blockEntity;
                boolean c12 = context.sourceConfig().m_128451_("Cycle") == 0;
                boolean isNatural = sLevel.m_6042_().f_63858_();
                int dayTime = (int)(sLevel.m_46468_() % 24000L);
                int hours = (dayTime / 1000 + 6) % 24;
                int minutes = dayTime % 1000 * 60 / 1000;
                MutableComponent suffix = CreateLang.translateDirect((String)("generic.daytime." + (hours > 11 ? "pm" : "am")), (Object[])new Object[0]);
                minutes = minutes / 5 * 5;
                if (c12 && (hours %= 12) == 0) {
                    hours = 12;
                }
                if (!isNatural) {
                    hours = Create.RANDOM.nextInt(70) + 24;
                    minutes = Create.RANDOM.nextInt(40) + 60;
                }
                MutableComponent component = Component.m_237113_((String)((hours < 10 ? " " : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + (c12 ? " " : "")));
                return c12 ? component.m_7220_((Component)suffix) : component;
            }
        }
        return EMPTY_TIME;
    }

    protected String getFlapDisplayLayoutName(DisplayLinkContext context) {
        return "Instant";
    }

    protected FlapDisplaySection createSectionForValue(DisplayLinkContext context, int size) {
        return new FlapDisplaySection((float)size * 7.0f, "instant", false, false);
    }

    protected String getTranslationKey() {
        return "time_of_day";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (!isFirstLine) {
            builder.addSelectionScrollInput(0, 60, (si, l) -> si.forOptions(CreateLang.translatedOptions((String)"display_source.time", (String[])new String[]{"12_hour", "24_hour"})).titled(CreateLang.translateDirect((String)"display_source.time.format", (Object[])new Object[0])), "Cycle");
        }
    }

    protected boolean allowsLabeling(DisplayLinkContext context) {
        return true;
    }
}

