/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.kubejs;

import com.jesz.createdieselgenerators.fuel_type.FuelType;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.HolderSet;
import net.minecraft.world.level.material.Fluid;

public class FuelTypeBuilder {
    float normalSpeed;
    float modularSpeed;
    float hugeSpeed;
    float normalStrength;
    float modularStrength;
    float hugeStrength;
    float burnerStrength;
    float normalBurn;
    float modularBurn;
    float hugeBurn;
    float pitch;
    Consumer<FuelType> callback;

    public FuelTypeBuilder(Consumer<FuelType> callback) {
        this.callback = callback;
    }

    public FuelTypeBuilder normalSpeed(float speed) {
        this.normalSpeed = speed;
        return this;
    }

    public FuelTypeBuilder modularSpeed(float speed) {
        this.modularSpeed = speed;
        return this;
    }

    public FuelTypeBuilder hugeSpeed(float speed) {
        this.hugeSpeed = speed;
        return this;
    }

    public FuelTypeBuilder normalStrength(float strength) {
        this.normalStrength = strength;
        return this;
    }

    public FuelTypeBuilder modularStrength(float strength) {
        this.modularStrength = strength;
        return this;
    }

    public FuelTypeBuilder hugeStrength(float strength) {
        this.hugeStrength = strength;
        return this;
    }

    public FuelTypeBuilder normalBurn(float burn) {
        this.normalBurn = burn;
        return this;
    }

    public FuelTypeBuilder modularBurn(float burn) {
        this.modularBurn = burn;
        return this;
    }

    public FuelTypeBuilder hugeBurn(float burn) {
        this.hugeBurn = burn;
        return this;
    }

    public FuelTypeBuilder soundPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    public FuelTypeBuilder burnerStrength(float burnerStrength) {
        this.burnerStrength = burnerStrength;
        return this;
    }

    public FuelType build() {
        FuelType type = new FuelType((HolderSet<Fluid>)HolderSet.m_205800_(List.of()), new FuelType.PerEngineProperties(this.normalSpeed, this.normalStrength, this.normalBurn), new FuelType.PerEngineProperties(this.modularSpeed, this.modularStrength, this.modularBurn), new FuelType.PerEngineProperties(this.hugeSpeed, this.hugeStrength, this.hugeBurn), this.pitch, this.burnerStrength);
        this.callback.accept(type);
        return type;
    }
}

