/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.pneumatic_tube;

import com.petrolpark.compat.create.core.tube.ITubeBlock;
import com.petrolpark.compat.create.core.tube.TubeSpline;
import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsConfigs;
import com.petrolpark.petrolsparts.content.pneumatic_tube.PneumaticTubeBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;

public class PneumaticTubeBlock
extends DirectionalKineticBlock
implements IBE<PneumaticTubeBlockEntity>,
ICogWheel,
ITubeBlock {
    public final boolean filterable;

    public static PneumaticTubeBlock filterable(BlockBehaviour.Properties properties) {
        return new PneumaticTubeBlock(properties, true);
    }

    public static PneumaticTubeBlock notFilterable(BlockBehaviour.Properties properties) {
        return new PneumaticTubeBlock(properties, false);
    }

    public PneumaticTubeBlock(BlockBehaviour.Properties properties, boolean filterable) {
        super(properties);
        this.filterable = filterable;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return this.onBlockEntityUse((BlockGetter)context.m_43725_(), context.m_8083_(), be -> be.flip(context.m_43723_()));
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (this.tryReconnect(context)) {
            return InteractionResult.SUCCESS;
        }
        return super.onSneakWrenched(state, context);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.withBlockEntityDo((BlockGetter)level, neighborPos, be -> be.asOutput().ifPresent(PneumaticTubeBlockEntity.Output::forgetBlocked));
        return state;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, world, pos, newState, isMoving);
        this.getBlockEntityOptional((BlockGetter)world, pos).ifPresent(be -> ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)be.itemBacklog));
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public double getTubeSegmentRadius() {
        return 0.375;
    }

    public double getTubeSegmentLength() {
        return 0.1875;
    }

    public double getTubeMaxAngle() {
        return 0.5235987901687622;
    }

    public int getItemsForTubeLength(double length) {
        return (int)Math.round(length * (double)PetrolsPartsConfigs.server().pneumaticTubeCost.getF());
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public Direction getTubeConnectingFace(Level level, BlockPos pos, BlockState state) {
        return (Direction)state.m_61143_((Property)FACING);
    }

    public void connectTube(Level level, TubeSpline spline) {
        this.withBlockEntityDo((BlockGetter)level, spline.start.getPos(), be -> be.tube.connect(spline));
    }

    public Class<PneumaticTubeBlockEntity> getBlockEntityClass() {
        return PneumaticTubeBlockEntity.class;
    }

    public BlockEntityType<? extends PneumaticTubeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)PetrolsPartsBlockEntityTypes.PNEUMATIC_TUBE.get();
    }
}

