/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.colossal_cogwheel;

import com.petrolpark.petrolsparts.content.colossal_cogwheel.ColossalCogwheelBlock;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementBehaviour;
import com.petrolpark.petrolsparts.core.advancement.PetrolsPartsAdvancementTrigger;
import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ICogWheel;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class ColossalCogwheelBlockEntity
extends KineticBlockEntity {
    private PetrolsPartsAdvancementBehaviour advancementBehaviour;
    private int checkAdvancementTimer = 100;

    public ColossalCogwheelBlockEntity(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.advancementBehaviour = new PetrolsPartsAdvancementBehaviour((SmartBlockEntity)this, PetrolsPartsAdvancementTrigger.COLOSSAL_COGWHEEL_POWER_MANY);
        behaviours.add((BlockEntityBehaviour)this.advancementBehaviour);
    }

    protected AABB createRenderBoundingBox() {
        if (ColossalCogwheelBlock.isController(this.m_58900_())) {
            AABB aabb = new AABB(this.m_58899_().m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(this.m_58900_())));
            switch ((Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS)) {
                case X: {
                    return aabb.m_82377_(0.0, 2.0, 2.0);
                }
                case Y: {
                    return aabb.m_82377_(2.0, 0.0, 2.0);
                }
                case Z: {
                    return aabb.m_82377_(2.0, 2.0, 0.0);
                }
            }
        }
        return super.createRenderBoundingBox();
    }

    public float propagateRotationTo(KineticBlockEntity target, BlockState stateFrom, BlockState stateTo, BlockPos diff, boolean connectedViaAxes, boolean connectedViaCogs) {
        if (stateTo.m_60734_() instanceof ColossalCogwheelBlock && ColossalCogwheelBlock.getRelativeCenterPosition(stateFrom).equals((Object)diff.m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(stateTo)))) {
            return 1.0f;
        }
        return ColossalCogwheelBlockEntity.propagateFromColossalCogwheel(stateFrom, stateTo, diff);
    }

    public static float propagateFromColossalCogwheel(BlockState colossalState, BlockState otherCogState, BlockPos diff) {
        BlockPos relCenter = ColossalCogwheelBlock.getRelativeCenterPosition(colossalState);
        boolean toLargeCog = ICogWheel.isLargeCog((BlockState)otherCogState);
        if (toLargeCog || ICogWheel.isSmallCog((BlockState)otherCogState)) {
            Direction.Axis axis = (Direction.Axis)colossalState.m_61143_((Property)RotatedPillarKineticBlock.AXIS);
            if (((IRotate)otherCogState.m_60734_()).getRotationAxis(otherCogState) != axis) {
                return 0.0f;
            }
            ColossalCogwheelBlock.Position.Clock posClock = (ColossalCogwheelBlock.Position.Clock)((Object)colossalState.m_61143_(ColossalCogwheelBlock.POSITION_CLOCK));
            for (ColossalCogwheelBlock.Connection.Type connectionType : ColossalCogwheelBlock.Connection.Type.values()) {
                ColossalCogwheelBlock.Connection connection;
                if (!relCenter.m_121996_((Vec3i)connectionType.relativeCenterPos.apply(axis, posClock.getDirection(axis))).equals((Object)diff) || (connection = connectionType.connection).toLargeCog() != toLargeCog) continue;
                return connection.ratio();
            }
        }
        return 0.0f;
    }

    public void tick() {
        super.tick();
        if (this.checkAdvancementTimer > 0) {
            --this.checkAdvancementTimer;
        }
        if (this.checkAdvancementTimer <= 0) {
            this.tryAwardCogsPoweringAdvancement();
            this.checkAdvancementTimer = 100;
        }
    }

    public void tryAwardCogsPoweringAdvancement() {
        BlockPos center = this.m_58899_().m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(this.m_58900_()));
        this.advancementBehaviour.awardAdvancementIf(PetrolsPartsAdvancementTrigger.COLOSSAL_COGWHEEL_POWER_MANY, () -> ColossalCogwheelBlock.Connection.getAll(center, (Direction.Axis)this.m_58900_().m_61143_((Property)RotatedPillarKineticBlock.AXIS)).stream().filter(pair -> {
            KineticBlockEntity kbe;
            BlockPos pos = (BlockPos)pair.getFirst();
            BlockEntity be = this.m_58904_().m_7702_(pos);
            if (be instanceof KineticBlockEntity && (kbe = (KineticBlockEntity)be).hasSource()) {
                BlockState sourceState = this.m_58904_().m_8055_(kbe.source);
                return sourceState.m_60734_() instanceof ColossalCogwheelBlock && kbe.source.m_121955_((Vec3i)ColossalCogwheelBlock.getRelativeCenterPosition(sourceState)).equals((Object)center);
            }
            return false;
        }).count() >= 6L);
    }
}

