/*
 * Decompiled with CFR 0.152.
 */
package com.petrolpark.petrolsparts.content.coaxial_gear;

import com.petrolpark.compat.create.block.entity.behaviour.AbstractRememberPlacerBehaviour;
import com.petrolpark.petrolsparts.PetrolsPartsBlockEntityTypes;
import com.petrolpark.petrolsparts.PetrolsPartsBlocks;
import com.petrolpark.petrolsparts.PetrolsPartsShapes;
import com.petrolpark.petrolsparts.core.block.DirectionalRotatedPillarKineticBlock;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.RotatedPillarKineticBlock;
import com.simibubi.create.content.kinetics.simpleRelays.CogWheelBlock;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoaxialGearBlock
extends CogWheelBlock {
    public static final BooleanProperty HAS_SHAFT = BooleanProperty.m_61465_((String)"has_shaft");

    public static boolean isCoaxialGear(BlockState state) {
        return state.m_60734_() instanceof CoaxialGearBlock;
    }

    public static boolean isCoaxialGear(Block block) {
        return block instanceof CoaxialGearBlock;
    }

    public CoaxialGearBlock(BlockBehaviour.Properties properties, boolean large) {
        super(large, properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)HAS_SHAFT, (Comparable)Boolean.valueOf(false)));
    }

    public static CoaxialGearBlock large(BlockBehaviour.Properties properties) {
        return new CoaxialGearBlock(properties, true);
    }

    public static CoaxialGearBlock small(BlockBehaviour.Properties properties) {
        return new CoaxialGearBlock(properties, false);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HAS_SHAFT});
        super.m_7926_(builder);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return ((Boolean)state.m_61143_((Property)HAS_SHAFT) != false ? AllShapes.SMALL_GEAR : PetrolsPartsShapes.COAXIAL_GEAR).get((Direction.Axis)state.m_61143_((Property)RotatedPillarKineticBlock.AXIS));
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (((Boolean)state.m_61143_((Property)HAS_SHAFT)).booleanValue()) {
            CoaxialGearBlock.updatePropagationOfLongShaft(oldState, (LevelReader)worldIn, pos);
        }
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(worldIn, pos, state, placer, stack);
        AbstractRememberPlacerBehaviour.setPlacedBy((Level)worldIn, (BlockPos)pos, (LivingEntity)placer);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        if (((Boolean)state.m_61143_((Property)HAS_SHAFT)).booleanValue()) {
            if (this.tryRemoveBracket(context)) {
                return InteractionResult.SUCCESS;
            }
            if (this.tryRemoveLongShaft(state, context.m_43725_(), context.m_8083_(), false)) {
                Player player = context.m_43723_();
                if (player != null && player.m_7500_()) {
                    player.m_150109_().m_150079_(PetrolsPartsBlocks.COAXIAL_GEAR.asStack());
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.onWrenched(state, context);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (facing.m_122434_() == state.m_61143_((Property)AXIS)) {
            CoaxialGearBlock.updatePropagationOfLongShaft(state, (LevelReader)level, currentPos);
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public static void updatePropagationOfLongShaft(BlockState state, LevelReader level, BlockPos pos) {
        if (CoaxialGearBlock.isCoaxialGear(state) && ((Boolean)state.m_61143_((Property)HAS_SHAFT)).booleanValue() && !level.m_5776_()) {
            Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
            for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
                BlockPos longShaftPos = pos.m_121945_(Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)axis));
                BlockState longShaftState = level.m_8055_(pos.m_121945_(Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)axis)));
                if (!PetrolsPartsBlocks.LONG_SHAFT.has(longShaftState) || longShaftState.m_61143_((Property)AXIS) != axis || (Boolean)longShaftState.m_61143_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION) != (axisDirection != Direction.AxisDirection.POSITIVE)) continue;
                level.m_141902_(longShaftPos, (BlockEntityType)PetrolsPartsBlockEntityTypes.LONG_SHAFT.get()).ifPresent(be -> {
                    be.updateSpeed = true;
                });
                return;
            }
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state != newState && newState.m_60795_() && !isMoving && this.tryRemoveLongShaft(state, world, pos, true)) {
            Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)AllBlocks.SHAFT.asStack());
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public static boolean tryMakeLongShaft(BlockState state, Block coaxialGearBlock, Level level, BlockPos pos, Player player, Direction preferredDirection) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)AXIS);
        if (preferredDirection.m_122434_() != axis) {
            return false;
        }
        for (Direction direction : new Direction[]{preferredDirection, preferredDirection.m_122424_()}) {
            BlockPos shaftPos = pos.m_121945_(direction);
            BlockState shaftState = level.m_8055_(shaftPos);
            if (!ShaftBlock.isShaft((BlockState)shaftState) || shaftState.m_61143_((Property)AXIS) != axis) continue;
            if (!level.m_5776_()) {
                level.m_46597_(shaftPos, (BlockState)((BlockState)PetrolsPartsBlocks.LONG_SHAFT.getDefaultState().m_61124_((Property)AXIS, (Comparable)axis)).m_61124_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION, (Comparable)Boolean.valueOf(direction.m_122421_() != Direction.AxisDirection.POSITIVE)));
                level.m_46597_(pos, (BlockState)((BlockState)coaxialGearBlock.m_49966_().m_61124_((Property)AXIS, (Comparable)axis)).m_61124_((Property)HAS_SHAFT, (Comparable)Boolean.valueOf(true)));
                AbstractRememberPlacerBehaviour.setPlacedBy((Level)level, (BlockPos)pos, (LivingEntity)player);
            }
            return true;
        }
        return false;
    }

    protected boolean tryRemoveLongShaft(BlockState state, Level level, BlockPos pos, boolean removing) {
        Direction.Axis thisAxis = (Direction.Axis)state.m_61143_((Property)AXIS);
        for (Direction.AxisDirection axisDirection : Direction.AxisDirection.values()) {
            BlockPos longShaftPos = pos.m_121945_(Direction.m_122390_((Direction.AxisDirection)axisDirection, (Direction.Axis)thisAxis));
            BlockState longShaftState = level.m_8055_(longShaftPos);
            if (!PetrolsPartsBlocks.LONG_SHAFT.has(longShaftState) || longShaftState.m_61143_((Property)AXIS) != thisAxis || (Boolean)longShaftState.m_61143_((Property)DirectionalRotatedPillarKineticBlock.POSITIVE_AXIS_DIRECTION) == (axisDirection == Direction.AxisDirection.POSITIVE)) continue;
            if (!level.m_5776_()) {
                if (!removing) {
                    level.m_46597_(pos, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)AXIS, (Comparable)thisAxis));
                }
                level.m_46597_(longShaftPos, (BlockState)AllBlocks.SHAFT.getDefaultState().m_61124_((Property)AXIS, (Comparable)thisAxis));
            }
            return true;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (player.m_6144_() || !player.m_36326_()) {
            return InteractionResult.PASS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (AllBlocks.SHAFT.isIn(stack) && !((Boolean)state.m_61143_((Property)HAS_SHAFT)).booleanValue()) {
            if (CoaxialGearBlock.tryMakeLongShaft(state, state.m_60734_(), world, pos, player, Direction.m_175357_((Entity)player, (Direction.Axis)((Direction.Axis)state.m_61143_((Property)AXIS))))) {
                if (!player.m_7500_() && !world.m_5776_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.m_19078_((boolean)world.m_5776_());
            }
            player.m_5661_((Component)Component.m_237115_((String)"petrolsparts.tooltip.coaxial_gear.shaft_too_short").m_130940_(ChatFormatting.RED), true);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return false;
    }

    public BlockEntityType<? extends KineticBlockEntity> getBlockEntityType() {
        return (BlockEntityType)PetrolsPartsBlockEntityTypes.COAXIAL_GEAR.get();
    }
}

