/*
 * Decompiled with CFR 0.152.
 */
package cc.tweaked_programs.cccbridge.common.computercraft.peripherals;

import cc.tweaked_programs.cccbridge.common.assistance.animatronic.Face;
import cc.tweaked_programs.cccbridge.common.assistance.animatronic.Transition;
import cc.tweaked_programs.cccbridge.common.computercraft.TweakedPeripheral;
import cc.tweaked_programs.cccbridge.common.minecraft.blockEntity.AnimatronicBlockEntity;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.lua.LuaFunction;
import dan200.computercraft.api.lua.MethodResult;
import javax.annotation.Nullable;
import net.minecraft.core.Rotations;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class AnimatronicPeripheral
implements TweakedPeripheral<AnimatronicBlockEntity> {
    private final AnimatronicBlockEntity be;
    private float[] headRot;
    private float[] bodyRot;
    private float[] leftArmRot;
    private float[] rightArmRot;

    public static double getVersion() {
        return 1.1;
    }

    public AnimatronicPeripheral(AnimatronicBlockEntity blockEntity) {
        this.be = blockEntity;
        this.headRot = new float[]{0.0f, 0.0f, 0.0f};
        this.bodyRot = new float[]{0.0f, 0.0f, 0.0f};
        this.leftArmRot = new float[]{0.0f, 0.0f, 0.0f};
        this.rightArmRot = new float[]{0.0f, 0.0f, 0.0f};
    }

    @LuaFunction
    public final void setFace(String face) throws LuaException {
        Face value = Face.contains(face);
        if (value != null) {
            AnimatronicBlockEntity be = this.getTarget();
            if (be != null) {
                be.setFace(value);
                be.m_6596_();
            }
        } else {
            throw new LuaException("Given string must be one of the following options: " + Face.availableOptions());
        }
    }

    @LuaFunction
    public final void setTransition(String kind) throws LuaException {
        Transition value = Transition.contains(kind);
        if (value != null) {
            AnimatronicBlockEntity be = this.getTarget();
            if (be != null) {
                be.setTransition(value);
            }
        } else {
            throw new LuaException("Given string must be one of the following options: " + Transition.availableOptions());
        }
    }

    @LuaFunction
    public final void push() {
        AnimatronicBlockEntity be = this.getTarget();
        if (be != null) {
            be.setHeadPose(this.headRot[0], this.headRot[1], this.headRot[2]);
            be.setBodyPose(this.bodyRot[0], this.bodyRot[1], this.bodyRot[2]);
            be.setLeftArmPose(this.leftArmRot[0], this.leftArmRot[1], this.leftArmRot[2]);
            be.setRightArmPose(this.rightArmRot[0], this.rightArmRot[1], this.rightArmRot[2]);
            be.m_6596_();
        }
        this.headRot = new float[]{0.0f, 0.0f, 0.0f};
        this.bodyRot = new float[]{0.0f, 0.0f, 0.0f};
        this.leftArmRot = new float[]{0.0f, 0.0f, 0.0f};
        this.rightArmRot = new float[]{0.0f, 0.0f, 0.0f};
    }

    @LuaFunction
    public final void setHeadRot(double x, double y, double z) {
        x = Mth.m_14008_((double)x, (double)-180.0, (double)180.0);
        y = Mth.m_14008_((double)y, (double)-180.0, (double)180.0);
        z = Mth.m_14008_((double)z, (double)-180.0, (double)180.0);
        this.headRot = new float[]{(float)x, (float)y, (float)z};
    }

    @LuaFunction
    public final void setBodyRot(double x, double y, double z) {
        x = Mth.m_14008_((double)x, (double)-360.0, (double)360.0);
        y = Mth.m_14008_((double)y, (double)-180.0, (double)180.0);
        z = Mth.m_14008_((double)z, (double)-180.0, (double)180.0);
        this.bodyRot = new float[]{(float)x, (float)y, (float)z};
    }

    @LuaFunction
    public final void setLeftArmRot(double x, double y, double z) {
        x = Mth.m_14008_((double)x, (double)-180.0, (double)180.0);
        y = Mth.m_14008_((double)y, (double)-180.0, (double)180.0);
        z = Mth.m_14008_((double)z, (double)-180.0, (double)180.0);
        this.leftArmRot = new float[]{(float)x, (float)y, (float)z};
    }

    @LuaFunction
    public final void setRightArmRot(double x, double y, double z) {
        x = Mth.m_14008_((double)x, (double)-180.0, (double)180.0);
        y = Mth.m_14008_((double)y, (double)-180.0, (double)180.0);
        z = Mth.m_14008_((double)z, (double)-180.0, (double)180.0);
        this.rightArmRot = new float[]{(float)x, (float)y, (float)z};
    }

    @LuaFunction
    public final MethodResult getStoredHeadRot() {
        return MethodResult.of((Object[])new Object[]{(double)this.headRot[0], (double)this.headRot[1], (double)this.headRot[2]});
    }

    @LuaFunction
    public final MethodResult getStoredBodyRot() {
        return MethodResult.of((Object[])new Object[]{(double)this.bodyRot[0], (double)this.bodyRot[1], (double)this.bodyRot[2]});
    }

    @LuaFunction
    public final MethodResult getStoredLeftArmRot() {
        return MethodResult.of((Object[])new Object[]{(double)this.leftArmRot[0], (double)this.leftArmRot[1], (double)this.leftArmRot[2]});
    }

    @LuaFunction
    public final MethodResult getStoredRightArmRot() {
        return MethodResult.of((Object[])new Object[]{(double)this.rightArmRot[0], (double)this.rightArmRot[1], (double)this.rightArmRot[2]});
    }

    @LuaFunction
    public final MethodResult getAppliedHeadRot() {
        AnimatronicBlockEntity be = this.getTarget();
        if (be != null) {
            Rotations rot = be.getHeadPose();
            return MethodResult.of((Object[])new Object[]{(double)rot.m_123156_(), (double)rot.m_123157_(), (double)rot.m_123158_()});
        }
        return MethodResult.of((Object[])new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
    }

    @LuaFunction
    public final MethodResult getAppliedBodyRot() {
        AnimatronicBlockEntity be = this.getTarget();
        if (be != null) {
            Rotations rot = be.getBodyPose();
            return MethodResult.of((Object[])new Object[]{(double)rot.m_123156_(), (double)rot.m_123157_(), (double)rot.m_123158_()});
        }
        return MethodResult.of((Object[])new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
    }

    @LuaFunction
    public final MethodResult getAppliedLeftArmRot() {
        AnimatronicBlockEntity be = this.getTarget();
        if (be != null) {
            Rotations rot = be.getLeftArmPose();
            return MethodResult.of((Object[])new Object[]{(double)rot.m_123156_(), (double)rot.m_123157_(), (double)rot.m_123158_()});
        }
        return MethodResult.of((Object[])new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
    }

    @LuaFunction
    public final MethodResult getAppliedRightArmRot() {
        AnimatronicBlockEntity be = this.getTarget();
        if (be != null) {
            Rotations rot = be.getRightArmPose();
            return MethodResult.of((Object[])new Object[]{(double)rot.m_123156_(), (double)rot.m_123157_(), (double)rot.m_123158_()});
        }
        return MethodResult.of((Object[])new Object[]{Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)});
    }

    @Override
    @NotNull
    public String getType() {
        return "animatronic";
    }

    @Override
    @Nullable
    public AnimatronicBlockEntity getTarget() {
        return this.be;
    }
}

