/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.registry.builtin;

import com.google.common.collect.Maps;
import com.teamabnormals.atmospheric.core.AtmosphericConfig;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.world.modification.structure.SimpleStructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletter;
import com.teamabnormals.blueprint.common.world.modification.structure.StructureRepaletterEntry;
import com.teamabnormals.blueprint.common.world.modification.structure.WeightedStructureRepaletter;
import com.teamabnormals.blueprint.core.api.conditions.BlueprintAndCondition;
import com.teamabnormals.blueprint.core.api.conditions.ConfigValueCondition;
import com.teamabnormals.blueprint.core.registry.BlueprintDataPackRegistries;
import com.teamabnormals.blueprint.core.registry.BlueprintHolderSets;
import com.teamabnormals.woodworks.core.WoodworksConfig;
import com.teamabnormals.woodworks.core.data.server.WoodworksRecipeProvider;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;

public final class AtmosphericStructureRepaletters {
    public static final ConfigValueCondition GRIMWOOD_ANCIENT_CITIES = AtmosphericStructureRepaletters.config(AtmosphericConfig.COMMON.grimwoodAncientCities, "grimwood_ancient_cities");
    public static final ConfigValueCondition YUCCA_DESERT_VILLAGES = AtmosphericStructureRepaletters.config(AtmosphericConfig.COMMON.yuccaDesertVillages, "yucca_desert_villages");
    public static final ConfigValueCondition WOODEN_BOOKSHELVES_IN_VILLAGES = WoodworksRecipeProvider.config((ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenBookshelvesInVillages, (String)"wooden_bookshelves_in_villages");
    public static final ConfigValueCondition WOODEN_LADDERS_IN_VILLAGES = WoodworksRecipeProvider.config((ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenLaddersInVillages, (String)"wooden_ladders_in_villages");
    public static final ConfigValueCondition WOODEN_CHESTS_IN_VILLAGES = WoodworksRecipeProvider.config((ForgeConfigSpec.ConfigValue)WoodworksConfig.COMMON.woodenChestsInVillages, (String)"wooden_chests_in_villages");

    public static void bootstrap(BootstapContext<StructureRepaletterEntry> context) {
        HolderGetter structures = context.m_255420_(Registries.f_256944_);
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_buttons", Blocks.f_50254_, (Block)AtmosphericBlocks.YUCCA_BUTTON.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_doors", Blocks.f_50486_, (Block)AtmosphericBlocks.YUCCA_DOOR.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_fences", Blocks.f_50481_, (Block)AtmosphericBlocks.YUCCA_FENCE.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_fence_gates", Blocks.f_50476_, (Block)AtmosphericBlocks.YUCCA_FENCE_GATE.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, "yucca_trapdoors", Blocks.f_50219_, (Block)AtmosphericBlocks.YUCCA_TRAPDOOR.get());
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, AtmosphericStructureRepaletters.yuccaDesertVillageCondition((ICondition)WoodworksRecipeProvider.WOODEN_LADDERS, (ICondition)WOODEN_LADDERS_IN_VILLAGES), "yucca_ladders", Blocks.f_50155_, (Block)AtmosphericBlocks.YUCCA_LADDER.get(), 200);
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, AtmosphericStructureRepaletters.yuccaDesertVillageCondition((ICondition)WoodworksRecipeProvider.WOODEN_CHESTS, (ICondition)WOODEN_CHESTS_IN_VILLAGES), "yucca_chests", Blocks.f_50087_, (Block)AtmosphericBlocks.YUCCA_CHEST.get(), 200);
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, (HolderGetter<Structure>)structures, AtmosphericStructureRepaletters.yuccaDesertVillageCondition((ICondition)WoodworksRecipeProvider.WOODEN_BOOKSHELVES, (ICondition)WOODEN_BOOKSHELVES_IN_VILLAGES), "yucca_bookshelves", Blocks.f_50078_, (Block)AtmosphericBlocks.YUCCA_BOOKSHELF.get(), 200);
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_logs", Blocks.f_50004_, (Block)AtmosphericBlocks.GRIMWOOD_LOG.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_fences", Blocks.f_50483_, (Block)AtmosphericBlocks.GRIMWOOD_FENCE.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, "grimwood_planks", Blocks.f_50745_, (Block)AtmosphericBlocks.GRIMWOOD_PLANKS.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, AtmosphericStructureRepaletters.grimwoodAncientCityCondition((ICondition)WoodworksRecipeProvider.WOODEN_LADDERS, (ICondition)WOODEN_LADDERS_IN_VILLAGES), "grimwood_ladders", Blocks.f_50155_, (Block)AtmosphericBlocks.GRIMWOOD_LADDER.get());
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, (HolderGetter<Structure>)structures, AtmosphericStructureRepaletters.grimwoodAncientCityCondition((ICondition)WoodworksRecipeProvider.WOODEN_CHESTS, (ICondition)WOODEN_CHESTS_IN_VILLAGES), "grimwood_chests", Blocks.f_50087_, (Block)AtmosphericBlocks.GRIMWOOD_CHEST.get());
    }

    private static void yuccaDesertVillage(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, Block replacesBlock, Block replacesWith, int priority) {
        AtmosphericStructureRepaletters.basicRepaletter(context, structures, condition, name + "_in_desert_villages", replacesBlock, replacesWith, priority, BuiltinStructures.f_209865_);
    }

    private static void yuccaDesertVillage(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, String name, Block replacesBlock, Block replacesWith) {
        AtmosphericStructureRepaletters.yuccaDesertVillage(context, structures, (ICondition)YUCCA_DESERT_VILLAGES, name, replacesBlock, replacesWith, 100);
    }

    private static void grimwoodAncientCity(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, Block replacesBlock, Block replacesWith) {
        AtmosphericStructureRepaletters.basicRepaletter(context, structures, condition, name + "_in_ancient_cities", replacesBlock, replacesWith, BuiltinStructures.f_226492_);
    }

    private static void grimwoodAncientCity(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, String name, Block replacesBlock, Block replacesWith) {
        AtmosphericStructureRepaletters.grimwoodAncientCity(context, structures, (ICondition)GRIMWOOD_ANCIENT_CITIES, name, replacesBlock, replacesWith);
    }

    private static void laurelScrublandVillage(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, Block replacesBlock, Block replacesWith) {
        AtmosphericStructureRepaletters.basicRepaletter(context, structures, condition, name + "_in_scrubland_villages", replacesBlock, replacesWith, BuiltinStructures.f_209865_);
    }

    private static void scrublandVillageChests(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name) {
        AtmosphericStructureRepaletters.repaletter(context, structures, condition, name + "_in_scrubland_villages", (StructureRepaletter)new WeightedStructureRepaletter(Tags.Blocks.CHESTS_WOODEN, WeightedRandomList.m_146330_((WeightedEntry[])new WeightedEntry.Wrapper[]{WeightedEntry.m_146290_((Object)((Block)AtmosphericBlocks.LAUREL_CHEST.get()), (int)1), WeightedEntry.m_146290_((Object)((Block)AtmosphericBlocks.MORADO_CHEST.get()), (int)1)})), 100, BuiltinStructures.f_209865_);
    }

    @SafeVarargs
    private static void basicRepaletter(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, Block replacesBlock, Block replacesWith, ResourceKey<Structure> ... selector) {
        AtmosphericStructureRepaletters.basicRepaletter(context, structures, condition, name, replacesBlock, replacesWith, 100, selector);
    }

    @SafeVarargs
    private static void basicRepaletter(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, Block replacesBlock, Block replacesWith, int priority, ResourceKey<Structure> ... selector) {
        AtmosphericStructureRepaletters.repaletter(context, structures, condition, name, (StructureRepaletter)new SimpleStructureRepaletter(replacesBlock, replacesWith), priority, selector);
    }

    @SafeVarargs
    private static void repaletter(BootstapContext<StructureRepaletterEntry> context, HolderGetter<Structure> structures, ICondition condition, String name, StructureRepaletter repaletter, int priority, ResourceKey<Structure> ... selector) {
        context.m_255272_(AtmosphericStructureRepaletters.repaletterKey(name), (Object)new StructureRepaletterEntry((HolderSet)BlueprintHolderSets.conditional((HolderSet)HolderSet.m_205800_(Stream.of(selector).map(arg_0 -> structures.m_255043_(arg_0)).collect(Collectors.toList())), (ICondition[])new ICondition[]{condition}), Optional.empty(), false, priority, repaletter));
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key, boolean inverted) {
        return new ConfigValueCondition(new ResourceLocation("atmospheric", "config"), value, key, (Map)Maps.newHashMap(), inverted);
    }

    public static ConfigValueCondition config(ForgeConfigSpec.ConfigValue<?> value, String key) {
        return AtmosphericStructureRepaletters.config(value, key, false);
    }

    private static ICondition yuccaDesertVillageCondition(ICondition condition1, ICondition condition2) {
        return new BlueprintAndCondition(new ICondition[]{YUCCA_DESERT_VILLAGES, WoodworksRecipeProvider.WOODWORKS_LOADED, condition1, condition2});
    }

    private static ICondition grimwoodAncientCityCondition(ICondition condition1, ICondition condition2) {
        return new BlueprintAndCondition(new ICondition[]{GRIMWOOD_ANCIENT_CITIES, WoodworksRecipeProvider.WOODWORKS_LOADED, condition1, condition2});
    }

    private static ICondition laurelScrublandVillageCondition(ICondition condition1, ICondition condition2) {
        return new BlueprintAndCondition(new ICondition[]{WoodworksRecipeProvider.WOODWORKS_LOADED, condition1, condition2});
    }

    private static ResourceKey<StructureRepaletterEntry> repaletterKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)BlueprintDataPackRegistries.STRUCTURE_REPALETTERS, (ResourceLocation)new ResourceLocation("atmospheric", name));
    }
}

