/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.data.server.AtmosphericLootTableProvider;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SuspiciousAridSandFeature
extends Feature<NoneFeatureConfiguration> {
    public SuspiciousAridSandFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource rand = context.m_225041_();
        BlockPos pos = context.m_159777_().m_7495_();
        int i = SuspiciousAridSandFeature.placeSandLayer(level, pos, rand, 1, 0, 0, (IntProvider)UniformInt.m_146622_((int)1, (int)2), (IntProvider)ConstantInt.f_146476_) + SuspiciousAridSandFeature.placeSandLayer(level, pos, rand, 2, -2, -1, (IntProvider)UniformInt.m_146622_((int)2, (int)3), (IntProvider)UniformInt.m_146622_((int)0, (int)1)) + SuspiciousAridSandFeature.placeSandLayer(level, pos, rand, 2, -3, -2, (IntProvider)UniformInt.m_146622_((int)3, (int)4), (IntProvider)UniformInt.m_146622_((int)1, (int)3));
        if (i > 0) {
            for (BlockPos newPos : BlockPos.m_121990_((BlockPos)pos.m_7918_(-2, -4, -2), (BlockPos)pos.m_7918_(2, -1, 2)).map(BlockPos::m_7949_).toList()) {
                Optional<Block> block = SuspiciousAridSandFeature.convertToSandstone(level.m_8055_(newPos));
                if (!rand.m_188499_() || !block.isPresent()) continue;
                level.m_7731_(newPos, block.get().m_49966_(), 2);
            }
            return true;
        }
        return false;
    }

    public static int placeSandLayer(WorldGenLevel level, BlockPos pos, RandomSource rand, int radius, int yMin, int yMax, IntProvider tries, IntProvider rareCount) {
        int i = 0;
        ArrayList layer1 = BlockPos.m_121990_((BlockPos)pos.m_7918_(-radius, yMin, -radius), (BlockPos)pos.m_7918_(radius, yMax, radius)).filter(blockPos -> SuspiciousAridSandFeature.convertToSuspicious(level.m_8055_(blockPos)).isPresent()).map(BlockPos::m_7949_).collect(Collectors.toCollection(Lists::newArrayList));
        Collections.shuffle(layer1);
        if (!layer1.isEmpty()) {
            int attempts = tries.m_214085_(rand);
            int rare = rareCount.m_214085_(rand);
            for (int j = 0; j < attempts; ++j) {
                ResourceLocation lootTable;
                BlockPos newPos = (BlockPos)layer1.get(j);
                if (rare > 0) {
                    lootTable = AtmosphericLootTableProvider.AtmosphericArchaeologyLoot.ARID_GARDEN_RARE;
                    --rare;
                } else {
                    lootTable = AtmosphericLootTableProvider.AtmosphericArchaeologyLoot.ARID_GARDEN_COMMON;
                }
                level.m_7731_(newPos, SuspiciousAridSandFeature.convertToSuspicious(level.m_8055_(newPos)).get().m_49966_(), 2);
                level.m_141902_(newPos, BlockEntityType.f_271323_).ifPresent(entity -> entity.m_277049_(lootTable, newPos.m_121878_()));
                ++i;
            }
        }
        return i;
    }

    public static Optional<Block> convertToSuspicious(BlockState state) {
        if (state.m_60713_((Block)AtmosphericBlocks.ARID_SAND.get()) || state.m_60713_((Block)AtmosphericBlocks.ARID_SANDSTONE.get())) {
            return Optional.of((Block)AtmosphericBlocks.SUSPICIOUS_ARID_SAND.get());
        }
        if (state.m_60713_((Block)AtmosphericBlocks.RED_ARID_SAND.get()) || state.m_60713_((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get())) {
            return Optional.of((Block)AtmosphericBlocks.SUSPICIOUS_RED_ARID_SAND.get());
        }
        return Optional.empty();
    }

    public static Optional<Block> convertToSandstone(BlockState state) {
        if (state.m_60713_((Block)AtmosphericBlocks.ARID_SAND.get())) {
            return Optional.of((Block)AtmosphericBlocks.ARID_SANDSTONE.get());
        }
        if (state.m_60713_((Block)AtmosphericBlocks.RED_ARID_SAND.get())) {
            return Optional.of((Block)AtmosphericBlocks.RED_ARID_SANDSTONE.get());
        }
        return Optional.empty();
    }
}

