/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class RainforestTreeFeature
extends BlueprintTreeFeature {
    public RainforestTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        boolean tall;
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        boolean morado = config.f_68185_.m_213972_(random, origin).m_60713_((Block)AtmosphericBlocks.MORADO_LOG.get());
        int branches = 2 + random.m_188503_(3) - (!morado ? 0 : 1);
        int trunkHeight = config.f_68190_.m_226153_(random);
        boolean bl = tall = !morado && random.m_188503_(100) == 0;
        if (tall) {
            trunkHeight += 6 + random.m_188503_(4) + random.m_188503_(3);
        }
        boolean canopy = false;
        for (int y = 0; y < trunkHeight; ++y) {
            BlockPos pos = origin.m_6630_(y);
            this.addLog(pos);
            if (random.m_188503_(6) != 0 || y <= (!tall ? 3 : 8) || canopy) continue;
            this.createLeafLayer(pos, 1 + random.m_188503_(2));
            canopy = true;
        }
        ArrayList directions = Lists.newArrayList();
        while (directions.size() < branches) {
            Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
            if (directions.contains(randomDirection)) continue;
            directions.add(randomDirection);
        }
        for (Direction direction : directions) {
            int turns = 1 + random.m_188503_(3);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.m_122190_((Vec3i)origin.m_6630_(trunkHeight - 1));
            for (int k4 = 0; k4 < turns; ++k4) {
                int branchLength;
                int n = tall ? 2 + random.m_188503_(2) : (branchLength = !morado ? 1 + random.m_188503_(2) + random.m_188503_(2) : 1 + random.m_188503_(2));
                int branchHeight = tall ? 2 + random.m_188503_(2) + random.m_188503_(2) : (!morado ? 1 + random.m_188503_(3) + random.m_188503_(2) : 1 + random.m_188503_(2));
                this.createHorizontalLog(branchLength, pos, direction, random, config);
                this.createVerticalLog(branchHeight, pos, random);
            }
            int leafSize = 2 + random.m_188503_(2);
            this.createLeafLayer((BlockPos)pos, leafSize);
            this.createLeafLayer(pos.m_7494_(), Math.max(leafSize - 1, 1));
        }
    }

    public void createLeafLayer(BlockPos pos, int leafSize) {
        for (int i = -leafSize; i <= leafSize; ++i) {
            for (int k = -leafSize; k <= leafSize; ++k) {
                if (Math.abs(i) == leafSize && Math.abs(k) == leafSize) continue;
                this.addFoliage(pos.m_7918_(i, 0, k));
            }
        }
    }

    private void createHorizontalLog(int branchLength, BlockPos.MutableBlockPos pos, Direction direction, RandomSource random, TreeConfiguration config) {
        for (int i = 0; i < branchLength; ++i) {
            pos.m_122159_((Vec3i)pos, direction);
            this.addSpecialLog((BlockPos)pos, (BlockState)config.f_68185_.m_213972_(random, (BlockPos)pos).m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)direction.m_122434_()));
        }
    }

    private void createVerticalLog(int branchHeight, BlockPos.MutableBlockPos pos, RandomSource random) {
        boolean canopy = false;
        for (int i = 0; i < branchHeight; ++i) {
            pos.m_122190_((Vec3i)pos.m_7494_());
            this.addLog((BlockPos)pos);
            if (random.m_188503_(6) != 0 || canopy) continue;
            this.createLeafLayer((BlockPos)pos, 1 + random.m_188503_(2));
            canopy = true;
        }
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.ROSEWOOD_SAPLING.get()).m_49966_();
    }

    public boolean canSurvive(WorldGenLevel level, BlockPos pos) {
        return super.canSurvive(level, pos) || level.m_8055_(pos.m_7495_()).m_60713_(Blocks.f_49994_);
    }
}

