/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import com.teamabnormals.blueprint.common.levelgen.feature.BlueprintTreeFeature;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;

public class AspenTreeFeature
extends BlueprintTreeFeature {
    public AspenTreeFeature(Codec<TreeConfiguration> config) {
        super(config);
    }

    public void doPlace(FeaturePlaceContext<TreeConfiguration> context) {
        TreeConfiguration config = (TreeConfiguration)context.m_159778_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int trunkHeight = config.f_68190_.m_226153_(random);
        int leafHeight = trunkHeight - 7 - random.m_188503_(3) - random.m_188503_(3);
        int branchHeight = leafHeight - 2 - random.m_188503_(3);
        int bonusBranchHeight = branchHeight - 2 - random.m_188503_(3);
        for (int y = 0; y < trunkHeight; ++y) {
            BlockPos pos = origin.m_6630_(y);
            this.addLog(pos);
            if (y >= leafHeight) {
                for (Direction direction : Direction.Plane.HORIZONTAL) {
                    this.addFoliage(pos.m_121945_(direction));
                    BlockPos offsetPos = pos.m_121945_(direction).m_121945_(direction.m_122427_());
                    if (y <= leafHeight || y >= trunkHeight - 1 || random.m_188503_(4) == 0 && this.foliagePositions.contains(offsetPos.m_7495_())) continue;
                    this.addFoliage(offsetPos);
                }
                if (y <= leafHeight + 1 || y >= trunkHeight - 2) continue;
                for (int i = -2; i <= 2; ++i) {
                    for (int k = -2; k <= 2; ++k) {
                        if (Math.abs(i) == 2 && Math.abs(k) == 2 || !random.m_188499_()) continue;
                        this.addFoliage(pos.m_7918_(i, 0, k));
                    }
                }
                continue;
            }
            if ((y != branchHeight || branchHeight <= 3 || random.m_188503_(5) == 0) && (y != bonusBranchHeight || bonusBranchHeight <= 2 || random.m_188503_(3) == 0)) continue;
            int branchSize = 1 + random.m_188503_(2);
            if (random.m_188499_()) {
                branchSize += 1 + random.m_188503_(2);
            }
            ArrayList usedDirections = Lists.newArrayList();
            while (usedDirections.size() < branchSize) {
                Direction randomDirection = Direction.Plane.HORIZONTAL.m_235690_(random);
                if (usedDirections.contains(randomDirection)) continue;
                usedDirections.add(randomDirection);
            }
            for (Direction direction : usedDirections) {
                this.addFoliage(pos.m_121945_(direction));
            }
        }
        this.addFoliage(origin.m_6630_(trunkHeight));
    }

    public BlockState getSapling() {
        return ((Block)AtmosphericBlocks.ASPEN_SAPLING.get()).m_49966_();
    }
}

