/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.block;

import com.teamabnormals.atmospheric.core.other.AtmosphericCriteriaTriggers;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericEntityTypeTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericItems;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public interface YuccaPlant {
    public float getKnockbackForce();

    public ResourceKey<DamageType> getDamageTypeKey();

    default public void onYuccaCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        VoxelShape collision = state.m_60734_().m_5940_(state, (BlockGetter)level, pos, CollisionContext.m_82749_()).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        boolean colliding = entity.m_20191_().m_82381_(collision.m_83215_().m_82400_(1.0E-7));
        if (colliding && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (!(entity.m_6095_().m_204039_(AtmosphericEntityTypeTags.YUCCA_IMMUNE) || level.f_46443_ || entity.f_19790_ == entity.m_20185_() && entity.f_19792_ == entity.m_20189_())) {
                double d0 = Math.abs(entity.m_20185_() - entity.f_19790_);
                double d1 = Math.abs(entity.m_20189_() - entity.f_19792_);
                if (d0 >= (double)0.003f || d1 >= (double)0.003f) {
                    if (!entity.m_6047_()) {
                        living.m_147240_((double)this.getKnockbackForce(), (double)(-Mth.m_14031_((float)((float)((double)entity.m_146908_() * Math.PI / 180.0)))), (double)Mth.m_14089_((float)((float)((double)entity.m_146908_() * Math.PI / 180.0))));
                    }
                    DamageSource source = level.m_269111_().m_269079_(this.getDamageTypeKey());
                    if (living.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)AtmosphericItems.BARREL_CACTUS.get())) {
                        entity.m_6469_(source, 0.01f);
                    } else {
                        entity.m_6469_(source, 1.0f);
                    }
                    if (entity instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)entity;
                        if (!entity.m_20193_().m_5776_() && !serverPlayer.m_7500_()) {
                            AtmosphericCriteriaTriggers.YUCCA_PRICK.trigger(serverPlayer);
                        }
                    }
                }
            }
        }
    }

    default public BlockPathTypes getYuccaPathType(@Nullable Mob entity) {
        return entity != null && entity.m_6095_().m_204039_(AtmosphericEntityTypeTags.YUCCA_IMMUNE) ? null : BlockPathTypes.DAMAGE_OTHER;
    }
}

