/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.lib;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mekanism.common.Mekanism;
import mekanism.common.lib.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import org.jetbrains.annotations.Nullable;

public class ColorAtlas {
    private static final int ATLAS_SIZE = 16;
    private final String name;
    private final List<ColorRegistryObject> colors = new ArrayList<ColorRegistryObject>();

    public ColorAtlas(String name) {
        this.name = name;
    }

    public ColorRegistryObject register() {
        return this.register(-1);
    }

    public ColorRegistryObject register(int defaultARGB) {
        ColorRegistryObject obj = new ColorRegistryObject(defaultARGB);
        this.colors.add(obj);
        return obj;
    }

    public void parse(ResourceLocation rl) {
        List<Color> parsed = ColorAtlas.load(rl, this.colors.size());
        if (parsed.size() < this.colors.size()) {
            Mekanism.logger.error("Failed to parse '{}' color atlas.", (Object)this.name);
            return;
        }
        for (int i = 0; i < parsed.size(); ++i) {
            this.colors.get(i).setColor(parsed.get(i));
        }
    }

    public static List<Color> load(ResourceLocation rl, int count) {
        ArrayList<Color> ret = new ArrayList<Color>();
        try {
            ColorAtlas.loadColorAtlas(rl, count, ret);
        }
        catch (Exception e) {
            Mekanism.logger.error("Failed to load color atlas: {}", (Object)rl, (Object)e);
        }
        return ret;
    }

    private static void loadColorAtlas(ResourceLocation rl, int count, List<Color> ret) throws IOException {
        try (InputStream input = Minecraft.m_91087_().m_91098_().m_215595_(rl);
             NativeImage image = NativeImage.m_85058_((InputStream)input);){
            for (int i = 0; i < count; ++i) {
                int argb = Color.argbToFromABGR(image.m_84985_(i % 16, i / 16));
                if (FastColor.ARGB32.m_13655_((int)argb) == 0) {
                    ret.add(null);
                    Mekanism.logger.warn("Unable to retrieve color marker: '{}' for atlas: '{}'. This is likely due to an out of date resource pack.", (Object)count, (Object)rl);
                    continue;
                }
                ret.add(Color.argb(argb));
            }
        }
    }

    public static class ColorRegistryObject
    implements Supplier<Color> {
        private final int defaultARGB;
        private Color color;
        private int argb;

        private ColorRegistryObject(int defaultARGB) {
            this.defaultARGB = defaultARGB;
            this.setColor(null);
        }

        private void setColor(@Nullable Color color) {
            if (color == null) {
                color = Color.argb(this.defaultARGB);
            }
            this.color = color;
            this.argb = color.argb();
        }

        @Override
        public Color get() {
            return this.color;
        }

        public int argb() {
            return this.argb;
        }
    }
}

