/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.recipecache;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.recipeessentials.RecipeEssentials;
import com.recipeessentials.recipecache.CachedRecipeList;
import com.recipeessentials.recipecache.IRecipeCompat;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.crafting.conditions.ICondition;

public class RecipeManager
extends net.minecraft.world.item.crafting.RecipeManager {
    public static IRecipeCompat compat = new IRecipeCompat(){

        @Override
        public <C extends Container, T extends Recipe<C>> Optional getRecipe(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, CachedRecipeList recipes) {
            return Optional.empty();
        }
    };
    private Long2ObjectOpenHashMap<CachedRecipeList> recipeCache = new Long2ObjectOpenHashMap();
    private Object2IntOpenHashMap<Recipe> recipeIndexes = new Object2IntOpenHashMap();

    public RecipeManager(ICondition.IContext context) {
        super(context);
    }

    public RecipeManager() {
        super(ICondition.IContext.EMPTY);
    }

    public <C extends Container, T extends Recipe<C>> Optional m_44015_(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn) {
        long hash = this.calcHash(inventoryIn, recipeTypeIn);
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(hash);
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount * 30) != 0) {
            ++recipes.useCount;
            Optional compatRecipe = compat.getRecipe(recipeTypeIn, inventoryIn, worldIn, recipes);
            if (compatRecipe.isPresent()) {
                return compatRecipe;
            }
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                Recipe recipe = recipes.recipes.get(i);
                if (!recipe.m_5818_(inventoryIn, worldIn)) continue;
                return Optional.of(recipe);
            }
        } else {
            this.m_44056_(recipeTypeIn, inventoryIn, worldIn);
        }
        Optional result = super.m_44015_(recipeTypeIn, inventoryIn, worldIn);
        return result;
    }

    public <C extends Container, T extends Recipe<C>> Optional<Pair<ResourceLocation, T>> m_220248_(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn, ResourceLocation resourceLocation) {
        long hash = this.calcHash(inventoryIn, recipeTypeIn);
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(hash);
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount * 30) != 0) {
            ++recipes.useCount;
            Optional compatRecipe = compat.getRecipe(recipeTypeIn, inventoryIn, worldIn, recipes);
            if (compatRecipe.isPresent()) {
                return Optional.of(new Pair((Object)((Recipe)compatRecipe.get()).m_6423_(), (Object)((Recipe)compatRecipe.get())));
            }
            int recipesSize = recipes.recipes.size();
            for (int i = 0; i < recipesSize; ++i) {
                Recipe recipe = recipes.recipes.get(i);
                if (!recipe.m_5818_(inventoryIn, worldIn)) continue;
                return Optional.of(new Pair((Object)recipe.m_6423_(), (Object)recipe));
            }
        } else {
            this.m_44056_(recipeTypeIn, inventoryIn, worldIn);
        }
        Optional result = super.m_220248_(recipeTypeIn, inventoryIn, worldIn, resourceLocation);
        if (result.isPresent() && hash != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            }
            ++recipeList.useCount;
            if (!recipeList.recipes.contains(((Pair)result.get()).getSecond())) {
                recipeList.recipes.add((Recipe)((Pair)result.get()).getSecond());
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public <C extends Container, T extends Recipe<C>> List<T> m_44056_(RecipeType<T> recipeTypeIn, C inventoryIn, Level worldIn) {
        long hash;
        List result;
        CachedRecipeList recipes = (CachedRecipeList)this.recipeCache.get(this.calcHash(inventoryIn, recipeTypeIn));
        if (recipes != null && recipes.useCount > 10 && RecipeEssentials.rand.nextInt(recipes.useCount * 30) != 0) {
            ++recipes.useCount;
            ArrayList<Recipe> matches = new ArrayList<Recipe>();
            for (Recipe recipe2 : recipes.recipes) {
                if (!recipe2.m_5818_(inventoryIn, worldIn)) continue;
                matches.add(recipe2);
            }
            if (!matches.isEmpty()) {
                matches.sort(Comparator.comparing(recipe -> recipe.m_8043_(worldIn.m_9598_()).m_41778_()));
                return matches;
            }
        }
        if ((result = super.m_44056_(recipeTypeIn, inventoryIn, worldIn)) != null && !result.isEmpty() && (hash = this.calcHash(inventoryIn, recipeTypeIn)) != -1L) {
            CachedRecipeList recipeList = (CachedRecipeList)this.recipeCache.get(hash);
            if (recipeList == null) {
                recipeList = new CachedRecipeList(recipeTypeIn, inventoryIn);
                this.recipeCache.put(hash, (Object)recipeList);
            } else {
                ArrayList<Recipe> matches = new ArrayList<Recipe>();
                for (Recipe recipe3 : recipeList.recipes) {
                    if (!recipe3.m_5818_(inventoryIn, worldIn)) continue;
                    matches.add(recipe3);
                }
                matches.sort(Comparator.comparing(recipe -> recipe.m_8043_(worldIn.m_9598_()).m_41778_()));
                result.sort(Comparator.comparing(recipe -> recipe.m_8043_(worldIn.m_9598_()).m_41778_()));
                if (!result.equals(matches)) {
                    recipeList.report(recipeTypeIn, inventoryIn, result);
                }
            }
            ++recipeList.useCount;
            boolean added = false;
            for (Recipe recipe3 : result) {
                if (recipeList.recipes.contains(recipe3)) continue;
                added = true;
                recipeList.recipes.add(recipe3);
            }
            if (added) {
                recipeList.recipes.sort(Comparator.comparingInt(arg_0 -> this.recipeIndexes.getInt(arg_0)));
            }
        }
        return result;
    }

    public void m_5787_(Map<ResourceLocation, JsonElement> dataMap, ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        super.m_5787_(dataMap, resourceManager, profilerFiller);
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (Map.Entry recipe : this.f_199900_.entrySet()) {
            if (!((Recipe)recipe.getValue()).m_6423_().equals(recipe.getKey())) {
                RecipeEssentials.LOGGER.warn("Recipe without matching ID:" + ((Recipe)recipe.getValue()).m_6423_());
            }
            this.recipeIndexes.put((Object)((Recipe)recipe.getValue()), index++);
        }
    }

    public void m_44024_(Iterable<Recipe<?>> recipeIterator) {
        super.m_44024_(recipeIterator);
        this.recipeCache = new Long2ObjectOpenHashMap();
        int index = 0;
        for (Recipe recipe : this.f_199900_.values()) {
            this.recipeIndexes.put((Object)recipe, index++);
        }
    }

    private long calcHash(Container inventory, RecipeType type) {
        if (inventory == null) {
            return type.hashCode();
        }
        long hash = type.hashCode();
        int size = inventory.m_6643_();
        if (inventory.hashCode() != System.identityHashCode(inventory)) {
            hash = 31L * hash + (long)inventory.hashCode();
        }
        for (int i = 0; i < size; ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (stack == null || stack.m_41619_()) continue;
            hash = 31L * hash + (long)i;
            hash = 31L * hash + (long)stack.m_41720_().hashCode();
        }
        return hash;
    }
}

