/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.patterns;

import com.mojang.serialization.Codec;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.util.MiscHelper;

public abstract class BasePattern {
    private final ResourceLocation identifier;
    protected ResourceLocation themeId;
    private String name;

    public BasePattern(String id) {
        this(new ResourceLocation("tardis_refined", id));
    }

    public BasePattern(ResourceLocation identifier) {
        this(identifier, TardisRefined.GSON.toJson((Object)Component.m_237113_((String)MiscHelper.getCleanName(identifier.m_135815_())).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.YELLOW))));
    }

    public BasePattern(ResourceLocation identifier, String name) {
        this.identifier = identifier;
        this.name = name;
    }

    public abstract Codec<? extends BasePattern> getCodec();

    public String name() {
        return this.name;
    }

    public BasePattern setName(String name) {
        this.name = name;
        return this;
    }

    public ResourceLocation id() {
        return this.identifier;
    }

    public ResourceLocation getThemeId() {
        return this.themeId;
    }

    public BasePattern setThemeId(ResourceLocation themeId) {
        this.themeId = themeId;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasePattern basePattern = (BasePattern)o;
        return Objects.equals(this.identifier, basePattern.identifier) && this.themeId == basePattern.themeId;
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.themeId);
    }
}

