/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.compat.portals;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Quaternionf;
import qouteall.imm_ptl.core.api.PortalAPI;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalManipulation;
import qouteall.q_misc_util.MiscHelper;
import qouteall.q_misc_util.api.DimensionAPI;
import qouteall.q_misc_util.my_util.DQuaternion;
import whocraft.tardis_refined.api.event.EventResult;
import whocraft.tardis_refined.api.event.TardisCommonEvents;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.dimension.DimensionHandler;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.AestheticHandler;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.compat.ModCompatChecker;
import whocraft.tardis_refined.compat.portals.BotiPortalEntity;
import whocraft.tardis_refined.compat.portals.PortalEntry;
import whocraft.tardis_refined.compat.portals.PortalOffets;
import whocraft.tardis_refined.registry.RegistrySupplier;
import whocraft.tardis_refined.registry.TRDimensionTypes;
import whocraft.tardis_refined.registry.TREntityRegistry;

public class ImmersivePortals {
    private static final Map<UUID, PortalEntry> EXISTING_PORTALS = new HashMap<UUID, PortalEntry>();
    private static final Map<ResourceLocation, PortalOffets> THEME_OFFSETS = new HashMap<ResourceLocation, PortalOffets>();
    public static RegistrySupplier<EntityType<BotiPortalEntity>> BOTI_PORTAL = null;
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/ImmersivePortals");

    public static void clearPortalCache() {
        EXISTING_PORTALS.clear();
    }

    public static boolean doPortalsExistForTardis(UUID uuid) {
        return EXISTING_PORTALS.containsKey(uuid);
    }

    public static PortalEntry getPortalsForTardis(UUID uuid) {
        return EXISTING_PORTALS.get(uuid);
    }

    public static ServerLevel createDimension(Level level, ResourceKey<Level> id) {
        ServerLevel world;
        MinecraftServer server = MiscHelper.getServer();
        if (server == null) {
            return null;
        }
        ServerLevel serverLevel = world = server.m_129784_().contains(id) ? server.m_129880_(id) : null;
        if (world != null) {
            return world;
        }
        BiFunction<MinecraftServer, ResourceKey, LevelStem> dimensionFactory = DimensionHandler::formLevelStem;
        ResourceKey dimensionKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)id.m_135782_());
        DimensionAPI.addDimensionDynamically((ResourceLocation)id.m_135782_(), (LevelStem)dimensionFactory.apply(server, dimensionKey));
        world = server.m_129880_(id);
        DimensionHandler.addDimension((ResourceKey<Level>)world.m_46472_());
        return world;
    }

    public static void init() {
        if (!ModCompatChecker.immersivePortals()) {
            return;
        }
        LOGGER.info("Immersive Portals Detected - Setting up Compatibility");
        BOTI_PORTAL = TREntityRegistry.ENTITY_TYPES.register("boti_portal", () -> TREntityRegistry.registerStatic(BotiPortalEntity::new, MobCategory.MISC, 1.0f, 1.0f, 96, 20, "boti_portal"));
        ImmersivePortals.setupEvents();
        ImmersivePortals.setupPortalsForShellThemes();
    }

    private static void setupEvents() {
        TardisCommonEvents.DOOR_OPENED_EVENT.register(ImmersivePortals::createPortals);
        TardisCommonEvents.DOOR_CLOSED_EVENT.register(ImmersivePortals::destroyPortals);
        TardisCommonEvents.SHELL_CHANGE_EVENT.register((operator, theme, isSetupTardis) -> {
            TardisInternalDoor internalDoor = operator.getInternalDoor();
            ImmersivePortals.destroyPortals(operator);
            if (internalDoor != null && internalDoor.isOpen()) {
                ImmersivePortals.createPortals(operator);
            }
        });
        TardisCommonEvents.DESKTOP_CHANGE_EVENT.register(ImmersivePortals::destroyPortals);
        TardisCommonEvents.TAKE_OFF.register((tardisLevelOperator, level, pos) -> {
            ImmersivePortals.destroyPortals(tardisLevelOperator);
            return EventResult.pass();
        });
    }

    private static void setupPortalsForShellThemes() {
        THEME_OFFSETS.clear();
        PortalOffets ttCapsule = new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.499, 0.3125, 0.0), new Vec3(0.0, 0.3125, 0.499), new Vec3(-0.499, 0.3125, 0.0), new Vec3(0.0, 0.3125, -0.499)), new PortalOffets.OffsetData(new Vec3(-1.375, 0.125, 0.0), new Vec3(0.0, 0.125, -1.375), new Vec3(1.375, 0.125, 0.0), new Vec3(0.0, 0.125, 1.375)), new Vec2(1.0f, 2.0f));
        ImmersivePortals.registerThemePortal(ShellTheme.FACTORY.get(), ttCapsule);
        ImmersivePortals.registerThemePortal(ShellTheme.HALF_BAKED.get(), ttCapsule);
        ImmersivePortals.registerThemePortal(ShellTheme.POLICE_BOX.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.6, 0.125, 0.0), new Vec3(0.0, 0.125, 0.6), new Vec3(-0.6, 0.125, 0.0), new Vec3(0.0, 0.125, -0.6)), new PortalOffets.OffsetData(new Vec3(-1.425, 0.0625, 0.0), new Vec3(0.0, 0.0625, -1.425), new Vec3(1.425, 0.0625, 0.0), new Vec3(0.0, 0.0625, 1.7)), new Vec2(1.0f, 2.0f)));
        ImmersivePortals.registerThemePortal(ShellTheme.PHONE_BOOTH.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.5, 0.125, 0.0), new Vec3(0.0, 0.125, 0.5), new Vec3(-0.5, 0.125, 0.0), new Vec3(0.0, 0.125, -0.5)), new PortalOffets.OffsetData(new Vec3(-1.435, 0.0, 0.0), new Vec3(0.0, 0.0, -1.435), new Vec3(1.435, 0.0, 0.0), new Vec3(0.0, 0.0, 1.435)), new Vec2(1.0f, 2.0f)));
        ImmersivePortals.registerThemePortal(ShellTheme.MYSTIC.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.5, 0.1875, 0.0), new Vec3(0.0, 0.1875, 0.5), new Vec3(-0.5, 0.1875, 0.0), new Vec3(0.0, 0.1875, -0.5)), new PortalOffets.OffsetData(new Vec3(-1.425, 0.0625, 0.0), new Vec3(0.0, 0.0625, -1.425), new Vec3(1.425, 0.0625, 0.0), new Vec3(0.0, 0.0625, 1.425)), new Vec2(1.0f, 2.0f)));
        ImmersivePortals.registerThemePortal(ShellTheme.VENDING.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.57, 0.0, 0.0), new Vec3(0.0, 0.0, 0.57), new Vec3(-0.57, 0.0, 0.0), new Vec3(0.0, 0.0, -0.57)), new PortalOffets.OffsetData(new Vec3(-1.455, 0.0, 0.0), new Vec3(0.0, 0.0, -1.455), new Vec3(1.455, 0.0, 0.0), new Vec3(0.0, 0.0, 1.455)), new Vec2(1.0f, 2.175f)));
        ImmersivePortals.registerThemePortal(ShellTheme.PRESENT.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.57, 0.0, 0.0), new Vec3(0.0, 0.0, 0.57), new Vec3(-0.57, 0.0, 0.0), new Vec3(0.0, 0.0, -0.57)), new PortalOffets.OffsetData(new Vec3(-1.455, 0.0, 0.0), new Vec3(0.0, 0.0, -1.455), new Vec3(1.455, 0.0, 0.0), new Vec3(0.0, 0.0, 1.455)), new Vec2(1.0f, 2.175f)));
        ImmersivePortals.registerThemePortal(ShellTheme.DRIFTER.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.61, 0.125, 0.0), new Vec3(0.0, 0.125, 0.61), new Vec3(-0.61, 0.125, 0.0), new Vec3(0.0, 0.125, -0.61)), new PortalOffets.OffsetData(new Vec3(-1.425, 0.0625, 0.0), new Vec3(0.0, 0.0625, -1.425), new Vec3(1.425, 0.0625, 0.0), new Vec3(0.0, 0.0625, 1.425)), new Vec2(1.0f, 2.0f)));
        ImmersivePortals.registerThemePortal(ShellTheme.HIEROGLYPH.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.5, 0.0, 0.0), new Vec3(0.0, 0.0, 0.5), new Vec3(-0.5, 0.0, 0.0), new Vec3(0.0, 0.0, -0.5)), new PortalOffets.OffsetData(new Vec3(-1.33, 0.0, 0.0), new Vec3(0.0, 0.0, -1.33), new Vec3(1.33, 0.0, 0.0), new Vec3(0.0, 0.0, 1.33)), new Vec2(1.0f, 2.25f)));
        ImmersivePortals.registerThemePortal(ShellTheme.GROENING.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.5, 0.0, 0.0), new Vec3(0.0, 0.0, 0.5), new Vec3(-0.5, 0.0, 0.0), new Vec3(0.0, 0.0, -0.5)), new PortalOffets.OffsetData(new Vec3(-1.33, 0.0, 0.0), new Vec3(0.0, 0.0, -1.33), new Vec3(1.33, 0.0, 0.0), new Vec3(0.0, 0.0, 1.33)), new Vec2(1.0f, 2.25f)));
        ImmersivePortals.registerThemePortal(ShellTheme.BIG_BEN.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.46, 0.0, 0.0), new Vec3(0.0, 0.0, 0.46), new Vec3(-0.46, 0.0, 0.0), new Vec3(0.0, 0.0, -0.46)), new PortalOffets.OffsetData(new Vec3(-1.3, 0.0, 0.0), new Vec3(0.0, 0.0, -1.3), new Vec3(1.3, 0.0, 0.0), new Vec3(0.0, 0.0, 1.3)), new Vec2(1.0f, 2.0f)));
        ImmersivePortals.registerThemePortal(ShellTheme.NUKA.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.65, 0.375, 0.0), new Vec3(0.0, 0.375, 0.65), new Vec3(-0.65, 0.375, 0.0), new Vec3(0.0, 0.375, -0.65)), new PortalOffets.OffsetData(new Vec3(-1.33, 0.0, 0.0), new Vec3(0.0, 0.0, -1.33), new Vec3(1.33, 0.0, 0.0), new Vec3(0.0, 0.0, 1.33)), new Vec2(1.0f, 2.0f)));
        ImmersivePortals.registerThemePortal(ShellTheme.PORTALOO.get(), new PortalOffets(new PortalOffets.OffsetData(new Vec3(0.51, 0.125, 0.0), new Vec3(0.0, 0.125, 0.51), new Vec3(-0.51, 0.125, 0.0), new Vec3(0.0, 0.125, -0.51)), new PortalOffets.OffsetData(new Vec3(-1.425, 0.0, 0.0), new Vec3(0.0, 0.0, -1.425), new Vec3(1.425, 0.0, 0.0), new Vec3(0.0, 0.0, 1.425)), new Vec2(1.0f, 2.0f)));
        ImmersivePortals.detectMissingSetup();
    }

    private static void detectMissingSetup() {
        for (ResourceLocation value : ShellTheme.SHELL_THEME_DEFERRED_REGISTRY.keySet()) {
            if (ImmersivePortals.isShellThemeSupported(value) || value.equals((Object)ShellTheme.getKey(ShellTheme.BRIEFCASE.get()))) continue;
            LOGGER.info("{} shell has not been setup for ImmersivePortals", (Object)value);
        }
    }

    public static void registerThemePortal(ShellTheme shellTheme, PortalOffets portalOffets) {
        THEME_OFFSETS.put(ShellTheme.getKey(shellTheme), portalOffets);
    }

    public static boolean isShellThemeSupported(ResourceLocation shellTheme) {
        return THEME_OFFSETS.containsKey(shellTheme);
    }

    public static boolean onDoorRemoved(Level level, Player player, BlockPos blockPos, BlockState blockState, BlockEntity blockEntity) {
        if (blockEntity instanceof TardisInternalDoor) {
            TardisInternalDoor door = (TardisInternalDoor)blockEntity;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (!door.isMainDoor()) {
                    return true;
                }
                if (serverLevel.m_220362_().equals(TRDimensionTypes.TARDIS)) {
                    TardisLevelOperator.get(serverLevel).ifPresent(ImmersivePortals::destroyPortals);
                }
            }
        }
        return true;
    }

    public static void createPortals(TardisLevelOperator operator) {
        if (operator.getPilotingManager().isInFlight()) {
            ImmersivePortals.destroyPortals(operator);
            return;
        }
        if (!Platform.isProduction()) {
            ImmersivePortals.setupPortalsForShellThemes();
        }
        ImmersivePortals.destroyPortals(operator);
        UUID dimId = UUID.fromString(operator.getLevel().m_46472_().m_135782_().m_135815_());
        AestheticHandler aestheticsHandler = operator.getAestheticHandler();
        TardisInteriorManager interiorManager = operator.getInteriorManager();
        ResourceLocation theme = aestheticsHandler.getShellTheme();
        TardisInternalDoor door = operator.getInternalDoor();
        TardisPilotingManager pilotingManager = operator.getPilotingManager();
        if (!ImmersivePortals.isShellThemeSupported(theme)) {
            ImmersivePortals.destroyPortals(operator);
            return;
        }
        if (interiorManager.isCave() || door != null && !door.isOpen() || !operator.isTardisReady() || EXISTING_PORTALS.get(dimId) != null || door == null) {
            return;
        }
        TardisNavLocation location = pilotingManager.getCurrentLocation();
        BlockPos entryPositionBPos = door.getTeleportPosition();
        Vec3 entryPosition = new Vec3((double)entryPositionBPos.m_123341_() + 0.5, (double)(entryPositionBPos.m_123342_() + 1), (double)entryPositionBPos.m_123343_() + 0.5);
        BlockPos exteriorEntryBPos = location.getPosition();
        Vec3 exteriorEntryPosition = new Vec3((double)exteriorEntryBPos.m_123341_() + 0.5, (double)(exteriorEntryBPos.m_123342_() + 1), (double)exteriorEntryBPos.m_123343_() + 0.5);
        theme = operator.getAestheticHandler().getShellTheme();
        PortalOffets themeData = THEME_OFFSETS.get(theme);
        PortalOffets.OffsetData interiorDoor = themeData.intDoor();
        PortalOffets.OffsetData exteriorDoor = themeData.shell();
        Level operatorLevel = operator.getLevel();
        switch (location.getDirection()) {
            case EAST: {
                exteriorEntryPosition = exteriorEntryPosition.m_82549_(exteriorDoor.east());
                break;
            }
            case SOUTH: {
                exteriorEntryPosition = exteriorEntryPosition.m_82549_(exteriorDoor.south());
                break;
            }
            case WEST: {
                exteriorEntryPosition = exteriorEntryPosition.m_82549_(exteriorDoor.west());
                break;
            }
            case NORTH: {
                exteriorEntryPosition = exteriorEntryPosition.m_82549_(exteriorDoor.north());
            }
        }
        switch (door.getTeleportRotation()) {
            case EAST: {
                entryPosition = entryPosition.m_82549_(interiorDoor.east());
                break;
            }
            case SOUTH: {
                entryPosition = entryPosition.m_82549_(interiorDoor.south());
                break;
            }
            case WEST: {
                entryPosition = entryPosition.m_82549_(interiorDoor.west());
                break;
            }
            case NORTH: {
                entryPosition = entryPosition.m_82549_(interiorDoor.north());
            }
        }
        DQuaternion extQuat = DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, -1.0, 0.0), (double)location.getDirection().m_122435_());
        DQuaternion interiorQuat = DQuaternion.rotationByDegrees((Vec3)new Vec3(0.0, -1.0, 0.0), (double)door.getTeleportRotation().m_122435_());
        BotiPortalEntity exteriorPortal = ImmersivePortals.createPortal((Level)location.getLevel(), exteriorEntryPosition, entryPosition, (ResourceKey<Level>)operatorLevel.m_46472_(), extQuat);
        BotiPortalEntity interiorPortal = ImmersivePortals.createDestPortal(exteriorPortal, entryPosition, BOTI_PORTAL.get(), interiorQuat);
        exteriorPortal.setShellTheme(ShellTheme.getShellTheme(theme));
        interiorPortal.setShellTheme(ShellTheme.getShellTheme(theme));
        ImmersivePortals.updatePortalEntry(operator, dimId, interiorPortal, exteriorPortal, theme);
        PortalManipulation.adjustRotationToConnect((Portal)exteriorPortal, (Portal)interiorPortal);
        exteriorPortal.setInteractable(false);
        interiorPortal.setInteractable(false);
        interiorPortal.setValid(true);
        exteriorPortal.setValid(true);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("adjustPositionAfterTeleport", false);
        exteriorPortal.updatePortalFromNbt(tag);
        interiorPortal.updatePortalFromNbt(tag);
        exteriorPortal.m_9236_().m_7967_((Entity)exteriorPortal);
        interiorPortal.m_9236_().m_7967_((Entity)interiorPortal);
        exteriorPortal.reloadPortal();
        interiorPortal.reloadPortal();
    }

    private static void updatePortalEntry(TardisLevelOperator operator, UUID dimId, BotiPortalEntity interiorPortal, BotiPortalEntity exteriorPortal, ResourceLocation theme) {
        ImmersivePortals.destroyPortals(operator);
        EXISTING_PORTALS.put(dimId, new PortalEntry(interiorPortal, exteriorPortal, ShellTheme.getShellTheme(theme), dimId));
    }

    public static void destroyPortals(TardisLevelOperator operator) {
        UUID tardisID = UUID.fromString(operator.getLevel().m_46472_().m_135782_().m_135815_());
        PortalEntry portalEntry = EXISTING_PORTALS.get(tardisID);
        if (portalEntry == null) {
            return;
        }
        PortalManipulation.removeConnectedPortals((Portal)portalEntry.getInternalPortal(), portal -> {});
        PortalManipulation.removeConnectedPortals((Portal)portalEntry.getShellPortal(), portal -> {});
        portalEntry.getInternalPortal().setValid(false);
        portalEntry.getInternalPortal().m_6074_();
        portalEntry.getShellPortal().setValid(false);
        portalEntry.getShellPortal().m_6074_();
        EXISTING_PORTALS.remove(tardisID);
    }

    public static BotiPortalEntity createDestPortal(BotiPortalEntity portal, Vec3 doorPos, EntityType<BotiPortalEntity> entityType, DQuaternion quat) {
        Level world = portal.getDestinationWorld();
        BotiPortalEntity newPortal = (BotiPortalEntity)entityType.m_20615_(world);
        newPortal.setTardisId(UUID.fromString(world.m_46472_().m_135782_().m_135815_()));
        newPortal.dimensionTo = portal.m_9236_().m_46472_();
        newPortal.m_146884_(doorPos);
        newPortal.setDestination(portal.getOriginPos());
        newPortal.specificPlayerId = portal.specificPlayerId;
        newPortal.width = portal.width;
        newPortal.height = portal.height;
        newPortal.axisW = new Vec3(1.0, 0.0, 0.0);
        newPortal.axisH = new Vec3(0.0, 1.0, 0.0);
        PortalManipulation.rotatePortalBody((Portal)newPortal, (DQuaternion)DQuaternion.fromMcQuaternion((Quaternionf)quat.toMcQuaternion()));
        return newPortal;
    }

    public static BotiPortalEntity createPortal(Level level, Vec3 origin, Vec3 destination, ResourceKey<Level> destinationLvl, DQuaternion quat) {
        BotiPortalEntity portal = (BotiPortalEntity)BOTI_PORTAL.get().m_20615_(level);
        portal.setTardisId(UUID.fromString(destinationLvl.m_135782_().m_135815_()));
        portal.setOriginPos(origin);
        portal.setDestinationDimension(destinationLvl);
        portal.setDestination(destination);
        portal.setOrientationAndSize(new Vec3(1.0, 0.0, 0.0), new Vec3(0.0, 1.0, 0.0), 1.0, 2.175);
        PortalManipulation.rotatePortalBody((Portal)portal, (DQuaternion)DQuaternion.fromMcQuaternion((Quaternionf)quat.toMcQuaternion()));
        return portal;
    }

    public static void teleportViaIp(Entity pEntity, ServerLevel destination, double pX, double pY, double pZ) {
        PortalAPI.teleportEntity((Entity)pEntity, (ServerLevel)destination, (Vec3)new Vec3(pX, pY, pZ));
    }

    public static void onServerStopping(MinecraftServer server) {
        EXISTING_PORTALS.forEach((uuid, portalEntry) -> {
            portalEntry.getShellPortal().setValid(false);
            portalEntry.getInternalPortal().setValid(false);
            portalEntry.getShellPortal().m_6074_();
            portalEntry.getInternalPortal().m_6074_();
        });
        EXISTING_PORTALS.clear();
    }
}

