/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import whocraft.tardis_refined.api.event.ShellChangeSources;
import whocraft.tardis_refined.api.event.TardisCommonEvents;
import whocraft.tardis_refined.common.block.shell.GlobalShellBlock;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.dimension.DimensionHandler;
import whocraft.tardis_refined.common.dimension.TardisTeleportData;
import whocraft.tardis_refined.common.tardis.TardisArchitectureHandler;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisExteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisInteriorManager;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.common.util.CommandHelper;
import whocraft.tardis_refined.common.util.LevelHelper;
import whocraft.tardis_refined.constants.TardisDimensionConstants;
import whocraft.tardis_refined.mixin.EndDragonFightAccessor;
import whocraft.tardis_refined.patterns.ShellPatterns;
import whocraft.tardis_refined.registry.TRBlockRegistry;
import whocraft.tardis_refined.registry.TRDimensionTypes;

public class TardisHelper {
    public static void playCloisterBell(TardisLevelOperator tardisLevelOperator) {
        for (int i = 0; i < 3; ++i) {
            tardisLevelOperator.getLevel().m_5594_(null, TardisArchitectureHandler.DESKTOP_CENTER_POS, SoundEvents.f_11699_, SoundSource.BLOCKS, 1000.0f, 0.1f);
        }
    }

    public static List<Player> getPlayersInRange(Level world, double x, double y, double z, double range) {
        AABB boundingBox = new AABB(x - range, y - range, z - range, x + range, y + range, z + range);
        return world.m_45976_(Player.class, boundingBox);
    }

    public static List<Player> getPlayersInRange(Level world, Player sourcePlayer, double range) {
        return TardisHelper.getPlayersInRange(world, sourcePlayer.m_20185_(), sourcePlayer.m_20186_(), sourcePlayer.m_20189_(), range);
    }

    public static boolean isInArsArea(BlockPos blockPos) {
        BlockPos corner1 = TardisDimensionConstants.ARS_TREE_CORNER_A;
        BlockPos corner2 = TardisDimensionConstants.ARS_TREE_CORNER_B;
        int minX = Math.min(corner1.m_123341_(), corner2.m_123341_());
        int maxX = Math.max(corner1.m_123341_(), corner2.m_123341_());
        int minY = Math.min(corner1.m_123342_(), corner2.m_123342_());
        int maxY = Math.max(corner1.m_123342_(), corner2.m_123342_());
        int minZ = Math.min(corner1.m_123343_(), corner2.m_123343_());
        int maxZ = Math.max(corner1.m_123343_(), corner2.m_123343_());
        return blockPos.m_123341_() >= minX && blockPos.m_123341_() <= maxX && blockPos.m_123342_() >= minY && blockPos.m_123342_() <= maxY && blockPos.m_123343_() >= minZ && blockPos.m_123343_() <= maxZ;
    }

    public static boolean createTardis(BlockPos blockPos, ServerLevel serverLevel, ResourceKey<Level> generatedLevelKey, ResourceLocation shellTheme, DesktopTheme desktopTheme) {
        GlobalShellBlockEntity shellBaseBlockEntity;
        AtomicBoolean generated = new AtomicBoolean(false);
        BlockState targetBlockState = (BlockState)((BlockState)((BlockState)((BlockState)TRBlockRegistry.GLOBAL_SHELL_BLOCK.get().m_49966_().m_61124_((Property)GlobalShellBlock.FACING, (Comparable)Direction.NORTH)).m_61124_((Property)GlobalShellBlock.REGEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ShellBaseBlock.LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GlobalShellBlock.WATERLOGGED, (Comparable)Boolean.valueOf(serverLevel.m_8055_(blockPos).m_60819_().m_76152_() == Fluids.f_76193_));
        serverLevel.m_7731_(blockPos, targetBlockState, 3);
        BlockEntity blockEntity = serverLevel.m_7702_(blockPos);
        if (blockEntity instanceof GlobalShellBlockEntity && (shellBaseBlockEntity = (GlobalShellBlockEntity)blockEntity).shouldSetup()) {
            shellBaseBlockEntity.setTardisId(generatedLevelKey);
            ServerLevel interior = DimensionHandler.getOrCreateInterior((Level)serverLevel, shellBaseBlockEntity.getTardisId().m_135782_());
            TardisLevelOperator.get(interior).ifPresent(tardisLevelOperator -> {
                TardisInteriorManager intManager = tardisLevelOperator.getInteriorManager();
                TardisExteriorManager extManager = tardisLevelOperator.getExteriorManager();
                TardisPilotingManager pilotManager = tardisLevelOperator.getPilotingManager();
                if (!tardisLevelOperator.hasInitiallyGenerated()) {
                    intManager.generateDesktop(desktopTheme);
                    tardisLevelOperator.getProgressionManager().addDiscoveredLevel((ResourceKey<Level>)serverLevel.m_46472_());
                    Direction direction = ((Direction)targetBlockState.m_61143_((Property)ShellBaseBlock.FACING)).m_122424_();
                    TardisNavLocation navLocation = new TardisNavLocation(blockPos, direction, serverLevel);
                    pilotManager.setCurrentLocation(navLocation);
                    pilotManager.setTargetLocation(navLocation);
                    pilotManager.setFuel(pilotManager.getMaximumFuel());
                    tardisLevelOperator.setInitiallyGenerated(true);
                    tardisLevelOperator.setTardisState(2);
                    intManager.openTheEye(true);
                    serverLevel.m_7731_(blockPos, (BlockState)targetBlockState.m_61124_((Property)ShellBaseBlock.OPEN, (Comparable)Boolean.valueOf(true)), 3);
                    generated.set(true);
                    tardisLevelOperator.setShellTheme(shellTheme, ShellPatterns.getPatternsForTheme(shellTheme).get(0).id(), ShellChangeSources.ROOT_TO_TARDIS);
                    tardisLevelOperator.setOrUpdateExteriorBlock(navLocation, Optional.of(targetBlockState), false, ShellChangeSources.ROOT_TO_TARDIS);
                }
            });
            return generated.get();
        }
        return false;
    }

    public static MutableComponent createTardisIdComponent(ResourceLocation levelId) {
        String id = levelId.toString();
        String displayId = levelId.m_135815_().substring(0, 5);
        MutableComponent tardisId = CommandHelper.createComponentWithTooltip(displayId, id);
        return tardisId;
    }

    public static boolean teleportEntityTardis(TardisLevelOperator cap, Entity entity, TardisNavLocation sourceLocation, TardisNavLocation destinationLocation, boolean enterTardis) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel teleportingEntityLevel = (ServerLevel)level;
            BlockPos destinationPos = destinationLocation.getPosition();
            ServerLevel destinationLevel = destinationLocation.getLevel();
            Direction destinationDirection = destinationLocation.getDirection();
            Direction sourceDirection = sourceLocation.getDirection();
            BlockPos targetTeleportPos = destinationPos;
            if (enterTardis && destinationLevel.m_220362_() != TRDimensionTypes.TARDIS) {
                return false;
            }
            float entityYRot = entity.m_146908_();
            float destinationRotationYaw = destinationDirection.m_122435_();
            float sourceRotationYaw = sourceDirection.m_122435_();
            float diff = LevelHelper.getAdjustedRotation(entityYRot) - LevelHelper.getAdjustedRotation(sourceRotationYaw);
            float adjustedRotationYaw = destinationRotationYaw + diff;
            if (entity.m_6095_().m_20680_().f_20377_ > 1.0f) {
                targetTeleportPos = destinationPos.m_121955_(destinationDirection.m_122436_());
            }
            BlockPos finalTeleportPos = targetTeleportPos;
            Vec3 centredTarget = LevelHelper.centerPos(finalTeleportPos, false);
            TardisTeleportData.scheduleEntityTeleport(entity, (ResourceKey<Level>)destinationLevel.m_46472_(), centredTarget.m_7096_(), centredTarget.m_7098_(), centredTarget.m_7094_(), adjustedRotationYaw, entity.m_146909_());
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (enterTardis) {
                    TardisCommonEvents.TARDIS_ENTRY_EVENT.invoker().onEnterTardis(cap, livingEntity, sourceLocation, destinationLocation);
                } else {
                    TardisCommonEvents.TARDIS_EXIT_EVENT.invoker().onExitTardis(cap, livingEntity, sourceLocation, destinationLocation);
                }
            }
            cap.tardisClientData().sync();
            return true;
        }
        return false;
    }

    public static boolean hasTheEndBeenCompleted(ServerLevel serverLevel) {
        if (serverLevel.m_46472_() == Level.f_46430_) {
            if (serverLevel.m_8586_() != null) {
                return ((EndDragonFightAccessor)serverLevel.m_8586_()).isDragonKilled();
            }
            return false;
        }
        return false;
    }

    public static void handlePlayerJoinWorldEvents(ServerPlayer serverPlayer) {
        TardisLevelOperator cap;
        ServerLevel playerLevel;
        if (serverPlayer != null && serverPlayer.m_284548_() != null && TardisLevelOperator.get(playerLevel = serverPlayer.m_284548_()).isPresent() && (cap = TardisLevelOperator.get(playerLevel).get()).getInteriorManager().isGeneratingDesktop()) {
            playerLevel.m_7654_().m_6937_((Runnable)new TickTask(10, () -> cap.forceEjectPlayer(serverPlayer)));
        }
    }
}

