/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.FileUtil;
import net.minecraft.ResourceLocationException;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.TardisRefined;
import whocraft.tardis_refined.common.tardis.TardisDesktops;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.common.util.CodecJsonReloadListener;
import whocraft.tardis_refined.mixin.MinecraftServerStorageAccessor;

public class DatapackHelper {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/DatapackHelper");

    public static boolean writeDesktopToFile(ServerLevel level, BlockPos bottomCorner, BlockPos topCorner, boolean includeEntities, ResourceLocation structure, DesktopTheme desktop, String datapackName) {
        MinecraftServerStorageAccessor accessor = (MinecraftServerStorageAccessor)level.m_7654_();
        Path rootDir = accessor.getStorageSource().m_78283_(LevelResource.f_78180_).normalize();
        Path datapackRoot = rootDir.resolve(datapackName);
        Path datapackDataFolder = datapackRoot.resolve("data");
        String fileExtension = ".json";
        JsonObject currentDesktop = ((JsonElement)DesktopTheme.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)desktop).get().ifRight(right -> LOGGER.error(right.message())).orThrow()).getAsJsonObject();
        Path output = DatapackHelper.createAndValidatePathToDatapackObject(datapackDataFolder, desktop.getIdentifier(), TardisDesktops.getReloadListener(), fileExtension);
        DatapackHelper.createPackDefinition(datapackRoot);
        return DatapackHelper.createStructure(level, bottomCorner, topCorner, includeEntities, structure, datapackDataFolder) && DatapackHelper.saveJsonToPath((JsonElement)currentDesktop, output);
    }

    public static boolean saveJsonToPath(JsonElement jsonElement, Path path) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(TardisRefined.GSON.toJson(jsonElement));
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage().toString());
            return false;
        }
    }

    public static void createPackDefinition(Path packRoot) {
        Path metaFile = packRoot.resolve("pack.mcmeta");
        if (!Files.exists(metaFile, new LinkOption[0])) {
            JsonObject pack = new JsonObject();
            pack.addProperty("pack_format", (Number)SharedConstants.m_183709_().m_264084_(PackType.SERVER_DATA));
            pack.addProperty("description", "Datapack generated by the Tardis Refined mod");
            JsonObject root = new JsonObject();
            root.add("pack", (JsonElement)pack);
            try {
                Files.createDirectories(packRoot, new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(metaFile, new OpenOption[0]);){
                    writer.write(TardisRefined.GSON.toJson((JsonElement)root));
                }
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage().toString());
            }
        }
    }

    public static boolean createStructure(ServerLevel level, BlockPos bottomCorner, BlockPos topCorner, boolean includeEntities, ResourceLocation structure, Path packRoot) {
        StructureTemplate structureTemplate;
        StructureTemplateManager structureTemplateManager = level.m_215082_();
        try {
            structureTemplate = structureTemplateManager.m_230359_(structure);
        }
        catch (ResourceLocationException e) {
            LOGGER.error(e.getMessage().toString());
            return false;
        }
        AABB boundingBox = new AABB(bottomCorner, topCorner);
        int xSize = (int)boundingBox.m_82362_() + 2;
        int ySize = (int)boundingBox.m_82376_() + 2;
        int zSize = (int)boundingBox.m_82385_() + 2;
        Vec3i structureSize = new Vec3i(xSize, ySize, zSize).m_122012_().m_122024_().m_7495_();
        BlockPos pasteStartPos = BlockPos.m_274561_((double)boundingBox.f_82288_, (double)boundingBox.f_82289_, (double)boundingBox.f_82290_);
        structureTemplate.m_163802_((Level)level, pasteStartPos, structureSize, includeEntities, Blocks.f_50454_);
        structureTemplate.m_74612_("");
        Path path = DatapackHelper.createAndValidatePathToDatapackObject(packRoot, structure, "structures", ".nbt");
        Path pathParent = path.getParent();
        if (pathParent == null) {
            return false;
        }
        try {
            Files.createDirectories(Files.exists(pathParent, new LinkOption[0]) ? pathParent.toRealPath(new LinkOption[0]) : pathParent, new FileAttribute[0]);
        }
        catch (IOException var13) {
            LOGGER.error("Failed to create parent directory: {}", (Object)pathParent);
            return false;
        }
        CompoundTag compoundTag = structureTemplate.m_74618_(new CompoundTag());
        try {
            try (FileOutputStream outputStream = new FileOutputStream(path.toFile());){
                NbtIo.m_128947_((CompoundTag)compoundTag, (OutputStream)outputStream);
            }
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private static Path createAndValidatePathToDatapackObject(Path path, ResourceLocation resourceLocation, CodecJsonReloadListener<?> listener, String fileExtension) {
        return DatapackHelper.createAndValidatePathToDatapackObject(path, resourceLocation, listener.getFolderName(), fileExtension);
    }

    private static Path createAndValidatePathToDatapackObject(Path path, ResourceLocation resourceLocation, String folderName, String fileExtension) {
        if (resourceLocation.m_135815_().contains("//")) {
            throw new ResourceLocationException("Invalid resource path: " + resourceLocation);
        }
        Path path2 = DatapackHelper.createPathToResult(path, resourceLocation, folderName, fileExtension);
        if (path2.startsWith(path) && FileUtil.m_133728_((Path)path2) && FileUtil.m_133734_((Path)path2)) {
            return path2;
        }
        throw new ResourceLocationException("Invalid resource path: " + path2);
    }

    public static Path createPathToResult(Path path, ResourceLocation resourceLocation, String folderName, String fileExtension) {
        try {
            Path datapackRoot = path.resolve(resourceLocation.m_135827_());
            Path folder = datapackRoot.resolve(folderName);
            return FileUtil.m_133736_((Path)folder, (String)resourceLocation.m_135815_(), (String)fileExtension);
        }
        catch (InvalidPathException e) {
            throw new ResourceLocationException("Invalid resource path: " + resourceLocation, (Throwable)e);
        }
    }
}

