/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.control.ship;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import whocraft.tardis_refined.common.blockentity.door.GlobalDoorBlockEntity;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.manager.TardisExteriorManager;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.patterns.sound.ConfiguredSound;

public class ToggleDoorControl
extends Control {
    public ToggleDoorControl(ResourceLocation id) {
        super(id);
    }

    public ToggleDoorControl(ResourceLocation id, String langId) {
        super(id, langId);
    }

    @Override
    public boolean onRightClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        if (!operator.getLevel().m_5776_()) {
            if (operator.getInternalDoor() != null) {
                if (operator.getExteriorManager().locked()) {
                    return false;
                }
                BlockEntity blockEntity = operator.getLevel().m_7702_(operator.getInternalDoor().getDoorPosition());
                if (blockEntity != null && blockEntity instanceof TardisInternalDoor) {
                    TardisInternalDoor internalDoor = (TardisInternalDoor)blockEntity;
                    boolean isDoorOpen = internalDoor.isOpen();
                    operator.setDoorClosed(isDoorOpen);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean onLeftClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        if (operator.getLevel().m_5776_()) {
            return false;
        }
        TardisExteriorManager exteriorManager = operator.getExteriorManager();
        if (exteriorManager != null) {
            boolean isLocked = !exteriorManager.locked();
            exteriorManager.setLocked(isLocked);
            operator.setDoorLocked(isLocked);
            operator.setDoorClosed(isLocked);
            String messageKey = isLocked ? ModMessages.DOOR_LOCKED : ModMessages.DOOR_UNLOCKED;
            PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)messageKey), true);
        }
        return true;
    }

    @Override
    public ConfiguredSound getSuccessSound(TardisLevelOperator operator, ConsoleTheme theme, boolean leftClick) {
        BlockEntity blockEntity;
        if (!operator.getLevel().m_5776_() && (blockEntity = operator.getLevel().m_7702_(operator.getInternalDoor().getDoorPosition())) != null && blockEntity instanceof GlobalDoorBlockEntity) {
            ConfiguredSound pitchedSound;
            GlobalDoorBlockEntity internalDoor = (GlobalDoorBlockEntity)blockEntity;
            boolean isDoorOpen = internalDoor.isOpen();
            ConfiguredSound configuredSound = pitchedSound = isDoorOpen ? internalDoor.pattern().soundProfile().get().getDoorClose() : internalDoor.pattern().soundProfile().get().getDoorOpen();
            if (pitchedSound != null) {
                return pitchedSound;
            }
        }
        return super.getSuccessSound(operator, theme, leftClick);
    }

    @Override
    public ConfiguredSound getFailSound(TardisLevelOperator operator, ConsoleTheme theme, boolean leftClick) {
        return new ConfiguredSound((SoundEvent)SoundEvents.f_12170_.m_203334_());
    }
}

