/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis.control.flight;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.entity.ControlEntity;
import whocraft.tardis_refined.common.tardis.control.Control;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;
import whocraft.tardis_refined.common.util.PlayerUtil;
import whocraft.tardis_refined.constants.ModMessages;

public class HandbrakeControl
extends Control {
    public HandbrakeControl(ResourceLocation id) {
        super(id, true);
    }

    public HandbrakeControl(ResourceLocation id, String langId) {
        super(id, langId, true);
    }

    @Override
    public boolean onLeftClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        if (operator.getPilotingManager().isInFlight()) {
            if (operator.getPilotingManager().isTakingOff() || operator.getPilotingManager().isLanding()) {
                PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.NO_FLIGHT_TRANSITIVE), true);
                return false;
            }
            operator.getPilotingManager().setHandbrakeOn(true);
            PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)(operator.getPilotingManager().isHandbrakeOn() ? ModMessages.HANDBRAKE_ENGAGED : ModMessages.HANDBRAKE_DISENGAGED)), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean onRightClick(TardisLevelOperator operator, ConsoleTheme theme, ControlEntity controlEntity, Player player) {
        if (operator.getPilotingManager().isInFlight()) {
            PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)ModMessages.HANDBRAKE_WARNING), true);
            return false;
        }
        operator.getPilotingManager().setHandbrakeOn(!operator.getPilotingManager().isHandbrakeOn());
        PlayerUtil.sendMessage((LivingEntity)player, (Component)Component.m_237115_((String)(operator.getPilotingManager().isHandbrakeOn() ? ModMessages.HANDBRAKE_ENGAGED : ModMessages.HANDBRAKE_DISENGAGED)), true);
        return true;
    }
}

