/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.tardis;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.common.tardis.themes.DesktopTheme;
import whocraft.tardis_refined.common.util.CodecJsonReloadListener;

public class TardisDesktops {
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/TardisDesktops");
    public static final DesktopTheme DEFAULT_OVERGROWN_THEME = new DesktopTheme("default_overgrown", "cave/cave_generation_one");
    public static final DesktopTheme FACTORY_THEME = new DesktopTheme("factory", "desktop/factory");
    public static final DesktopTheme TERRAFORMED = new DesktopTheme("terraformed", "desktop/terraformed");
    private static final CodecJsonReloadListener<DesktopTheme> RELOAD_LISTENER = TardisDesktops.createReloadListener();
    private static final Map<ResourceLocation, DesktopTheme> DEFAULT_DESKTOPS = new HashMap<ResourceLocation, DesktopTheme>();

    private static CodecJsonReloadListener<DesktopTheme> createReloadListener() {
        CodecJsonReloadListener<DesktopTheme> instance = CodecJsonReloadListener.create("tardis_refined/desktops", DesktopTheme.getCodec());
        return instance;
    }

    public static CodecJsonReloadListener<DesktopTheme> getReloadListener() {
        return RELOAD_LISTENER;
    }

    public static Map<ResourceLocation, DesktopTheme> getRegistry() {
        return RELOAD_LISTENER.getData();
    }

    public static DesktopTheme getDesktopById(ResourceLocation location) {
        return RELOAD_LISTENER.getData().getOrDefault(location, FACTORY_THEME);
    }

    public static Map<ResourceLocation, DesktopTheme> registerDefaultDesktops() {
        DEFAULT_DESKTOPS.clear();
        TardisDesktops.addDefaultDesktop(new DesktopTheme("arnet", "desktop/arnet"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("copper", "desktop/copper"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("coral", "desktop/coral"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("crystal", "desktop/crystal"));
        TardisDesktops.addDefaultDesktop(FACTORY_THEME);
        TardisDesktops.addDefaultDesktop(new DesktopTheme("future_nostalgia", "desktop/future_nostalgia"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("hellbound", "desktop/hellbound"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("ironguard", "desktop/ironguard"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("lodestone", "desktop/lodestone"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("mechanical", "desktop/mechanical"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("mesh", "desktop/mesh"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("newwave", "desktop/newwave"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("nuka", "desktop/nuka"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("radiance", "desktop/radiance"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("refurbished", "desktop/refurbished"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("toyota", "desktop/toyota"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("vapor", "desktop/vapor"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("victorian", "desktop/victorian"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("violet_eye", "desktop/violet_eye"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("watchface", "desktop/watchface"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("classic", "desktop/classic"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("terraformed", "desktop/terraformed_useable"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("panamax", "desktop/panamax"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("hartnell", "desktop/hartnell"));
        TardisDesktops.addDefaultDesktop(new DesktopTheme("pertwee", "desktop/pertwee"));
        return DEFAULT_DESKTOPS;
    }

    private static void addDefaultDesktop(DesktopTheme theme) {
        LOGGER.info("Adding default Desktop {}", (Object)theme.getIdentifier());
        DEFAULT_DESKTOPS.put(theme.getIdentifier(), theme);
    }

    public static Map<ResourceLocation, DesktopTheme> getDefaultDesktops() {
        return DEFAULT_DESKTOPS;
    }
}

