/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.waypoints;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.client.ScreenHandler;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageS2C;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;

public class S2CWaypointsListScreen
extends MessageS2C {
    private Collection<TardisWaypoint> waypoints;

    public S2CWaypointsListScreen(Collection<TardisWaypoint> waypoints) {
        this.waypoints = waypoints;
    }

    public S2CWaypointsListScreen(FriendlyByteBuf friendlyByteBuf) {
        this.waypoints = new ArrayList<TardisWaypoint>();
        int size = friendlyByteBuf.readInt();
        for (int i = 0; i < size; ++i) {
            CompoundTag tardisWay = friendlyByteBuf.m_130260_();
            TardisWaypoint waypoint = TardisWaypoint.deserialise(tardisWay);
            this.waypoints.add(waypoint);
        }
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.OPEN_WAYPOINTS_DISPLAY;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.waypoints.size());
        for (TardisWaypoint waypoint : this.waypoints) {
            buf.m_130079_(waypoint.serialise());
        }
    }

    @Override
    public void handle(MessageContext context) {
        this.handleScreens();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void handleScreens() {
        ScreenHandler.setWaypointScreen(this.waypoints);
    }
}

