/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.network.messages.waypoints;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.MessageC2S;
import whocraft.tardis_refined.common.network.MessageContext;
import whocraft.tardis_refined.common.network.MessageType;
import whocraft.tardis_refined.common.network.TardisNetwork;
import whocraft.tardis_refined.common.tardis.TardisWaypoint;
import whocraft.tardis_refined.common.tardis.manager.TardisWaypointManager;

public class C2SEditWaypoint
extends MessageC2S {
    TardisWaypoint waypoint;

    public C2SEditWaypoint(TardisWaypoint waypoint) {
        this.waypoint = waypoint;
    }

    public C2SEditWaypoint(FriendlyByteBuf buf) {
        CompoundTag tardisNav = buf.m_130260_();
        this.waypoint = TardisWaypoint.deserialise(tardisNav);
    }

    @Override
    @NotNull
    public MessageType getType() {
        return TardisNetwork.EDIT_WAYPOINT;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130079_(this.waypoint.serialise());
    }

    @Override
    public void handle(MessageContext context) {
        ServerPlayer player = context.getPlayer();
        ServerLevel serverLevel = player.m_284548_();
        TardisLevelOperator.get(serverLevel).ifPresent(tardisLevelOperator -> {
            TardisWaypointManager tardisWaypointManager = tardisLevelOperator.getTardisWaypointManager();
            tardisWaypointManager.editWaypoint(this.waypoint);
        });
    }
}

