/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.data;

import com.google.gson.JsonObject;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import whocraft.tardis_refined.common.block.device.AntiGravityBlock;
import whocraft.tardis_refined.common.block.device.TerraformerBlock;
import whocraft.tardis_refined.registry.TRBlockRegistry;

public class TRBlockModelProvider
extends BlockStateProvider {
    public TRBlockModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), "tardis_refined", existingFileHelper);
    }

    public JsonObject emptyBlockState(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("tardis_refined", "block/terraformer"))).build());
        return builder.toJson();
    }

    public JsonObject terraformer(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block).forAllStates(blockState -> (Boolean)blockState.m_61143_((Property)TerraformerBlock.ACTIVE) != false ? ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("tardis_refined", "block/terraformer_on"))).build() : ConfiguredModel.builder().modelFile((ModelFile)this.models().getExistingFile(new ResourceLocation("tardis_refined", "block/terraformer"))).build());
        return builder.toJson();
    }

    public JsonObject lantern(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block).forAllStates(blockState -> (Boolean)blockState.m_61143_((Property)LanternBlock.f_153459_) != false ? ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/zeiton_lantern_hanging", new ResourceLocation("block/template_hanging_lantern"))).texture("lantern", new ResourceLocation("tardis_refined", "block/zeiton_lantern"))).build() : ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/zeiton_lantern", new ResourceLocation("block/template_lantern"))).texture("lantern", new ResourceLocation("tardis_refined", "block/zeiton_lantern"))).build());
        return builder.toJson();
    }

    public JsonObject threeDeeRotating(Block block, ResourceLocation location) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block).forAllStates(blockState -> ConfiguredModel.builder().modelFile((ModelFile)new ModelFile.UncheckedModelFile(location)).rotationY((int)((Direction)blockState.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122435_()).build());
        return builder.toJson();
    }

    public ResourceLocation getBlockResourceLocation(Block block) {
        return TRBlockRegistry.BLOCKS.getKey(block);
    }

    public ResourceLocation getBlockTextureResourceLocation(Block block) {
        ResourceLocation blockTex = TRBlockRegistry.BLOCKS.getKey(block);
        return new ResourceLocation("tardis_refined", "block/" + blockTex.m_135815_());
    }

    public JsonObject customLocation(Block block, ResourceLocation resourceLocation) {
        return ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().modelForState().modelFile((ModelFile)this.models().getExistingFile(resourceLocation)).addModel()).toJson();
    }

    public JsonObject customLocation(Block block) {
        return ((VariantBlockStateBuilder)this.getVariantBuilder(block).partialState().modelForState().modelFile(this.cubeAll(block)).addModel()).toJson();
    }

    public JsonObject antiGravityBlock(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        ResourceLocation modelLocation0 = new ResourceLocation("tardis_refined", "block/gravity_well");
        for (int space = 0; space <= 5; ++space) {
            ResourceLocation modelLocation = space == 0 ? modelLocation0 : new ResourceLocation("tardis_refined", "block/gravity_well_" + space);
            builder.partialState().with((Property)AntiGravityBlock.SPACE, (Comparable)Integer.valueOf(space)).modelForState().modelFile((ModelFile)this.models().getExistingFile(modelLocation)).addModel();
        }
        return builder.toJson();
    }

    protected void registerStatesAndModels() {
        ResourceLocation leavesTexture = new ResourceLocation("tardis_refined:block/ars_leaves");
        ResourceLocation growthStoneTexture = new ResourceLocation("tardis_refined:block/growth_stone");
        this.emptyBlockState((Block)TRBlockRegistry.GLOBAL_CONSOLE_BLOCK.get());
        this.emptyBlockState((Block)TRBlockRegistry.BULK_HEAD_DOOR.get());
        this.emptyBlockState((Block)TRBlockRegistry.GLOBAL_DOOR_BLOCK.get());
        this.emptyBlockState((Block)TRBlockRegistry.GLOBAL_SHELL_BLOCK.get());
        this.emptyBlockState((Block)TRBlockRegistry.ROOT_SHELL_DOOR.get());
        this.emptyBlockState((Block)TRBlockRegistry.ROOT_PLANT_BLOCK.get());
        this.emptyBlockState((Block)TRBlockRegistry.ROOT_SHELL_BLOCK.get());
        this.emptyBlockState((Block)TRBlockRegistry.ARS_EGG.get());
        this.emptyBlockState((Block)TRBlockRegistry.ARTRON_PILLAR.get());
        this.emptyBlockState(TRBlockRegistry.THE_EYE.get());
        this.threeDeeRotating(TRBlockRegistry.LANDING_PAD.get(), new ResourceLocation("tardis_refined", "block/landing_pad"));
        this.threeDeeRotating((Block)TRBlockRegistry.FLIGHT_DETECTOR.get(), new ResourceLocation("tardis_refined", "block/flight_detector"));
        this.terraformer(TRBlockRegistry.TERRAFORMER_BLOCK.get());
        this.customLocation(TRBlockRegistry.ARS_LEAVES.get());
        this.customLocation(TRBlockRegistry.AIR_LOCK_GENERATION_BLOCK.get());
        this.customLocation(TRBlockRegistry.FOOLS_STONE.get());
        this.simpleBlock(TRBlockRegistry.ARTRON_PILLAR_PORT.get());
        this.customLocation(TRBlockRegistry.ASTRAL_MANIPULATOR_BLOCK.get(), new ResourceLocation("tardis_refined", "block/astral_manipulator"));
        this.customLocation(TRBlockRegistry.CORRIDOR_TELEPORTER.get(), new ResourceLocation("tardis_refined", "block/corridor_teleporter"));
        this.customLocation(TRBlockRegistry.ZEITON_FUSED_COPPER_BLOCK.get());
        this.customLocation(TRBlockRegistry.ZEITON_FUSED_IRON_BLOCK.get());
        this.customLocation(TRBlockRegistry.ZEITON_ORE.get());
        this.customLocation(TRBlockRegistry.ZEITON_ORE_DEEPSLATE.get());
        this.customLocation(TRBlockRegistry.ZEITON_BLOCK.get());
        this.antiGravityBlock(TRBlockRegistry.GRAVITY_WELL.get());
        this.fenceBlock(TRBlockRegistry.ARS_LEAVES_FENCE.get(), leavesTexture);
        this.slabBlock(TRBlockRegistry.ARS_LEAVES_SLAB.get(), leavesTexture, leavesTexture, leavesTexture, leavesTexture);
        this.threeDeeRotating((Block)TRBlockRegistry.CONSOLE_CONFIGURATION_BLOCK.get(), new ResourceLocation("tardis_refined", "block/console_configuration"));
        this.lantern((Block)TRBlockRegistry.ZEITON_LANTERN.get());
    }
}

