/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.capability.tardis.upgrades;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.registry.TRUpgrades;

public class Upgrade {
    private final Supplier<Upgrade> parent;
    private final UpgradeType upgradeType;
    private final Supplier<ItemStack> icon;
    private int cost = 1;
    private boolean posSet = false;
    private double posX = 0.0;
    private double posY = 0.0;
    private ResourceLocation translationKey;

    public Upgrade(Supplier<ItemStack> icon, ResourceLocation translationKey, UpgradeType upgradeType) {
        this.icon = icon;
        this.parent = null;
        this.translationKey = translationKey;
        this.upgradeType = upgradeType;
    }

    public Upgrade(Supplier<ItemStack> icon, Supplier<Upgrade> parent, ResourceLocation translationKey, UpgradeType upgradeType) {
        this.icon = icon;
        this.parent = parent;
        this.translationKey = translationKey;
        this.upgradeType = upgradeType;
    }

    public ItemStack getIcon() {
        return this.icon.get();
    }

    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public int getSkillPointsRequired() {
        return this.cost;
    }

    public Upgrade setSkillPointsRequired(int cost) {
        this.cost = cost;
        return this;
    }

    public Upgrade setPosition(double x, double y) {
        this.posSet = true;
        this.posX = x;
        this.posY = y;
        return this;
    }

    @Nullable
    public Vec3 getScreenPosition() {
        if (!this.posSet) {
            return null;
        }
        return new Vec3(this.posX, this.posY, 0.0);
    }

    @Nullable
    public Upgrade getParent() {
        return this.parent != null ? this.parent.get() : null;
    }

    public List<Upgrade> getDirectChildren() {
        ArrayList<Upgrade> upgrades = new ArrayList<Upgrade>();
        for (Map.Entry<ResourceKey<Upgrade>, Upgrade> entry : TRUpgrades.UPGRADE_DEFERRED_REGISTRY.entrySet()) {
            Upgrade upgrade = entry.getValue();
            if (upgrade.getParent() != this) continue;
            upgrades.add(upgrade);
        }
        return upgrades;
    }

    public Component getDisplayName() {
        return Component.m_237115_((String)Util.m_137492_((String)"upgrade", (ResourceLocation)this.translationKey));
    }

    public Component getDisplayDescription() {
        return Component.m_237115_((String)(Util.m_137492_((String)"upgrade", (ResourceLocation)this.translationKey) + ".description"));
    }

    public void onUnlocked(TardisLevelOperator tardisLevelOperator, UpgradeHandler upgradeHandler) {
    }

    public void onLocked(TardisLevelOperator tardisLevelOperator, UpgradeHandler upgradeHandler) {
    }

    public boolean isUnlocked(UpgradeHandler upgradeHandler) {
        if (this.cost <= 0) {
            return true;
        }
        return upgradeHandler.isUpgradeUnlocked(this);
    }

    public static enum UpgradeType {
        MAIN_UPGRADE,
        SUB_UPGRADE;

    }
}

