/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.shell;

import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.shell.ShellBaseBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.dimension.DimensionHandler;
import whocraft.tardis_refined.common.tardis.TardisNavLocation;
import whocraft.tardis_refined.common.tardis.manager.TardisPilotingManager;
import whocraft.tardis_refined.common.util.DimensionUtil;
import whocraft.tardis_refined.registry.TRBlockEntityRegistry;

public class RootedShellBlockEntity
extends ShellBaseBlockEntity {
    public static boolean setUpOnNextTick = false;
    private boolean runSetUpOnNextTick = false;

    public RootedShellBlockEntity(BlockPos blockPos, BlockState blockState) {
        super(TRBlockEntityRegistry.ROOT_SHELL.get(), blockPos, blockState);
    }

    @Override
    public void playDoorCloseSound(boolean closeDoor) {
    }

    @Override
    public void playDoorLockedSound(boolean lockDoor) {
    }

    @Override
    public void tick(Level level, BlockPos blockPos, BlockState blockState, ShellBaseBlockEntity blockEntity) {
        if (this.runSetUpOnNextTick) {
            this.runSetUpOnNextTick = false;
            this.setUpTardis(blockState, level, blockPos);
        }
    }

    public void setUpTardisOnNextTick() {
        this.runSetUpOnNextTick = true;
        setUpOnNextTick = true;
    }

    private void setUpTardis(BlockState blockState, Level level, BlockPos blockPos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.shouldSetup()) {
                ResourceKey generatedLevelKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("tardis_refined", UUID.randomUUID().toString()));
                ServerLevel interior = DimensionHandler.getOrCreateInterior((Level)serverLevel, generatedLevelKey.m_135782_());
                this.setTardisId((ResourceKey<Level>)generatedLevelKey);
                TardisLevelOperator.get(interior).ifPresent(tardisLevelOperator -> {
                    if (!tardisLevelOperator.hasInitiallyGenerated()) {
                        tardisLevelOperator.setupInitialCave(serverLevel, blockState, blockPos);
                        tardisLevelOperator.getProgressionManager().addDiscoveredLevel((ResourceKey<Level>)level.m_46472_());
                    }
                    TardisPilotingManager pilot = tardisLevelOperator.getPilotingManager();
                    pilot.setTargetLocation(new TardisNavLocation(blockPos, (Direction)blockState.m_61143_((Property)ShellBaseBlock.FACING), (ResourceKey<Level>)level.m_46472_()));
                    pilot.setCurrentLocation(new TardisNavLocation(blockPos, (Direction)blockState.m_61143_((Property)ShellBaseBlock.FACING), (ResourceKey<Level>)level.m_46472_()));
                    tardisLevelOperator.setDoorClosed(false);
                    serverLevel.m_5594_(null, blockPos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
                });
            } else {
                ServerLevel tardisLevel = DimensionUtil.getLevel(this.getTardisId());
                TardisLevelOperator.get(tardisLevel).ifPresent(tardisLevelOperator -> tardisLevelOperator.setDoorClosed(false));
            }
        }
    }
}

