/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.blockentity.door;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.common.block.door.GlobalDoorBlock;
import whocraft.tardis_refined.common.block.door.InternalDoorBlock;
import whocraft.tardis_refined.common.blockentity.door.TardisInternalDoor;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;

public class AbstractDoorBlockEntity
extends BlockEntity
implements TardisInternalDoor {
    private String uuid_id = UUID.randomUUID().toString();
    private boolean isMainDoor = false;
    private TardisLevelOperator operator;

    public AbstractDoorBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public boolean isMainDoor() {
        return this.isMainDoor;
    }

    @Override
    public void onSetMainDoor(boolean isMainDoor) {
        this.isMainDoor = isMainDoor;
    }

    @Override
    public String getID() {
        return this.uuid_id;
    }

    @Override
    public void setID(String id) {
        this.uuid_id = id;
        this.m_6596_();
    }

    @Override
    public boolean isOpen() {
        return (Boolean)this.m_58900_().m_61143_((Property)InternalDoorBlock.OPEN);
    }

    @Override
    public void setClosed(boolean closeDoor) {
        BlockState blockState = this.m_58904_().m_8055_(this.getDoorPosition());
        if (blockState.m_60734_() instanceof InternalDoorBlock) {
            Level currentLevel = this.m_58904_();
            currentLevel.m_7731_(this.getDoorPosition(), (BlockState)blockState.m_61124_((Property)GlobalDoorBlock.OPEN, (Comparable)Boolean.valueOf(!closeDoor)), 3);
            this.playDoorCloseSound(closeDoor);
            this.m_6596_();
        }
    }

    @Override
    public BlockPos getDoorPosition() {
        return this.m_58899_();
    }

    @Override
    public BlockPos getTeleportPosition() {
        Direction direction = (Direction)this.m_58900_().m_61143_((Property)InternalDoorBlock.FACING);
        return this.m_58899_().m_121955_(direction.m_122424_().m_122436_());
    }

    @Override
    public Direction getTeleportRotation() {
        return ((Direction)this.m_58900_().m_61143_((Property)InternalDoorBlock.FACING)).m_122424_();
    }

    @Override
    public Direction getRotation() {
        return (Direction)this.m_58900_().m_61143_((Property)InternalDoorBlock.FACING);
    }

    @Override
    public void onEntityExit(ServerEntity entity) {
    }

    @Override
    public void setLocked(boolean locked) {
        BlockState blockState = this.m_58904_().m_8055_(this.getDoorPosition());
        if (blockState.m_60734_() instanceof InternalDoorBlock) {
            Level currentLevel = this.m_58904_();
            currentLevel.m_7731_(this.getDoorPosition(), (BlockState)blockState.m_61124_((Property)InternalDoorBlock.LOCKED, (Comparable)Boolean.valueOf(locked)), 3);
            this.playDoorLockedSound(locked);
            this.m_6596_();
        }
    }

    @Override
    public boolean locked() {
        return (Boolean)this.m_58900_().m_61143_((Property)InternalDoorBlock.LOCKED);
    }

    public TardisLevelOperator getOperator() {
        return this.operator;
    }

    public void onBlockPlaced() {
        if (!this.m_58904_().m_5776_()) {
            Optional<TardisLevelOperator> lvlOper = TardisLevelOperator.get((ServerLevel)this.m_58904_());
            lvlOper.ifPresent(tardisLevelOperator -> {
                this.operator = tardisLevelOperator;
            });
        }
    }

    protected void m_183515_(CompoundTag compoundTag) {
        super.m_183515_(compoundTag);
        compoundTag.m_128379_("is_main_door", this.isMainDoor);
        compoundTag.m_128359_("door_id", this.uuid_id);
    }

    public void m_142466_(CompoundTag compoundTag) {
        super.m_142466_(compoundTag);
        this.isMainDoor = compoundTag.m_128471_("is_main_door");
        this.uuid_id = compoundTag.m_128461_("door_id");
    }

    @Override
    public void onAttemptEnter(BlockState blockState, Level level, BlockPos doorPos, Entity entity) {
        if (!entity.m_9236_().m_5776_() && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Optional<TardisLevelOperator> data = TardisLevelOperator.get(serverLevel);
            data.ifPresent(tardisLevelOperator -> {
                tardisLevelOperator.setInternalDoor(this);
                tardisLevelOperator.exitTardis(entity, serverLevel, doorPos, (Direction)blockState.m_61143_((Property)InternalDoorBlock.FACING), false);
            });
        }
    }

    public void playDoorCloseSound(boolean closeDoor) {
        Level currentLevel = this.m_58904_();
        currentLevel.m_5594_(null, this.getDoorPosition(), closeDoor ? SoundEvents.f_12055_ : SoundEvents.f_12056_, SoundSource.BLOCKS, 1.0f, closeDoor ? 1.4f : 1.0f);
        this.m_6596_();
    }

    public void playDoorLockedSound(boolean lockDoor) {
        Level currentLevel = this.m_58904_();
        currentLevel.m_5594_(null, this.getDoorPosition(), lockDoor ? BlockSetType.f_271132_.f_271502_() : BlockSetType.f_271132_.f_271141_(), SoundSource.BLOCKS, 1.0f, lockDoor ? 1.4f : 1.0f);
    }
}

