/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.shell;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.block.shell.ShellBaseBlock;
import whocraft.tardis_refined.common.blockentity.shell.GlobalShellBlockEntity;
import whocraft.tardis_refined.common.blockentity.shell.ShellBaseBlockEntity;
import whocraft.tardis_refined.common.tardis.themes.ShellTheme;

public class GlobalShellBlock
extends ShellBaseBlock {
    public static final BooleanProperty LIT = BooleanProperty.m_61465_((String)"lit");
    protected static final VoxelShape BRIEFCASE_COLLISION_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public GlobalShellBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LOCKED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIT});
    }

    @Override
    public BlockState m_5573_(@NotNull BlockPlaceContext blockPlaceContext) {
        return super.m_5573_(blockPlaceContext);
    }

    @Override
    public VoxelShape m_5939_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        GlobalShellBlockEntity shellBlockEntity;
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity instanceof GlobalShellBlockEntity && (shellBlockEntity = (GlobalShellBlockEntity)blockEntity).theme() == ShellTheme.BRIEFCASE.getId()) {
            return BRIEFCASE_COLLISION_SHAPE;
        }
        return super.m_5939_(blockState, blockGetter, blockPos, collisionContext);
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        GlobalShellBlockEntity shellBlockEntity;
        BlockEntity blockEntity = blockGetter.m_7702_(blockPos);
        if (blockEntity instanceof GlobalShellBlockEntity && (shellBlockEntity = (GlobalShellBlockEntity)blockEntity).theme() == ShellTheme.BRIEFCASE.getId()) {
            return BRIEFCASE_COLLISION_SHAPE;
        }
        return super.m_5940_(blockState, blockGetter, blockPos, collisionContext);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new GlobalShellBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return (level1, blockPos, block, t) -> {
            if (t instanceof ShellBaseBlockEntity) {
                ShellBaseBlockEntity shellBaseBlockEntity = (ShellBaseBlockEntity)t;
                shellBaseBlockEntity.tick(level1, blockPos, blockState, shellBaseBlockEntity);
            }
        };
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (!player.m_9236_().m_5776_() && level instanceof ServerLevel) {
            BlockEntity blockEntity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (blockHitResult.m_82434_().m_122424_() == blockState.m_61143_((Property)FACING) && (blockEntity = serverLevel.m_7702_(blockPos)) instanceof GlobalShellBlockEntity) {
                GlobalShellBlockEntity entity = (GlobalShellBlockEntity)blockEntity;
                ItemStack itemStack = player.m_21120_(interactionHand);
                entity.onRightClick(blockState, itemStack, level, blockPos, player);
                return InteractionResult.m_19078_((boolean)false);
            }
        }
        return InteractionResult.m_19078_((boolean)true);
    }
}

