/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.common.block.life;

import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.common.blockentity.life.ArsEggBlockEntity;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.network.messages.upgrades.S2CDisplayUpgradeScreen;
import whocraft.tardis_refined.common.util.TardisHelper;

public class ArsEggBlock
extends BaseEntityBlock {
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty ALIVE = BooleanProperty.m_61465_((String)"alive");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape AABB = Shapes.m_83113_((VoxelShape)Stream.of(Block.m_49796_((double)4.0, (double)9.0, (double)7.0, (double)12.0, (double)10.0, (double)9.0), Block.m_49796_((double)4.0, (double)9.0, (double)7.0, (double)12.0, (double)10.0, (double)9.0), Block.m_49796_((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), Block.m_49796_((double)6.0, (double)11.0, (double)6.0, (double)10.0, (double)13.0, (double)10.0)).reduce((v1, v2) -> Shapes.m_83113_((VoxelShape)v1, (VoxelShape)v2, (BooleanOp)BooleanOp.f_82695_)).get(), (VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (BooleanOp)BooleanOp.f_82695_);
    private static final VoxelShape NO_CLAMP_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0);

    public ArsEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)ALIVE, (Comparable)Boolean.valueOf(true)));
    }

    protected static Direction getConnectedDirection(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return (Boolean)blockState.m_61143_((Property)HANGING) != false ? AABB.m_83216_(0.0, 0.3, 0.0) : ((Boolean)blockState.m_61143_((Property)ALIVE) != false ? AABB : NO_CLAMP_AABB);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Direction[] var3;
        FluidState fluidState = blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_());
        for (Direction direction : var3 = blockPlaceContext.m_6232_()) {
            BlockState blockState;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockState = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)blockPlaceContext.m_43725_(), blockPlaceContext.m_8083_())) continue;
            return (BlockState)((BlockState)blockState.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_))).m_61124_((Property)ALIVE, (Comparable)Boolean.valueOf(TardisHelper.isInArsArea(blockPlaceContext.m_8083_())));
        }
        return null;
    }

    public boolean m_7357_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, PathComputationType pathComputationType) {
        return false;
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return ArsEggBlock.getConnectedDirection(blockState).m_122424_() == direction && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HANGING, WATERLOGGED, ALIVE});
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = ArsEggBlock.getConnectedDirection(blockState).m_122424_();
        return Block.m_49863_((LevelReader)levelReader, (BlockPos)blockPos.m_121945_(direction), (Direction)direction.m_122424_());
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ArsEggBlockEntity(blockPos, blockState);
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            TardisLevelOperator.get(serverPlayer.m_284548_()).ifPresent(tardisLevelOperator -> {
                if (TardisHelper.isInArsArea(blockPos)) {
                    CompoundTag upgradeNbt = tardisLevelOperator.getUpgradeHandler().saveData(new CompoundTag());
                    new S2CDisplayUpgradeScreen(upgradeNbt).send(serverPlayer);
                }
            });
        }
        return super.m_6227_(blockState, level, blockPos, player, interactionHand, blockHitResult);
    }
}

