/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.command.sub;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import whocraft.tardis_refined.command.arguments.UpgradeArgumentType;
import whocraft.tardis_refined.common.capability.tardis.TardisLevelOperator;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.util.CommandHelper;
import whocraft.tardis_refined.common.util.TardisHelper;
import whocraft.tardis_refined.constants.ModMessages;
import whocraft.tardis_refined.registry.TRUpgrades;

public class UpgradesCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandDispatcher<CommandSourceStack> dispatcher) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"upgrades").then(Commands.m_82127_((String)"lock").then(Commands.m_82129_((String)"upgrade", (ArgumentType)UpgradeArgumentType.upgradeArgumentType()).then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(UpgradesCommand::setUpgradeLocked))))).then(Commands.m_82127_((String)"unlock").then(Commands.m_82129_((String)"upgrade", (ArgumentType)UpgradeArgumentType.upgradeArgumentType()).then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(UpgradesCommand::setUpgradeUnlocked))))).then(Commands.m_82127_((String)"unlock-all").then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(UpgradesCommand::unlockAll)))).then(Commands.m_82127_((String)"lock-all").then(Commands.m_82129_((String)"tardis", (ArgumentType)DimensionArgument.m_88805_()).suggests(CommandHelper.SUGGEST_TARDISES).executes(UpgradesCommand::lockAll)));
    }

    private static int unlockAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            for (Map.Entry<ResourceKey<Upgrade>, Upgrade> entry : TRUpgrades.UPGRADE_DEFERRED_REGISTRY.entrySet()) {
                Upgrade upgrade = entry.getValue();
                tardisLevelOperator.getUpgradeHandler().unlockUpgrade(upgrade);
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_UPGRADE_UNLOCK, (Object[])new Object[]{upgrade.getDisplayName(), tardisId}));
            }
        });
        return 1;
    }

    private static int lockAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            for (Map.Entry<ResourceKey<Upgrade>, Upgrade> entry : TRUpgrades.UPGRADE_DEFERRED_REGISTRY.entrySet()) {
                Upgrade upgrade = entry.getValue();
                tardisLevelOperator.getUpgradeHandler().lockUpgrade(upgrade);
                ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_UPGRADE_LOCK, (Object[])new Object[]{upgrade.getDisplayName(), tardisId}));
            }
        });
        return 1;
    }

    private static int setUpgradeLocked(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Upgrade upgrade = UpgradeArgumentType.getUpgrade(context, "upgrade");
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            tardisLevelOperator.getUpgradeHandler().lockUpgrade(upgrade);
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_UPGRADE_LOCK, (Object[])new Object[]{upgrade.getDisplayName(), tardisId}));
        });
        return 1;
    }

    private static int setUpgradeUnlocked(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Upgrade upgrade = UpgradeArgumentType.getUpgrade(context, "upgrade");
        ServerLevel dimension = DimensionArgument.m_88808_(context, (String)"tardis");
        MutableComponent tardisId = TardisHelper.createTardisIdComponent(dimension.m_46472_().m_135782_());
        TardisLevelOperator.get(dimension).ifPresent(tardisLevelOperator -> {
            tardisLevelOperator.getUpgradeHandler().unlockUpgrade(upgrade);
            ((CommandSourceStack)context.getSource()).m_243053_((Component)Component.m_237110_((String)ModMessages.CMD_UPGRADE_UNLOCK, (Object[])new Object[]{upgrade.getDisplayName(), tardisId}));
        });
        return 1;
    }
}

