/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.upgrades;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.advancements.AdvancementWidgetType;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import whocraft.tardis_refined.client.screen.upgrades.UpgradeTab;
import whocraft.tardis_refined.client.screen.upgrades.UpgradesScreen;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.common.util.Platform;
import whocraft.tardis_refined.registry.TRUpgrades;

public class UpgradeWidget {
    private static final int[] TEST_SPLIT_OFFSETS = new int[]{0, 10, -10, 25, -25};
    private static final ResourceLocation TITLE_BOX_SPRITE = new ResourceLocation("tardis_refined", "textures/gui/sprites/title_box.png");
    public final Upgrade upgradeEntry;
    private final UpgradeTab tab;
    private final UpgradeHandler upgradeHandler;
    private final FormattedCharSequence title;
    private final int width;
    private final List<FormattedCharSequence> description;
    private final Minecraft minecraft;
    public double gridX;
    public double gridY;
    public boolean fixedPosition = false;
    List<UpgradeWidget> parents = new LinkedList<UpgradeWidget>();
    List<UpgradeWidget> children = new LinkedList<UpgradeWidget>();
    private int x;
    private int y;

    public UpgradeWidget(UpgradeTab tab, Minecraft mc, UpgradeHandler upgradeHandler, Upgrade upgradeEntry) {
        this.tab = tab;
        this.upgradeHandler = upgradeHandler;
        this.upgradeEntry = upgradeEntry;
        this.minecraft = mc;
        this.title = Language.m_128107_().m_5536_(mc.f_91062_.m_92854_((FormattedText)upgradeEntry.getDisplayName(), 163));
        int l = 29 + mc.f_91062_.m_92724_(this.title);
        Component description = upgradeEntry.getDisplayDescription();
        this.description = Language.m_128107_().m_128112_(this.findOptimalLines((Component)ComponentUtils.m_130750_((MutableComponent)(description != null ? description.m_6881_() : Component.m_237119_()), (Style)Style.f_131099_.m_131140_(ChatFormatting.WHITE)), l));
        for (FormattedCharSequence formattedCharSequence : this.description) {
            l = Math.max(l, this.minecraft.f_91062_.m_92724_(formattedCharSequence));
        }
        this.width = l + 3 + 5;
    }

    private static float getMaxWidth(StringSplitter manager, List<FormattedText> text) {
        return (float)text.stream().mapToDouble(arg_0 -> ((StringSplitter)manager).m_92384_(arg_0)).max().orElse(0.0);
    }

    public UpgradeWidget updatePosition(double x, double y, UpgradeTab tab) {
        this.gridX = x;
        this.gridY = y;
        this.x = (int)(x * 30.0) - 16;
        this.y = (int)(tab.getFreeYPos(x, y) * 30.0) - 13;
        for (UpgradeWidget child : this.children) {
            child.updatePosition(this.gridX + 1.0, y, tab);
        }
        return this;
    }

    public UpgradeWidget setPosition(double x, double y) {
        this.gridX = x;
        this.gridY = y;
        this.x = (int)(x * 30.0) - 16;
        this.y = (int)(y * 30.0) - 13;
        return this;
    }

    public UpgradeWidget setPositionFixed(double x, double y) {
        this.fixedPosition = true;
        return this.setPosition(x, y);
    }

    public UpgradeWidget updateRelatives(Collection<UpgradeWidget> list) {
        this.parents.clear();
        this.children.clear();
        Upgrade parent = this.upgradeEntry.getParent();
        List<Upgrade> children = this.upgradeEntry.getDirectChildren();
        for (UpgradeWidget widget : list) {
            if (parent != null && widget.upgradeEntry == parent) {
                this.parents.add(widget);
            }
            if (children.isEmpty() || !children.contains(widget.upgradeEntry)) continue;
            this.children.add(widget);
        }
        return this;
    }

    private List<FormattedText> findOptimalLines(Component component, int maxWidth) {
        StringSplitter stringSplitter = this.minecraft.f_91062_.m_92865_();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : TEST_SPLIT_OFFSETS) {
            List list2 = stringSplitter.m_92414_((FormattedText)component, maxWidth - i, Style.f_131099_);
            float g = Math.abs(UpgradeWidget.getMaxWidth(stringSplitter, list2) - (float)maxWidth);
            if (g <= 10.0f) {
                return list2;
            }
            if (!(g < f)) continue;
            f = g;
            list = list2;
        }
        return list;
    }

    public void drawDisplayIcon(Minecraft mc, GuiGraphics guiGraphics, int x, int y) {
        if (this.upgradeEntry.isUnlocked(this.upgradeHandler)) {
            guiGraphics.m_280203_(this.upgradeEntry.getIcon(), x, y);
        } else {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.m_280163_(UpgradesScreen.LOCKED, x - 5, y - 5, 0.0f, 0.0f, 26, 26, 26, 26);
        }
    }

    public void drawIcon(Minecraft mc, GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        boolean isUnlocked = this.upgradeEntry.isUnlocked(this.upgradeHandler);
        guiGraphics.m_280163_(UpgradesScreen.getFrame(this.upgradeEntry.getUpgradeType(), isUnlocked), x - 13, y - 13, 0.0f, 0.0f, 26, 26, 26, 26);
        this.drawDisplayIcon(mc, guiGraphics, x - 8, y - 8);
    }

    public int getWidth() {
        return this.width;
    }

    public void drawHover(GuiGraphics guiGraphics, int x, int y, float fade, int width, int height) {
        AdvancementWidgetType advancementWidgetType2;
        AdvancementWidgetType advancementWidgetType;
        boolean bl = width + x + this.x + this.width + 26 >= this.tab.getScreen().f_96543_;
        String string = null;
        int i = string == null ? 0 : this.minecraft.f_91062_.m_92895_(string);
        boolean bl2 = 113 - y - this.y - 26 <= 6 + this.description.size() * 9;
        float f = 0.0f;
        int j = Mth.m_14143_((float)(f * (float)this.width));
        if (f >= 1.0f) {
            j = this.width / 2;
            advancementWidgetType = AdvancementWidgetType.OBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.OBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            advancementWidgetType = AdvancementWidgetType.UNOBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.UNOBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            advancementWidgetType = AdvancementWidgetType.OBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.OBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.UNOBTAINED;
        } else {
            advancementWidgetType = AdvancementWidgetType.OBTAINED;
            advancementWidgetType2 = AdvancementWidgetType.UNOBTAINED;
            advancementWidgetType3 = AdvancementWidgetType.UNOBTAINED;
        }
        int k = this.width - j;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        int l = y + this.y;
        int m = bl ? x + this.x - this.width + 26 + 6 : x + this.x;
        int n = 32 + this.description.size() * 17;
        if (!this.description.isEmpty()) {
            if (bl2) {
                guiGraphics.m_280260_(UpgradesScreen.WIDGETS, m + 2, l + 26 - n, this.width, n, 10, 200, 26, 0, 52);
            } else {
                guiGraphics.m_280260_(UpgradesScreen.WIDGETS, m, l, this.width, n, 10, 200, 26, 0, 52);
            }
        }
        guiGraphics.m_280218_(UpgradesScreen.WIDGETS, m, l, 0, advancementWidgetType.m_97325_() * 26, j, 26);
        guiGraphics.m_280218_(UpgradesScreen.WIDGETS, m + j, l, 200 - k, advancementWidgetType2.m_97325_() * 26, k, 26);
        guiGraphics.m_280163_(UpgradesScreen.getFrame(this.upgradeEntry.getUpgradeType(), this.upgradeEntry.isUnlocked(this.upgradeHandler)), x + this.x + 3, y + this.y, 0.0f, 0.0f, 26, 26, 26, 26);
        if (bl) {
            guiGraphics.m_280648_(this.minecraft.f_91062_, this.title, m + 5, y + this.y + 9, -1);
            if (string != null) {
                guiGraphics.m_280488_(this.minecraft.f_91062_, string, x + this.x - i, y + this.y + 9, -1);
            }
        } else {
            guiGraphics.m_280648_(this.minecraft.f_91062_, this.title, x + this.x + 32, y + this.y + 9, -1);
            if (string != null) {
                guiGraphics.m_280488_(this.minecraft.f_91062_, string, x + this.x + this.width - i - 5, y + this.y + 9, -1);
            }
        }
        if (bl2) {
            for (int o = 0; o < this.description.size(); ++o) {
                guiGraphics.m_280648_(this.minecraft.f_91062_, this.description.get(o), m + 5, l + 26 - n + 7 + o * 9, -5592406);
            }
            ResourceLocation key = TRUpgrades.UPGRADE_DEFERRED_REGISTRY.getKey(this.upgradeEntry);
            String owner = Platform.getModName(key.m_135827_());
            guiGraphics.m_280488_(this.minecraft.f_91062_, ChatFormatting.BLUE + owner, m + 5, l + 26 + 9, -1);
        } else {
            for (int o = 0; o < this.description.size(); ++o) {
                guiGraphics.m_280648_(this.minecraft.f_91062_, this.description.get(o), m + 5, y + this.y + 9 + 17 + o * 9, -5592406);
            }
            ResourceLocation key = TRUpgrades.UPGRADE_DEFERRED_REGISTRY.getKey(this.upgradeEntry);
            String owner = Platform.getModName(key.m_135827_());
            guiGraphics.m_280488_(this.minecraft.f_91062_, ChatFormatting.BLUE + owner, m + 5, y + this.y + 9 + 17 + this.description.size() * 9 + 5, -1);
        }
        this.drawDisplayIcon(this.minecraft, guiGraphics, x + this.x + 8, y + this.y + 5);
    }

    public boolean isMouseOver(int x, int y, int mouseX, int mouseY) {
        int i = x + this.x;
        int j = i + 26;
        int k = y + this.y;
        int l = k + 26;
        return mouseX >= i && mouseX <= j && mouseY >= k && mouseY <= l;
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

