/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.screen.upgrades;

import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import whocraft.tardis_refined.client.screen.upgrades.UpgradeTabType;
import whocraft.tardis_refined.client.screen.upgrades.UpgradeWidget;
import whocraft.tardis_refined.client.screen.upgrades.UpgradesScreen;
import whocraft.tardis_refined.common.capability.tardis.upgrades.Upgrade;
import whocraft.tardis_refined.common.capability.tardis.upgrades.UpgradeHandler;
import whocraft.tardis_refined.registry.TRUpgrades;

@OnlyIn(value=Dist.CLIENT)
public class UpgradeTab {
    public static final int GRID_SIZE = 30;
    public final UpgradeHandler upgradeHandler;
    private final Minecraft minecraft;
    private final UpgradesScreen screen;
    private final UpgradeTabType type;
    private final int index;
    private final Component title;
    private final List<UpgradeWidget> entries = new ArrayList<UpgradeWidget>();
    private final List<Connection> connections = new ArrayList<Connection>();
    public float fade;
    private double scrollX;
    private double scrollY;
    private int minX = Integer.MAX_VALUE;
    private int minY = Integer.MAX_VALUE;
    private int maxX = Integer.MIN_VALUE;
    private int maxY = Integer.MIN_VALUE;
    private boolean centered;

    public UpgradeTab(Minecraft minecraft, UpgradesScreen UpgradesScreen2, UpgradeTabType tabType, int i, UpgradeHandler powerHolder) {
        this.minecraft = minecraft;
        this.screen = UpgradesScreen2;
        this.type = tabType;
        this.index = i;
        this.upgradeHandler = powerHolder;
        this.title = Component.m_237113_((String)"");
        this.populate(powerHolder);
    }

    @Nullable
    public static UpgradeTab create(Minecraft minecraft, UpgradesScreen screen, int tabIndex, UpgradeHandler upgradeHandler) {
        UpgradeTabType[] var4;
        for (UpgradeTabType tabType : var4 = UpgradeTabType.values()) {
            if (tabIndex < tabType.getMax()) {
                return new UpgradeTab(minecraft, screen, tabType, tabIndex, upgradeHandler);
            }
            tabIndex -= tabType.getMax();
        }
        return null;
    }

    public void populate(UpgradeHandler upgradeHandlerClient) {
        this.entries.clear();
        this.connections.clear();
        CompoundTag newData = upgradeHandlerClient.saveData(new CompoundTag());
        this.upgradeHandler.loadData(newData);
        LinkedList<UpgradeWidget> root = new LinkedList<UpgradeWidget>();
        for (Map.Entry<ResourceKey<Upgrade>, Upgrade> entry : TRUpgrades.UPGRADE_DEFERRED_REGISTRY.entrySet()) {
            Upgrade upgrade = entry.getValue();
            UpgradeWidget widget = new UpgradeWidget(this, this.minecraft, upgradeHandlerClient, upgrade).setPosition(0.0, 0.0);
            this.entries.add(widget);
            Vec3 pos = upgrade.getScreenPosition();
            if (pos == null) continue;
            widget.setPositionFixed(pos.f_82479_, pos.f_82480_);
        }
        for (UpgradeWidget upgradeWidget : this.entries) {
            upgradeWidget.updateRelatives(this.entries);
        }
        int y = 0;
        for (UpgradeWidget entry : this.entries) {
            if (!entry.parents.isEmpty()) continue;
            if (!entry.fixedPosition) {
                entry.updatePosition(0.0, y, this);
                ++y;
            }
            root.add(entry);
        }
        int n = this.longestRow();
        for (int j = 0; j < root.size(); ++j) {
            for (UpgradeWidget parent : root) {
                for (UpgradeWidget child : parent.children) {
                    if (child.fixedPosition || parent.gridX != child.gridX) continue;
                    child.setPosition(child.gridX + 1.0, this.getFreeYPos(child.gridX + 1.0, parent.gridY));
                }
            }
        }
        for (int x = 0; x < 100; ++x) {
            List<UpgradeWidget> entries = this.getEntriesAtX(x);
            for (int n2 = 0; n2 < entries.size(); ++n2) {
                UpgradeWidget entry = entries.get(n2);
                if (entry.fixedPosition) continue;
                entry.setPosition(entry.gridX, (double)n / 2.0 - (double)entries.size() / 2.0 + (double)n2);
            }
        }
        for (UpgradeWidget entry : this.entries) {
            this.minX = (int)Math.min((entry.gridX - 1.0) * 30.0, (double)this.minX);
            this.minY = (int)Math.min((entry.gridY - 1.0) * 30.0, (double)this.minY);
            this.maxX = (int)Math.max((entry.gridX + 1.0) * 30.0, (double)this.maxX);
            this.maxY = (int)Math.max((entry.gridY + 1.0) * 30.0, (double)this.maxY);
            for (UpgradeWidget child : entry.children) {
                Connection connection = new Connection();
                int startX = this.toCoord(entry.gridX);
                int startY = this.toCoord(entry.gridY, 1.0 / (double)(entry.children.size() + 1) * (double)(entry.children.indexOf(child) + 1));
                int endX = this.toCoord(child.gridX);
                int endY = this.toCoord(child.gridY, 1.0 / (double)(child.parents.size() + 1) * (double)(child.parents.indexOf(entry) + 1));
                if (this.getEntry(child.gridX, entry.gridY) == null) {
                    connection.addLine(new ConnectionLine(startX, startY, endX, startY));
                    connection.addLine(new ConnectionLine(endX, startY, endX, endY));
                } else {
                    connection.addLine(new ConnectionLine(startX, startY, startX, endY));
                    connection.addLine(new ConnectionLine(startX, endY, endX, endY));
                }
                connection.color = entry.upgradeEntry.isUnlocked(this.upgradeHandler) ? new Color(ChatFormatting.WHITE.m_126665_()) : Color.GRAY;
                this.connections.add(connection);
            }
        }
    }

    private int toCoord(double d) {
        return this.toCoord(d, 0.5);
    }

    private int toCoord(double d, double height) {
        return (int)((d - 0.5) * 30.0 + 7.0 + 16.0 * height);
    }

    private int longestRow() {
        int l = 0;
        for (int i = 0; i < 100; ++i) {
            int k = this.getEntriesAtX(i).size();
            l = Math.max(l, k);
        }
        return l;
    }

    public List<UpgradeWidget> getEntriesAtX(double x) {
        LinkedList<UpgradeWidget> list = new LinkedList<UpgradeWidget>();
        for (UpgradeWidget entry : this.entries) {
            if (entry.gridX != x) continue;
            list.add(entry);
        }
        return list;
    }

    public UpgradeWidget getEntry(double x, double y) {
        for (UpgradeWidget entry : this.entries) {
            if (entry.gridX != x || entry.gridY != y) continue;
            return entry;
        }
        return null;
    }

    public double getFreeYPos(double x, double y) {
        for (int i = (int)y; i < 100; ++i) {
            if (this.getEntry(x, i) != null) continue;
            return i;
        }
        return 0.0;
    }

    public UpgradeTabType getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public Component getTitle() {
        return this.title;
    }

    public void drawTab(GuiGraphics guiGraphics, int offsetX, int offsetY, boolean isSelected) {
        this.type.draw(guiGraphics, offsetX, offsetY, isSelected, this.index);
    }

    public void drawIcon(GuiGraphics guiGraphics, int offsetX, int offsetY) {
    }

    public void drawContents(GuiGraphics guiGraphics, int x, int y) {
        if (!this.centered) {
            this.scrollX = 117.0 - (double)(this.maxX + this.minX) / 2.0;
            this.scrollY = 56.0 - (double)(this.maxY + this.minY) / 2.0;
            this.centered = true;
        }
        guiGraphics.m_280588_(x, y, x + 224, y + 123);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)x, (float)y, 0.0f);
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        int k = i % 16;
        int l = j % 16;
        for (Connection connection : this.connections) {
            connection.drawOutlines(this, guiGraphics, i, j);
        }
        for (Connection connection : this.connections) {
            connection.draw(this, guiGraphics, i, j);
        }
        for (UpgradeWidget widget : this.entries) {
            widget.drawIcon(this.minecraft, guiGraphics, i + widget.getX() + 16, j + widget.getY() + 13);
        }
        guiGraphics.m_280168_().m_85849_();
        guiGraphics.m_280618_();
    }

    public void drawTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int width, int height, boolean overlayActive) {
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -200.0f);
        guiGraphics.m_280509_(0, 0, 224, 123, Mth.m_14143_((float)(this.fade * 255.0f)) << 24);
        boolean flag = false;
        if (!overlayActive) {
            int i = Mth.m_14107_((double)this.scrollX);
            int j = Mth.m_14107_((double)this.scrollY);
            if (mouseX > 0 && mouseX < 224 && mouseY > 0 && mouseY < 123) {
                for (UpgradeWidget widget : this.entries) {
                    if (!widget.isMouseOver(i, j, mouseX, mouseY)) continue;
                    flag = true;
                    widget.drawHover(guiGraphics, i, j, this.fade, width, height);
                    break;
                }
            }
        }
        guiGraphics.m_280168_().m_85849_();
        if (!overlayActive) {
            this.fade = flag ? Mth.m_14036_((float)(this.fade + 0.02f), (float)0.0f, (float)0.3f) : Mth.m_14036_((float)(this.fade - 0.04f), (float)0.0f, (float)1.0f);
        }
    }

    public UpgradeWidget getUpgradeHoveredOver(int mouseX, int mouseY, int x, int y) {
        int i = Mth.m_14107_((double)this.scrollX);
        int j = Mth.m_14107_((double)this.scrollY);
        if (mouseX > 0 && mouseX < 224 && mouseY > 0 && mouseY < 123) {
            for (UpgradeWidget entry : this.entries) {
                if (!entry.isMouseOver(i, j, mouseX, mouseY)) continue;
                return entry;
            }
        }
        return null;
    }

    public boolean isMouseOver(int offsetX, int offsetY, double mouseX, double mouseY) {
        return this.type.isMouseOver(offsetX, offsetY, this.index, mouseX, mouseY);
    }

    public void scroll(double dragX, double dragY) {
        if (this.maxX - this.minX > 224) {
            this.scrollX = Mth.m_14008_((double)(this.scrollX + dragX), (double)(-(this.maxX - 224)), (double)(-this.minX));
        }
        if (this.maxY - this.minY > 123) {
            this.scrollY = Mth.m_14008_((double)(this.scrollY + dragY), (double)(-(this.maxY - 123)), (double)(-this.minY));
        }
    }

    public UpgradesScreen getScreen() {
        return this.screen;
    }

    public static class Connection {
        public Color color = Color.YELLOW;
        public List<ConnectionLine> lines = new LinkedList<ConnectionLine>();

        public Connection(List<ConnectionLine> lines) {
            this.lines = lines;
        }

        public Connection() {
        }

        public Connection addLine(ConnectionLine line) {
            this.lines.add(line);
            return this;
        }

        public void drawOutlines(UpgradeTab gui, GuiGraphics guiGraphics, int x, int y) {
            for (ConnectionLine lines : this.lines) {
                lines.draw(gui, guiGraphics, x, y, true, Color.BLACK);
            }
        }

        public void draw(UpgradeTab gui, GuiGraphics guiGraphics, int x, int y) {
            for (ConnectionLine lines : this.lines) {
                lines.draw(gui, guiGraphics, x, y, false, this.color);
            }
        }
    }

    public static class ConnectionLine {
        public int startX;
        public int startY;
        public int endX;
        public int endY;

        public ConnectionLine(int startX, int startY, int endX, int endY) {
            this.startX = Math.min(startX, endX);
            this.startY = Math.min(startY, endY);
            this.endX = Math.max(startX, endX);
            this.endY = Math.max(startY, endY);
        }

        public void draw(UpgradeTab upgradeTab, GuiGraphics guiGraphics, int x, int y, boolean outline, Color color) {
            int colorCode = color.getRGB();
            if (outline) {
                if (this.startY == this.endY) {
                    guiGraphics.m_280656_(x + this.startX - 2, x + this.endX + 1, y + this.startY - 2, colorCode);
                    guiGraphics.m_280656_(x + this.startX - 2, x + this.endX + 1, y + this.startY + 1, colorCode);
                } else if (this.startX == this.endX) {
                    guiGraphics.m_280315_(x + this.startX - 2, y + this.startY - 2, y + this.endY + 1, colorCode);
                    guiGraphics.m_280315_(x + this.startX + 1, y + this.startY - 2, y + this.endY + 1, colorCode);
                }
            } else if (this.startY == this.endY) {
                guiGraphics.m_280656_(x + this.startX - 1, x + this.endX, y + this.startY - 1, colorCode);
                guiGraphics.m_280656_(x + this.startX - 1, x + this.endX, y + this.startY, colorCode);
            } else if (this.startX == this.endX) {
                guiGraphics.m_280315_(x + this.startX - 1, y + this.startY - 1, y + this.endY, colorCode);
                guiGraphics.m_280315_(x + this.startX, y + this.startY - 1, y + this.endY, colorCode);
            }
        }
    }
}

