/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.renderer.blockentity.device;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;
import org.joml.Random;
import whocraft.tardis_refined.client.ModelRegistry;
import whocraft.tardis_refined.client.model.GenericModel;
import whocraft.tardis_refined.common.block.device.ArtronPillarBlock;
import whocraft.tardis_refined.common.blockentity.device.ArtronPillarBlockEntity;

public class ArtronPillarRenderer
implements BlockEntityRenderer<ArtronPillarBlockEntity>,
BlockEntityRendererProvider<ArtronPillarBlockEntity> {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);
    private final GenericModel artronPillarBlockModel;
    private final ResourceLocation POWER_ON = new ResourceLocation("tardis_refined", "textures/blockentity/artron_pillar.png");
    private final ResourceLocation POWER_OFF = new ResourceLocation("tardis_refined", "textures/blockentity/artron_pillar_off.png");

    public ArtronPillarRenderer(BlockEntityRendererProvider.Context context) {
        this.artronPillarBlockModel = new GenericModel(context.m_173582_(ModelRegistry.ARTRON_PILLAR));
    }

    private static void vertex01(VertexConsumer iVertexBuilder, Matrix4f matrix4f, int p_229061_2_) {
        iVertexBuilder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_229061_2_).m_5752_();
        iVertexBuilder.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(255, 255, 255, p_229061_2_).m_5752_();
    }

    private static void vertex2(VertexConsumer iVertexBuilder, Matrix4f matrix4f, float p_229060_2_, float p_229060_3_) {
        iVertexBuilder.m_252986_(matrix4f, -HALF_SQRT_3 * p_229060_3_, p_229060_2_, -0.5f * p_229060_3_).m_6122_(16, 206, 0, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer iVertexBuilder, Matrix4f matrix4f, float p_229062_2_, float p_229062_3_) {
        iVertexBuilder.m_252986_(matrix4f, HALF_SQRT_3 * p_229062_3_, p_229062_2_, -0.5f * p_229062_3_).m_6122_(16, 206, 0, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer iVertexBuilder, Matrix4f matrix4f, float p_229063_2_, float p_229063_3_) {
        iVertexBuilder.m_252986_(matrix4f, 0.0f, p_229063_2_, 1.0f * p_229063_3_).m_6122_(16, 206, 0, 0).m_5752_();
    }

    public void render(ArtronPillarBlockEntity blockEntity, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 1.475f, 0.5f);
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        BlockState blockState = blockEntity.m_58900_();
        ResourceLocation lampTexture = (Boolean)blockEntity.m_58900_().m_61143_((Property)ArtronPillarBlock.ACTIVE) != false ? this.POWER_ON : this.POWER_OFF;
        this.artronPillarBlockModel.m_7695_(poseStack, multiBufferSource.m_6299_(RenderType.m_110473_((ResourceLocation)lampTexture)), i, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        if (((Boolean)blockState.m_61143_((Property)ArtronPillarBlock.ACTIVE)).booleanValue()) {
            VertexConsumer vertexBuilder = multiBufferSource.m_6299_(RenderType.m_110502_());
            Random random = new Random(432L);
            float f5 = (150.0f + Minecraft.m_91087_().m_91296_()) / 200.0f;
            float f7 = Math.min(f5 > 0.8f ? (f5 - 0.8f) / 0.2f : 0.0f, 1.0f);
            float sine = 0.0f;
            sine = (float)(Math.sin(0.1 * (double)blockEntity.m_58904_().m_8044_() + (double)blockEntity.m_58899_().m_121878_()) * 0.25) + 1.0f;
            if (sine < 0.0f) {
                sine = 0.0f;
            }
            poseStack.m_85837_(0.0, -2.5, 0.0);
            boolean shouldRotateOtherWay = blockEntity.m_58899_().m_121878_() % 3L == 0L;
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)Minecraft.m_91087_().f_91074_.f_19797_ * (shouldRotateOtherWay ? -0.5f : 0.5f)));
            poseStack.m_85841_(0.075f * sine, 0.075f * sine, 0.075f * sine);
            int x = 0;
            while ((float)x < (f5 + f5 * f5) / 2.0f * 60.0f) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252529_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252436_.m_252977_(random.nextFloat() * 360.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(random.nextFloat() * 360.0f + f5 * 90.0f));
                float randomFloat = random.nextFloat() * 20.0f + 5.0f + f7 * 10.0f;
                float randomFloat2 = random.nextFloat() * 2.0f + 1.0f + f7 * 2.0f;
                Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
                int k = (int)(255.0f * (1.0f - f7));
                ArtronPillarRenderer.vertex01(vertexBuilder, matrix4f, k);
                ArtronPillarRenderer.vertex2(vertexBuilder, matrix4f, randomFloat, randomFloat2);
                ArtronPillarRenderer.vertex3(vertexBuilder, matrix4f, randomFloat, randomFloat2);
                ArtronPillarRenderer.vertex01(vertexBuilder, matrix4f, k);
                ArtronPillarRenderer.vertex3(vertexBuilder, matrix4f, randomFloat, randomFloat2);
                ArtronPillarRenderer.vertex4(vertexBuilder, matrix4f, randomFloat, randomFloat2);
                ArtronPillarRenderer.vertex01(vertexBuilder, matrix4f, k);
                ArtronPillarRenderer.vertex4(vertexBuilder, matrix4f, randomFloat, randomFloat2);
                ArtronPillarRenderer.vertex2(vertexBuilder, matrix4f, randomFloat, randomFloat2);
                ++x;
            }
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(ArtronPillarBlockEntity blockEntity) {
        return true;
    }

    public BlockEntityRenderer<ArtronPillarBlockEntity> m_173570_(BlockEntityRendererProvider.Context context) {
        return new ArtronPillarRenderer(context);
    }
}

