/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class CrystalConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition IDLE = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/crystal/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/crystal/flight.json"));
    private static final ResourceLocation CRYSTAL_TEXTURE = new ResourceLocation("tardis_refined", "textures/blockentity/console/crystal/crystal_console.png");
    private final ModelPart base_control;
    private final ModelPart rotor;
    private final ModelPart rotor_purple;
    private final ModelPart controls;
    private final ModelPart spinninglight;
    private final ModelPart bb_main;
    private final ModelPart root;
    private final ModelPart throttle;
    private final ModelPart handbrake;

    public CrystalConsoleModel(ModelPart root) {
        this.root = root;
        this.base_control = root.m_171324_("base_control");
        this.rotor = root.m_171324_("rotor");
        this.rotor_purple = root.m_171324_("rotor_purple");
        this.controls = root.m_171324_("controls");
        this.spinninglight = root.m_171324_("spinninglight");
        this.bb_main = root.m_171324_("bb_main");
        this.throttle = Frame.findPart(this, "large_lever_control_throttle");
        this.handbrake = Frame.findPart(this, "large_lever3_control");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.base_control.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rotor.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rotor_purple.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.controls.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.spinninglight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bb_main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    @Override
    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float rot;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        if (globalConsoleBlock != null && ((Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED)).booleanValue()) {
            if (reactions.isFlying()) {
                this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, Minecraft.m_91087_().f_91074_.f_19797_);
            } else if (((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue() && globalConsoleBlock != null) {
                this.m_233381_(globalConsoleBlock.liveliness, IDLE, Minecraft.m_91087_().f_91074_.f_19797_);
            }
        }
        this.throttle.f_104203_ = rot = -0.5f + 0.5f * ((float)reactions.getThrottleStage() / 5.0f);
        this.handbrake.f_104203_ = reactions.isHandbrakeEngaged() ? 0.0f : -0.5f;
        this.base_control.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rotor.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.rotor_purple.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.controls.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.spinninglight.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.bb_main.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return CRYSTAL_TEXTURE;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }
}

