/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.jeryn.frame.tardis.Frame;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import whocraft.tardis_refined.TRConfig;
import whocraft.tardis_refined.client.TardisClientData;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.common.block.console.GlobalConsoleBlock;
import whocraft.tardis_refined.common.blockentity.console.GlobalConsoleBlockEntity;

public class CoralConsoleModel
extends HierarchicalModel
implements ConsoleUnit {
    public static final AnimationDefinition IDLE = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/coral/idle.json"));
    public static final AnimationDefinition FLIGHT = Frame.loadAnimation(new ResourceLocation("tardis_refined", "frame/console/coral/flight.json"));
    private static final ResourceLocation CORAL_TEXTURE = new ResourceLocation("tardis_refined", "textures/blockentity/console/coral/coral_console.png");
    private final ModelPart throttle;
    private final ModelPart handbrake;
    private final ModelPart base_console;
    private final ModelPart anim_parts;
    private final ModelPart root;

    public CoralConsoleModel(ModelPart root) {
        this.root = root;
        this.base_console = root.m_171324_("base_console");
        this.throttle = this.base_console.m_171324_("controls").m_171324_("borders").m_171324_("bone23").m_171324_("bone17").m_171324_("throttle");
        this.anim_parts = root.m_171324_("anim_parts");
        this.handbrake = Frame.findPart(this, "handbrake");
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.base_console.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.anim_parts.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public void renderConsole(GlobalConsoleBlockEntity globalConsoleBlock, Level level, PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        float rot;
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        TardisClientData reactions = TardisClientData.getInstance((ResourceKey<Level>)level.m_46472_());
        if (globalConsoleBlock != null && ((Boolean)globalConsoleBlock.m_58900_().m_61143_((Property)GlobalConsoleBlock.POWERED)).booleanValue()) {
            if (reactions.isFlying()) {
                this.m_233381_(reactions.ROTOR_ANIMATION, FLIGHT, Minecraft.m_91087_().f_91074_.f_19797_);
            } else if (((Boolean)TRConfig.CLIENT.PLAY_CONSOLE_IDLE_ANIMATIONS.get()).booleanValue() && globalConsoleBlock != null) {
                this.m_233381_(globalConsoleBlock.liveliness, IDLE, Minecraft.m_91087_().f_91074_.f_19797_);
            }
        }
        this.throttle.f_104203_ = rot = 0.0f + 2.0f * ((float)reactions.getThrottleStage() / 5.0f);
        this.handbrake.f_104203_ = !reactions.isHandbrakeEngaged() ? 1.0f : -0.25f;
        this.base_console.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        this.anim_parts.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    @Override
    public ResourceLocation getDefaultTexture() {
        return CORAL_TEXTURE;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(Entity entity, float f, float g, float h, float i, float j) {
    }
}

