/*
 * Decompiled with CFR 0.152.
 */
package whocraft.tardis_refined.client.model.blockentity.console;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import whocraft.tardis_refined.api.event.TardisClientEvents;
import whocraft.tardis_refined.client.ModelRegistry;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleModelEntry;
import whocraft.tardis_refined.client.model.blockentity.console.ConsoleUnit;
import whocraft.tardis_refined.client.model.blockentity.console.CopperConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.CoralConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.CrystalConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.FactoryConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.InitiativeConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.MystConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.NukaConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.RefurbishedConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.ToyotaConsoleModel;
import whocraft.tardis_refined.client.model.blockentity.console.VictorianConsoleModel;
import whocraft.tardis_refined.common.tardis.themes.ConsoleTheme;

public class ConsoleModelCollection {
    public static HashMap<ResourceLocation, ConsoleModelEntry> CONSOLE_MODELS = new HashMap();
    private static ConsoleModelCollection instance = null;
    ConsoleUnit toyotaConsoleModel;
    ConsoleUnit coralConsoleModel;
    ConsoleUnit copperConsoleModel;
    ConsoleUnit nukaConsoleModel;
    ConsoleUnit factoryConsoleModel;
    ConsoleUnit crystalConsoleModel;
    ConsoleUnit victorianConsoleModel;
    ConsoleUnit mystConsoleModel;
    ConsoleUnit initiativeConsoleModel;
    ConsoleUnit refurbishedConsoleModel;
    public static Logger LOGGER = LogManager.getLogger((String)"TardisRefined/ConsoleModelCollection");

    public ConsoleModelCollection() {
        EntityModelSet context = Minecraft.m_91087_().m_167973_();
        this.registerModels(context);
    }

    public static ConsoleModelCollection getInstance() {
        if (instance == null) {
            instance = new ConsoleModelCollection();
        }
        return instance;
    }

    public void registerModels(EntityModelSet context) {
        this.factoryConsoleModel = new FactoryConsoleModel(context.m_171103_(ModelRegistry.FACTORY_CONSOLE));
        this.nukaConsoleModel = new NukaConsoleModel(context.m_171103_(ModelRegistry.NUKA_CONSOLE));
        this.copperConsoleModel = new CopperConsoleModel(context.m_171103_(ModelRegistry.COPPER_CONSOLE));
        this.coralConsoleModel = new CoralConsoleModel(context.m_171103_(ModelRegistry.CORAL_CONSOLE));
        this.toyotaConsoleModel = new ToyotaConsoleModel(context.m_171103_(ModelRegistry.TOYOTA_CONSOLE));
        this.crystalConsoleModel = new CrystalConsoleModel(context.m_171103_(ModelRegistry.CRYSTAL_CONSOLE));
        this.victorianConsoleModel = new VictorianConsoleModel(context.m_171103_(ModelRegistry.VICTORIAN_CONSOLE));
        this.mystConsoleModel = new MystConsoleModel(context.m_171103_(ModelRegistry.MYST_CONSOLE));
        this.initiativeConsoleModel = new InitiativeConsoleModel(context.m_171103_(ModelRegistry.INITIATIVE_CONSOLE));
        this.refurbishedConsoleModel = new RefurbishedConsoleModel(context.m_171103_(ModelRegistry.REFURBISHED_CONSOLE));
        this.registerModel(ConsoleTheme.FACTORY.getId(), new ConsoleModelEntry(this.factoryConsoleModel));
        this.registerModel(ConsoleTheme.NUKA.getId(), new ConsoleModelEntry(this.nukaConsoleModel));
        this.registerModel(ConsoleTheme.COPPER.getId(), new ConsoleModelEntry(this.copperConsoleModel));
        this.registerModel(ConsoleTheme.CORAL.getId(), new ConsoleModelEntry(this.coralConsoleModel));
        this.registerModel(ConsoleTheme.TOYOTA.getId(), new ConsoleModelEntry(this.toyotaConsoleModel));
        this.registerModel(ConsoleTheme.CRYSTAL.getId(), new ConsoleModelEntry(this.crystalConsoleModel));
        this.registerModel(ConsoleTheme.VICTORIAN.getId(), new ConsoleModelEntry(this.victorianConsoleModel));
        this.registerModel(ConsoleTheme.MYST.getId(), new ConsoleModelEntry(this.mystConsoleModel));
        this.registerModel(ConsoleTheme.INITIATIVE.getId(), new ConsoleModelEntry(this.initiativeConsoleModel));
        this.registerModel(ConsoleTheme.REFURBISHED.getId(), new ConsoleModelEntry(this.refurbishedConsoleModel));
        TardisClientEvents.CONSOLE_MODELS_SETUP.invoker().setupConsoleModels(this, context);
        ConsoleModelCollection.validateConsoleModels();
    }

    private static void validateConsoleModels() {
        for (Map.Entry<ResourceKey<ConsoleTheme>, ConsoleTheme> entry : ConsoleTheme.CONSOLE_THEME_DEFERRED_REGISTRY.entrySet()) {
            ResourceKey<ConsoleTheme> key = entry.getKey();
            Validate.isTrue((boolean)CONSOLE_MODELS.containsKey(key.m_135782_()), (String)String.format("Missing registered model for console theme: %s", key), (Object[])new Object[0]);
        }
    }

    public void registerModel(ResourceLocation resourceLocation, ConsoleModelEntry consoleModel) {
        if (consoleModel == null) {
            LOGGER.warn("Attempted to register a null console model.");
            return;
        }
        if (CONSOLE_MODELS.containsKey(resourceLocation)) {
            LOGGER.warn("Attempted to register a console model that is already registered: {}", (Object)resourceLocation);
            return;
        }
        CONSOLE_MODELS.put(resourceLocation, consoleModel);
        LOGGER.info("Registered console model: {}", (Object)resourceLocation);
    }

    public ConsoleModelEntry getConsoleEntry(ResourceLocation themeId) {
        ConsoleModelEntry consoleModelEntry = CONSOLE_MODELS.get(themeId);
        if (consoleModelEntry == null) {
            LOGGER.warn("Could not find model for {}, did you bind it?", (Object)themeId);
        }
        return consoleModelEntry;
    }
}

