/*
 * Decompiled with CFR 0.152.
 */
package dev.jeryn.frame.tardis;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.animation.AnimationChannel;
import net.minecraft.client.animation.AnimationDefinition;
import net.minecraft.client.animation.Keyframe;
import net.minecraft.client.animation.KeyframeAnimations;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Frame {
    private static final Logger LOGGER = LogManager.getLogger((String)"TardisRefined/FrameByJeryn");
    public static final AnimationChannel.Interpolation SNAP_TO = (destination, progress, keyFrames, startIndex, endIndex, scaleFactor) -> {
        Vector3f startVector = keyFrames[startIndex].f_232284_();
        Vector3f endVector = keyFrames[endIndex].f_232284_();
        return startVector.lerp((Vector3fc)endVector, 0.0f, destination).mul(scaleFactor);
    };

    public static AnimationDefinition loadAnimation(ResourceLocation resourceLocation) {
        return Frame.loadAnimation(Minecraft.m_91087_().m_91098_(), resourceLocation);
    }

    public static AnimationDefinition loadAnimation(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        if (resourceManager == null) {
            return null;
        }
        JsonObject animationJson = Frame.loadJsonFromResource(resourceManager, resourceLocation);
        Frame.validateAnimationJson(animationJson, resourceLocation);
        float animationLength = animationJson.get("length").getAsFloat();
        boolean looping = animationJson.has("looping") && animationJson.get("looping").getAsBoolean();
        AnimationDefinition.Builder animationDefinition = AnimationDefinition.Builder.m_232275_((float)animationLength);
        if (looping) {
            animationDefinition.m_232274_();
        }
        JsonArray animations = animationJson.getAsJsonArray("animations");
        for (JsonElement boneEntry : animations) {
            if (!boneEntry.isJsonObject()) {
                LOGGER.warn("Skipping invalid bone entry in animation: {}", (Object)resourceLocation);
                continue;
            }
            JsonObject boneData = boneEntry.getAsJsonObject();
            String boneName = boneData.get("bone").getAsString();
            String target = boneData.get("target").getAsString();
            List<Keyframe> keyframes = Frame.parseKeyframes(boneData, Frame.targetToAnimationTarget(target));
            if (keyframes.isEmpty()) continue;
            animationDefinition.m_232279_(boneName, new AnimationChannel(Frame.targetToAnimationTarget(target), keyframes.toArray(new Keyframe[0])));
        }
        return animationDefinition.m_232282_();
    }

    private static void validateAnimationJson(JsonObject animationJson, ResourceLocation resourceLocation) {
        if (animationJson == null || !animationJson.has("animations") || animationJson.getAsJsonArray("animations").isEmpty()) {
            LOGGER.error("Invalid or missing animation JSON: {}", (Object)resourceLocation);
            throw new IllegalArgumentException("Invalid or missing animation JSON: " + resourceLocation);
        }
    }

    private static AnimationChannel.Target targetToAnimationTarget(String target) {
        return switch (target.toLowerCase()) {
            case "rotation" -> AnimationChannel.Targets.f_232251_;
            case "position" -> AnimationChannel.Targets.f_232250_;
            case "scale" -> AnimationChannel.Targets.f_232252_;
            default -> throw new IllegalArgumentException("Unknown animation target: " + target);
        };
    }

    private static List<Keyframe> parseKeyframes(JsonObject boneData, AnimationChannel.Target targetType) {
        if (!boneData.has("keyframes") || !boneData.get("keyframes").isJsonArray()) {
            return Collections.emptyList();
        }
        JsonArray keyframesArray = boneData.getAsJsonArray("keyframes");
        ArrayList<Keyframe> keyframes = new ArrayList<Keyframe>(keyframesArray.size());
        for (JsonElement keyframeElement : keyframesArray) {
            if (!keyframeElement.isJsonObject()) continue;
            JsonObject keyframeObject = keyframeElement.getAsJsonObject();
            float timestamp = keyframeObject.has("timestamp") ? keyframeObject.get("timestamp").getAsFloat() : 0.0f;
            JsonArray targetArray = keyframeObject.getAsJsonArray("target");
            if (targetArray == null || targetArray.size() != 3) {
                LOGGER.warn("Invalid target array for keyframe at timestamp: {}", (Object)Float.valueOf(timestamp));
                continue;
            }
            Vector3f vector3f = new Vector3f(targetArray.get(0).getAsFloat(), targetArray.get(1).getAsFloat(), targetArray.get(2).getAsFloat());
            AnimationChannel.Interpolation interpolation = keyframeObject.has("interpolation") ? Frame.getInterpolation(keyframeObject.get("interpolation").getAsString()) : AnimationChannel.Interpolations.f_232229_;
            keyframes.add(new Keyframe(timestamp, Frame.targetToVector(targetType, vector3f), interpolation));
        }
        LOGGER.debug("Parsed {} keyframes for bone: {}, target: {}", (Object)keyframes.size(), (Object)boneData.get("bone").getAsString(), (Object)Frame.targetToString(targetType));
        return keyframes;
    }

    private static String targetToString(AnimationChannel.Target target) {
        if (target.equals(AnimationChannel.Targets.f_232250_)) {
            return "Position";
        }
        if (target.equals(AnimationChannel.Targets.f_232251_)) {
            return "Rotation";
        }
        if (target.equals(AnimationChannel.Targets.f_232252_)) {
            return "Scale";
        }
        throw new IllegalArgumentException("Unexpected target: " + target);
    }

    private static Vector3f targetToVector(AnimationChannel.Target target, Vector3f vector3f) {
        if (target == AnimationChannel.Targets.f_232250_) {
            return KeyframeAnimations.m_253126_((float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
        }
        if (target == AnimationChannel.Targets.f_232251_) {
            return KeyframeAnimations.m_253186_((float)vector3f.x, (float)vector3f.y, (float)vector3f.z);
        }
        if (target == AnimationChannel.Targets.f_232252_) {
            return KeyframeAnimations.m_253004_((double)vector3f.x, (double)vector3f.y, (double)vector3f.z);
        }
        return null;
    }

    private static AnimationChannel.Interpolation getInterpolation(String easingType) {
        return switch (easingType.toLowerCase()) {
            case "linear" -> AnimationChannel.Interpolations.f_232229_;
            case "catmullrom" -> AnimationChannel.Interpolations.f_232230_;
            default -> SNAP_TO;
        };
    }

    public static JsonObject loadJsonFromResource(ResourceManager resourceManager, ResourceLocation resourceLocation) {
        LOGGER.info("Loading animation: {}", (Object)resourceLocation);
        return resourceManager.m_213713_(resourceLocation).map(resource -> {
            JsonObject jsonObject;
            JsonReader reader = new JsonReader((Reader)new InputStreamReader(resource.m_215507_()));
            try {
                jsonObject = JsonParser.parseReader((JsonReader)reader).getAsJsonObject();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Error reading animation: {}", (Object)resourceLocation, (Object)e);
                    throw new RuntimeException(e);
                }
            }
            reader.close();
            return jsonObject;
        }).orElseThrow(() -> {
            LOGGER.error("Animation not found: {}", (Object)resourceLocation);
            return new IllegalArgumentException("Animation not found: " + resourceLocation);
        });
    }

    public static ModelPart findPart(HierarchicalModel<?> model, String partName) {
        return model.m_142109_().m_171331_().filter(part -> part.m_233562_(partName)).findFirst().map(part -> part.m_171324_(partName)).orElseThrow(() -> new IllegalArgumentException("Part not found: " + partName));
    }
}

