/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacks.backpack;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.NbtToSnbt;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.SnbtPrinterTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.LevelResource;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackTemplateStorage;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.DatapackBackpackTemplateManager;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.wrapper.IBackpackWrapper;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.settings.DatapackSettingsTemplateManager;

public class BackpackTemplates {
    public static final Pattern EXPORT_TEMPLATE_NAMESPACE_PATTERN = Pattern.compile("[a-z0-9_\\-\\s]+");
    public static final Pattern EXPORT_TEMPLATE_PATH_PATTERN = Pattern.compile("[a-z0-9/_\\-\\s]+");
    public static final Function<Object, MutableComponent> INVALID_CHARACTER = invalid_character -> Component.m_237110_((String)"commands.sophisticatedbackpacks.template.export.failure.invalid_characters", (Object[])new Object[]{invalid_character}).m_130940_(ChatFormatting.RED);

    private BackpackTemplates() {
    }

    public static void setBackpackTemplate(ResourceLocation templateName, IBackpackWrapper wrapper) {
        Item backpackItem = wrapper.getBackpack().m_41720_();
        Optional backpackUuid = wrapper.getContentsUuid();
        backpackUuid.ifPresent(uuid -> BackpackTemplates.setBackpackTemplate(templateName, BuiltInRegistries.f_257033_.m_7981_((Object)backpackItem), BackpackStorage.get().getOrCreateBackpackContents((UUID)uuid).m_6426_()));
    }

    public static void setBackpackTemplate(ResourceLocation templateName, ResourceLocation backpackItemRegistryName, CompoundTag contents) {
        CompoundTag data = new CompoundTag();
        data.m_128359_("backpackItemRegistryName", backpackItemRegistryName.toString());
        data.m_128365_("backpackContents", (Tag)contents);
        BackpackTemplateStorage.get().setBackpackTemplate(templateName, data);
    }

    public static Optional<CompoundTag> getBackpackTemplateNoDatapack(ResourceLocation templateName) {
        return BackpackTemplateStorage.get().getBackpackTemplate(templateName);
    }

    public static Optional<CompoundTag> getBackpackTemplate(ResourceLocation templateName) {
        Optional<CompoundTag> template = BackpackTemplates.getBackpackTemplateNoDatapack(templateName);
        return template.or(() -> DatapackBackpackTemplateManager.getBackpackTemplate(templateName));
    }

    public static void removeBackpackTemplate(ResourceLocation templateName) {
        BackpackTemplateStorage.get().removeBackpackTemplate(templateName);
    }

    public static Set<ResourceLocation> getTemplateNames() {
        return BackpackTemplates.getTemplateNames(true);
    }

    public static Set<ResourceLocation> getTemplateNames(boolean includeDatapackTemplates) {
        TreeSet templateNames = Sets.newTreeSet();
        templateNames.addAll(BackpackTemplateStorage.get().getBackpackTemplates().keySet());
        if (includeDatapackTemplates) {
            templateNames.addAll(DatapackBackpackTemplateManager.getBackpackTemplates().keySet());
        }
        return templateNames;
    }

    public static void exportTemplate(ServerPlayer player, ResourceLocation templateName, CompoundTag contentNbt) {
        Path templatesDir;
        Matcher matcher = EXPORT_TEMPLATE_NAMESPACE_PATTERN.matcher(templateName.m_135827_());
        if (!matcher.matches()) {
            player.m_5661_((Component)INVALID_CHARACTER.apply(BackpackTemplates.findNonMatchingCharacters(matcher, templateName.m_135827_())), false);
            return;
        }
        matcher = EXPORT_TEMPLATE_PATH_PATTERN.matcher(templateName.m_135815_());
        if (!matcher.matches()) {
            player.m_5661_((Component)INVALID_CHARACTER.apply(BackpackTemplates.findNonMatchingCharacters(matcher, templateName.m_135815_())), false);
            return;
        }
        ServerLevel serverLevel = player.m_284548_();
        Path datapacksDir = serverLevel.m_7654_().m_129843_(LevelResource.f_78180_);
        Path datapackRoot = datapacksDir.resolve(templateName.m_135827_() + "_backpack_templates");
        if (!BackpackTemplates.initDatapackStructure(datapackRoot, templatesDir = datapackRoot.resolve("data/" + templateName.m_135827_() + "/sophisticatedbackpacks_templates"))) {
            return;
        }
        String fileName = templateName.m_135815_();
        Path exportPath = templatesDir.resolve(fileName + ".snbt");
        try {
            NbtToSnbt.m_236377_((CachedOutput)CachedOutput.f_236016_, (Path)exportPath, (String)new SnbtPrinterTagVisitor().m_178141_((Tag)contentNbt));
        }
        catch (IOException e) {
            SophisticatedCore.LOGGER.error("Error writing template export", (Throwable)e);
            return;
        }
        DatapackSettingsTemplateManager.putTemplate((String)templateName.m_135827_(), (String)fileName, (CompoundTag)contentNbt);
        player.m_5661_((Component)Component.m_237110_((String)"commands.sophisticatedbackpacks.template.export.success", (Object[])new Object[]{serverLevel.m_7654_().m_129843_(LevelResource.f_78182_).relativize(exportPath).toString()}), false);
    }

    public static String findNonMatchingCharacters(Matcher matcher, String input) {
        StringBuilder nonMatchingCharacters = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (matcher.reset(String.valueOf(c)).matches()) continue;
            nonMatchingCharacters.append(c);
        }
        return nonMatchingCharacters.toString();
    }

    private static boolean initDatapackStructure(Path datapackRoot, Path templatesDir) {
        try {
            Files.createDirectories(templatesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            SophisticatedCore.LOGGER.error("Error creating directory for template export", (Throwable)e);
            return false;
        }
        Path packMcmetaFile = datapackRoot.resolve("pack.mcmeta");
        if (!Files.exists(packMcmetaFile, new LinkOption[0])) {
            try {
                Files.writeString(packMcmetaFile, (CharSequence)"{\n    \"pack\": {\n        \"pack_format\": 15,\n        \"description\": \"Sophisticated Backpacks Templates data pack\"\n    }\n}\n", new OpenOption[0]);
            }
            catch (IOException e) {
                SophisticatedCore.LOGGER.error("Error creating pack.mcmeta for template export", (Throwable)e);
                return false;
            }
        }
        return true;
    }
}

