/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.function.Supplier;
import mod.chiselsandbits.api.config.ICommonConfiguration;
import mod.chiselsandbits.utils.SimpleMaxSizedCache;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClassUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final SimpleMaxSizedCache<Key, Class<?>> CACHE = new SimpleMaxSizedCache(((Supplier<Long>)ICommonConfiguration.getInstance().getClassMetadataCacheSize())::get);

    private ClassUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: ClassUtils. This is a utility class");
    }

    public static Class<?> getDeclaringClass(Class<?> blkClass, String methodName, Class<?> ... args) {
        return CACHE.get(new Key(blkClass, methodName, args), () -> {
            try {
                return blkClass.getMethod(methodName, args).getDeclaringClass();
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (Throwable e) {
                return blkClass;
            }
            return ClassUtils.getDeclaringClass(blkClass.getSuperclass(), methodName, args);
        });
    }

    private record Key(Class<?> sourceClass, String methodName, Class<?>[] args) {
    }
}

