/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.chiseling.ChiselingOperation;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.metadata.IMetadataKey;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.item.chisel.IChiselingItem;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.IMutatorFactory;
import mod.chiselsandbits.api.multistate.mutator.world.IWorldAreaMutator;
import mod.chiselsandbits.api.permissions.IPermissionHandler;
import mod.chiselsandbits.api.util.VectorUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ChiselingContext
implements IChiselingContext {
    private final LevelAccessor world;
    private final IChiselMode chiselMode;
    private final ChiselingOperation modeOfOperandus;
    private final boolean simulation;
    private final Runnable onCompleteCallback;
    private final boolean supportsDamaging;
    private final Player playerEntity;
    private boolean complete = false;
    private IWorldAreaMutator mutator = null;
    private Function<IAreaAccessor, Predicate<IStateEntryInfo>> filterBuilder = null;
    private Map<IMetadataKey<?>, Object> metadataKeyMap = Maps.newHashMap();
    private ItemStack causingItemStack;
    private MutableComponent error = null;

    public ChiselingContext(LevelAccessor world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean simulation, Runnable onCompleteCallback, ItemStack causingItemStack, Player playerEntity) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.simulation = simulation;
        this.onCompleteCallback = onCompleteCallback;
        this.modeOfOperandus = modeOfOperandus;
        this.causingItemStack = causingItemStack;
        this.supportsDamaging = this.causingItemStack.m_41720_() instanceof IChiselingItem ? ((IChiselingItem)this.causingItemStack.m_41720_()).isDamageableDuringChiseling() : false;
        this.playerEntity = playerEntity;
    }

    private ChiselingContext(LevelAccessor world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean complete, IWorldAreaMutator mutator, Player playerEntity, MutableComponent error) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.causingItemStack = ItemStack.f_41583_;
        this.supportsDamaging = false;
        this.onCompleteCallback = () -> {};
        this.simulation = true;
        this.modeOfOperandus = modeOfOperandus;
        this.complete = complete;
        this.mutator = mutator;
        this.playerEntity = playerEntity;
        this.error = error;
    }

    private ChiselingContext(LevelAccessor world, IChiselMode chiselMode, ChiselingOperation modeOfOperandus, boolean complete, Player playerEntity, MutableComponent error) {
        this.world = world;
        this.chiselMode = chiselMode;
        this.causingItemStack = ItemStack.f_41583_;
        this.supportsDamaging = false;
        this.onCompleteCallback = () -> {};
        this.simulation = true;
        this.modeOfOperandus = modeOfOperandus;
        this.complete = complete;
        this.playerEntity = playerEntity;
        this.error = error;
    }

    private void setMetadataKeyMap(Map<IMetadataKey<?>, Object> metadataKeyMap) {
        this.metadataKeyMap = metadataKeyMap;
    }

    @Override
    @NotNull
    public Optional<IWorldAreaMutator> getMutator() {
        if (this.mutator == null || this.playerEntity == null || !(this.world instanceof Level)) {
            return Optional.ofNullable(this.mutator);
        }
        if (!IPermissionHandler.getInstance().canManipulate(this.playerEntity, this.mutator)) {
            this.mutator = null;
            return Optional.empty();
        }
        return Optional.of(this.mutator);
    }

    @Override
    @NotNull
    public LevelAccessor getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public IChiselMode getMode() {
        return this.chiselMode;
    }

    @Override
    @NotNull
    public IChiselingContext include(Vec3 worldPosition) {
        if (this.getMutator().map(m -> !m.isInside(worldPosition)).orElse(true).booleanValue()) {
            if (this.getMutator().isPresent()) {
                IWorldAreaMutator worldAreaMutator = this.getMutator().get();
                Vec3 start = new Vec3(Math.min(worldPosition.m_7096_(), worldAreaMutator.getInWorldStartPoint().m_7096_()), Math.min(worldPosition.m_7098_(), worldAreaMutator.getInWorldStartPoint().m_7098_()), Math.min(worldPosition.m_7094_(), worldAreaMutator.getInWorldStartPoint().m_7094_()));
                Vec3 end = new Vec3(Math.max(worldPosition.m_7096_(), worldAreaMutator.getInWorldEndPoint().m_7096_()), Math.max(worldPosition.m_7098_(), worldAreaMutator.getInWorldEndPoint().m_7098_()), Math.max(worldPosition.m_7094_(), worldAreaMutator.getInWorldEndPoint().m_7094_()));
                this.mutator = IMutatorFactory.getInstance().covering(this.world, start, end);
            } else {
                this.mutator = IMutatorFactory.getInstance().covering(this.world, worldPosition, worldPosition);
            }
        }
        return this;
    }

    @Override
    public void setComplete() {
        this.complete = true;
        this.onCompleteCallback.run();
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public boolean isSimulation() {
        return this.simulation;
    }

    @Override
    @NotNull
    public ChiselingOperation getModeOfOperandus() {
        return this.modeOfOperandus;
    }

    @Override
    @NotNull
    public IChiselingContext createSnapshot() {
        ChiselingContext context = this.createInnerSnapshot();
        HashMap newMetadata = Maps.newHashMap();
        for (IMetadataKey<?> key : this.metadataKeyMap.keySet()) {
            Optional<?> value = this.snapshotMetadata(key);
            value.ifPresent(o -> newMetadata.put(key, o));
        }
        context.setMetadataKeyMap(newMetadata);
        return context;
    }

    @NotNull
    private ChiselingContext createInnerSnapshot() {
        if (this.mutator == null) {
            return new ChiselingContext(this.world, this.chiselMode, this.modeOfOperandus, this.complete, this.playerEntity, this.error);
        }
        return new ChiselingContext(this.world, this.chiselMode, this.modeOfOperandus, this.complete, IMutatorFactory.getInstance().covering(this.world, this.mutator.getInWorldStartPoint(), this.mutator.getInWorldEndPoint()), this.playerEntity, this.error);
    }

    private <T> Optional<T> snapshotMetadata(IMetadataKey<T> key) {
        Optional<Object> value = this.getMetadata(key);
        return value.map(key::snapshot);
    }

    @Override
    public int tryDamageItemAndDo(int damage, Runnable onDamaged, Runnable onBroken) {
        if (!this.supportsDamaging || this.simulation) {
            onDamaged.run();
            return damage;
        }
        if (this.causingItemStack.m_41619_()) {
            onBroken.run();
            return 0;
        }
        AtomicBoolean broken = new AtomicBoolean(false);
        int currentDamage = this.causingItemStack.m_41773_();
        this.causingItemStack.m_41622_(damage, (LivingEntity)this.playerEntity, playerEntity -> {
            broken.set(true);
            InteractionHand hand = InteractionHand.MAIN_HAND;
            if (playerEntity.m_21206_() == this.causingItemStack) {
                hand = InteractionHand.OFF_HAND;
            }
            playerEntity.m_21190_(hand);
        });
        onDamaged.run();
        if (broken.get()) {
            this.causingItemStack = ItemStack.f_41583_;
        }
        return Math.min(damage, currentDamage);
    }

    @Override
    public void setStateFilter(@NotNull Function<IAreaAccessor, Predicate<IStateEntryInfo>> filter) {
        this.filterBuilder = filter;
    }

    @Override
    public void clearStateFilter() {
        this.filterBuilder = null;
    }

    @Override
    public Optional<Function<IAreaAccessor, Predicate<IStateEntryInfo>>> getStateFilter() {
        return Optional.ofNullable(this.filterBuilder);
    }

    @Override
    public <T> Optional<T> getMetadata(IMetadataKey<T> key) {
        Object value = this.metadataKeyMap.get(key);
        if (value == null) {
            return Optional.empty();
        }
        try {
            Object castValue = value;
            return Optional.ofNullable(castValue);
        }
        catch (ClassCastException e) {
            return Optional.empty();
        }
    }

    @Override
    public void removeMetadata(IMetadataKey<?> key) {
        this.metadataKeyMap.remove(key);
    }

    @Override
    public <T> void setMetadata(IMetadataKey<T> key, T value) {
        this.metadataKeyMap.put(key, value);
    }

    @Override
    public void resetMutator() {
        this.mutator = null;
    }

    @Override
    public void setError(MutableComponent errorText) {
        this.error = errorText;
    }

    @Override
    public Optional<MutableComponent> getError() {
        return Optional.ofNullable(this.error);
    }

    @Override
    public Optional<IStateEntryInfo> getInAreaTarget(Vec3 inAreaTarget) {
        if (this.getMutator().isPresent() && this.getMutator().map(m -> m.isInside(inAreaTarget)).orElse(false).booleanValue()) {
            return this.getMutator().flatMap(m -> m.getInAreaTarget(inAreaTarget));
        }
        BlockPos position = VectorUtils.toBlockPos(inAreaTarget);
        Vec3 inBlockOffset = inAreaTarget.m_82492_((double)position.m_123341_(), (double)position.m_123342_(), (double)position.m_123343_());
        return IMutatorFactory.getInstance().in(this.getWorld(), position).getInAreaTarget(inBlockOffset);
    }

    @Override
    public Optional<IStateEntryInfo> getInBlockTarget(BlockPos inAreaBlockPosOffset, Vec3 inBlockTarget) {
        return this.getInAreaTarget(Vec3.m_82528_((Vec3i)inAreaBlockPosOffset).m_82549_(inBlockTarget));
    }
}

