/*
 * Decompiled with CFR 0.152.
 */
package net.davio.aquaticambitions.registry;

import java.util.Collections;
import net.createmod.catnip.lang.Lang;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class CAATags {
    public static <T> TagKey<T> optionalTag(IForgeRegistry<T> registry, ResourceLocation id) {
        return registry.tags().createOptionalTagKey(id, Collections.emptySet());
    }

    public static <T> TagKey<T> forgeTag(IForgeRegistry<T> registry, String path) {
        return CAATags.optionalTag(registry, new ResourceLocation("forge", path));
    }

    public static TagKey<Block> forgeBlockTag(String path) {
        return CAATags.forgeTag(ForgeRegistries.BLOCKS, path);
    }

    public static TagKey<Item> forgeItemTag(String path) {
        return CAATags.forgeTag(ForgeRegistries.ITEMS, path);
    }

    public static TagKey<Fluid> forgeFluidTag(String path) {
        return CAATags.forgeTag(ForgeRegistries.FLUIDS, path);
    }

    public static void init() {
        CAABlockTags.init();
        CAAItemTags.init();
        CAAFluidTags.init();
    }

    public static enum CAABlockTags {
        FAN_PROCESSING_CATALYSTS_CHANNELING(NameSpace.MOD, "fan_processing_catalysts/channeling");

        public final TagKey<Block> tag;
        public final boolean alwaysDatagen;

        private CAABlockTags() {
            this(NameSpace.MOD);
        }

        private CAABlockTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAABlockTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAABlockTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CAABlockTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CAATags.optionalTag(ForgeRegistries.BLOCKS, id) : BlockTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Block block) {
            return block.m_204297_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            BlockItem blockItem;
            Item item;
            return stack != null && (item = stack.m_41720_()) instanceof BlockItem && this.matches((blockItem = (BlockItem)item).m_40614_());
        }

        public boolean matches(BlockState state) {
            return state.m_204336_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CAAItemTags {
        UA_CORAL(NameSpace.MOD, "upgrade_aquatic/coral");

        public final TagKey<Item> tag;
        public final boolean alwaysDatagen;

        private CAAItemTags() {
            this(NameSpace.MOD);
        }

        private CAAItemTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAItemTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAItemTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CAAItemTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CAATags.optionalTag(ForgeRegistries.ITEMS, id) : ItemTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Item item) {
            return item.m_204114_().m_203656_(this.tag);
        }

        public boolean matches(ItemStack stack) {
            return stack.m_204117_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum CAAFluidTags {
        CONDUIT_FUEL(NameSpace.MOD, "mechanical_conduit_fuel"),
        GIVES_FIRE_RES(NameSpace.MOD, "conduit_effects/gives_fire_resistance"),
        GIVES_HASTE(NameSpace.MOD, "conduit_effects/gives_haste"),
        GIVES_INFESTED(NameSpace.MOD, "conduit_effects/gives_infested"),
        GIVES_INVIS(NameSpace.MOD, "conduit_effects/gives_invisibility"),
        GIVES_JUMP(NameSpace.MOD, "conduit_effects/gives_jump"),
        GIVES_LUCK(NameSpace.MOD, "conduit_effects/gives_luck"),
        GIVES_NIGHT_VISION(NameSpace.MOD, "conduit_effects/gives_night_vision"),
        GIVES_OOZING(NameSpace.MOD, "conduit_effects/gives_oozing"),
        GIVES_POISON(NameSpace.MOD, "conduit_effects/gives_poison"),
        GIVES_REGEN(NameSpace.MOD, "conduit_effects/gives_regen"),
        GIVES_RESISTANCE(NameSpace.MOD, "conduit_effects/gives_resistance"),
        GIVES_SLOW_FALL(NameSpace.MOD, "conduit_effects/gives_slow_fall"),
        GIVES_SLOWNESS(NameSpace.MOD, "conduit_effects/gives_slowness"),
        GIVES_SPEED(NameSpace.MOD, "conduit_effects/gives_speed"),
        GIVES_STRENGTH(NameSpace.MOD, "conduit_effects/gives_strength"),
        GIVES_WATER_BREATHING(NameSpace.MOD, "conduit_effects/gives_water_breathing"),
        GIVES_WEAKNESS(NameSpace.MOD, "conduit_effects/gives_weakness"),
        GIVES_WEAVING(NameSpace.MOD, "conduit_effects/gives_weaving"),
        GIVES_WIND(NameSpace.MOD, "conduit_effects/gives_wind"),
        GIVES_WITHER(NameSpace.MOD, "conduit_effects/gives_wither"),
        GIVES_SATURATION(NameSpace.MOD, "conduit_effects/gives_saturation"),
        SETS_ON_FIRE(NameSpace.MOD, "conduit_effects/sets_on_fire"),
        FAN_PROCESSING_CATALYSTS_CHANNELING(NameSpace.MOD, "fan_processing_catalysts/channeling");

        public final TagKey<Fluid> tag;
        public final boolean alwaysDatagen;

        private CAAFluidTags() {
            this(NameSpace.MOD);
        }

        private CAAFluidTags(NameSpace namespace) {
            this(namespace, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAFluidTags(NameSpace namespace, String path) {
            this(namespace, path, namespace.optionalDefault, namespace.alwaysDatagenDefault);
        }

        private CAAFluidTags(NameSpace namespace, boolean optional, boolean alwaysDatagen) {
            this(namespace, null, optional, alwaysDatagen);
        }

        private CAAFluidTags(NameSpace namespace, String path, boolean optional, boolean alwaysDatagen) {
            ResourceLocation id = new ResourceLocation(namespace.id, path == null ? Lang.asId((String)this.name()) : path);
            this.tag = optional ? CAATags.optionalTag(ForgeRegistries.FLUIDS, id) : FluidTags.create((ResourceLocation)id);
            this.alwaysDatagen = alwaysDatagen;
        }

        public boolean matches(Fluid fluid) {
            return fluid.m_205067_(this.tag);
        }

        public boolean matches(FluidState state) {
            return state.m_205070_(this.tag);
        }

        private static void init() {
        }
    }

    public static enum NameSpace {
        MOD("create_aquatic_ambitions", false, true),
        COMMON("c"),
        FORGE("forge"),
        CREATE("create");

        public final String id;
        public final boolean optionalDefault;
        public final boolean alwaysDatagenDefault;

        private NameSpace(String id) {
            this(id, true, false);
        }

        private NameSpace(String id, boolean optionalDefault, boolean alwaysDatagenDefault) {
            this.id = id;
            this.optionalDefault = optionalDefault;
            this.alwaysDatagenDefault = alwaysDatagenDefault;
        }
    }
}

